/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.CertificatePolicyMap;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public class PolicyMappingsExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.PolicyMappings";
    public static final String NAME = "PolicyMappings";
    public static final String MAP = "map";
    private List<CertificatePolicyMap> maps;

    private void encodeThis() throws IOException {
        if (this.maps == null || this.maps.isEmpty()) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream os = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        for (CertificatePolicyMap map : this.maps) {
            map.encode(tmp);
        }
        os.write((byte)48, tmp);
        this.extensionValue = os.toByteArray();
    }

    public PolicyMappingsExtension(List<CertificatePolicyMap> maps) throws IOException {
        this.maps = maps;
        this.extensionId = PKIXExtensions.PolicyMappings_Id;
        this.critical = true;
        this.encodeThis();
    }

    public PolicyMappingsExtension() {
        this.extensionId = PKIXExtensions.PolicyMappings_Id;
        this.critical = true;
        this.maps = Collections.emptyList();
    }

    public PolicyMappingsExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.PolicyMappings_Id;
        this.critical = critical;
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for PolicyMappingsExtension.");
        }
        this.maps = new ArrayList<CertificatePolicyMap>();
        while (val.data.available() != 0) {
            DerValue seq = val.data.getDerValue();
            CertificatePolicyMap map = new CertificatePolicyMap(seq);
            this.maps.add(map);
        }
    }

    @Override
    public String toString() {
        if (this.maps == null) {
            return "";
        }
        String s = super.toString() + "PolicyMappings [\n" + this.maps.toString() + "]\n";
        return s;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.PolicyMappings_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (name.equalsIgnoreCase(MAP)) {
            if (!(obj instanceof List)) {
                throw new IOException("Attribute value should be of type List.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
        }
        this.maps = (List)obj;
        this.encodeThis();
    }

    @Override
    public List<CertificatePolicyMap> get(String name) throws IOException {
        if (name.equalsIgnoreCase(MAP)) {
            return this.maps;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(MAP)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
        }
        this.maps = null;
        this.encodeThis();
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(MAP);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

