/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.Locale;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNameInterface;

public class RFC822Name
implements GeneralNameInterface {
    private String name;

    public RFC822Name(DerValue derValue) throws IOException {
        this.name = derValue.getIA5String();
        this.parseName(this.name);
    }

    public RFC822Name(String name) throws IOException {
        this.parseName(name);
        this.name = name;
    }

    public void parseName(String name) throws IOException {
        if (name == null || name.isEmpty()) {
            throw new IOException("RFC822Name may not be null or empty");
        }
        String domain = name.substring(name.indexOf(64) + 1);
        if (domain.isEmpty()) {
            throw new IOException("RFC822Name may not end with @");
        }
        if (domain.startsWith(".") && domain.length() == 1) {
            throw new IOException("RFC822Name domain may not be just .");
        }
    }

    @Override
    public int getType() {
        return 1;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        out.putIA5String(this.name);
    }

    public String toString() {
        return "RFC822Name: " + this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RFC822Name)) {
            return false;
        }
        RFC822Name other = (RFC822Name)obj;
        return this.name.equalsIgnoreCase(other.name);
    }

    public int hashCode() {
        return this.name.toUpperCase(Locale.ENGLISH).hashCode();
    }

    @Override
    public int constrains(GeneralNameInterface inputName) throws UnsupportedOperationException {
        int ndx;
        int inNdx;
        String thisName;
        String inName;
        int constraintType = inputName == null ? -1 : (inputName.getType() != 1 ? -1 : ((inName = ((RFC822Name)inputName).getName().toLowerCase(Locale.ENGLISH)).equals(thisName = this.name.toLowerCase(Locale.ENGLISH)) ? 0 : (thisName.endsWith(inName) ? (inName.indexOf(64) != -1 ? 3 : (inName.startsWith(".") ? 2 : (thisName.charAt((inNdx = thisName.lastIndexOf(inName)) - 1) == '@' ? 2 : 3))) : (inName.endsWith(thisName) ? (thisName.indexOf(64) != -1 ? 3 : (thisName.startsWith(".") ? 1 : (inName.charAt((ndx = inName.lastIndexOf(thisName)) - 1) == '@' ? 1 : 3))) : 3))));
        return constraintType;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        String subtree = this.name;
        int i = 1;
        int atNdx = subtree.lastIndexOf(64);
        if (atNdx >= 0) {
            ++i;
            subtree = subtree.substring(atNdx + 1);
        }
        while (subtree.lastIndexOf(46) >= 0) {
            subtree = subtree.substring(0, subtree.lastIndexOf(46));
            ++i;
        }
        return i;
    }
}

