/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.CRLReason;
import java.security.cert.X509CRLEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.HexDumpEncoder;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.CRLExtensions;
import sun.security.x509.CRLReasonCodeExtension;
import sun.security.x509.CertificateIssuerExtension;
import sun.security.x509.Extension;
import sun.security.x509.OIDMap;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.SerialNumber;

public class X509CRLEntryImpl
extends X509CRLEntry
implements Comparable<X509CRLEntryImpl> {
    private SerialNumber serialNumber = null;
    private Date revocationDate = null;
    private CRLExtensions extensions = null;
    private byte[] revokedCert = null;
    private X500Principal certIssuer;
    private static final boolean isExplicit = false;

    public X509CRLEntryImpl(BigInteger num, Date date) {
        this.serialNumber = new SerialNumber(num);
        this.revocationDate = date;
    }

    public X509CRLEntryImpl(BigInteger num, Date date, CRLExtensions crlEntryExts) {
        this.serialNumber = new SerialNumber(num);
        this.revocationDate = date;
        this.extensions = crlEntryExts;
    }

    public X509CRLEntryImpl(byte[] revokedCert) throws CRLException {
        try {
            this.parse(new DerValue(revokedCert));
        }
        catch (IOException e) {
            this.revokedCert = null;
            throw new CRLException("Parsing error: " + e.toString());
        }
    }

    public X509CRLEntryImpl(DerValue derValue) throws CRLException {
        try {
            this.parse(derValue);
        }
        catch (IOException e) {
            this.revokedCert = null;
            throw new CRLException("Parsing error: " + e.toString());
        }
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public void encode(DerOutputStream outStrm) throws CRLException {
        try {
            if (this.revokedCert == null) {
                DerOutputStream tmp = new DerOutputStream();
                this.serialNumber.encode(tmp);
                if (this.revocationDate.getTime() < 2524608000000L) {
                    tmp.putUTCTime(this.revocationDate);
                } else {
                    tmp.putGeneralizedTime(this.revocationDate);
                }
                if (this.extensions != null) {
                    this.extensions.encode(tmp, false);
                }
                DerOutputStream seq = new DerOutputStream();
                seq.write((byte)48, tmp);
                this.revokedCert = seq.toByteArray();
            }
            outStrm.write(this.revokedCert);
        }
        catch (IOException e) {
            throw new CRLException("Encoding error: " + e.toString());
        }
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        return (byte[])this.getEncoded0().clone();
    }

    private byte[] getEncoded0() throws CRLException {
        if (this.revokedCert == null) {
            this.encode(new DerOutputStream());
        }
        return this.revokedCert;
    }

    @Override
    public X500Principal getCertificateIssuer() {
        return this.certIssuer;
    }

    void setCertificateIssuer(X500Principal crlIssuer, X500Principal certIssuer) {
        this.certIssuer = crlIssuer.equals(certIssuer) ? null : certIssuer;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.serialNumber.getNumber();
    }

    @Override
    public Date getRevocationDate() {
        return new Date(this.revocationDate.getTime());
    }

    @Override
    public CRLReason getRevocationReason() {
        Extension ext = this.getExtension(PKIXExtensions.ReasonCode_Id);
        if (ext == null) {
            return null;
        }
        CRLReasonCodeExtension rcExt = (CRLReasonCodeExtension)ext;
        return rcExt.getReasonCode();
    }

    public static CRLReason getRevocationReason(X509CRLEntry crlEntry) {
        try {
            byte[] ext = crlEntry.getExtensionValue(KnownOIDs.ReasonCode.value());
            if (ext == null) {
                return null;
            }
            DerValue val = new DerValue(ext);
            byte[] data = val.getOctetString();
            CRLReasonCodeExtension rcExt = new CRLReasonCodeExtension(Boolean.FALSE, data);
            return rcExt.getReasonCode();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Integer getReasonCode() throws IOException {
        Extension obj = this.getExtension(PKIXExtensions.ReasonCode_Id);
        if (obj == null) {
            return null;
        }
        CRLReasonCodeExtension reasonCode = (CRLReasonCodeExtension)obj;
        return reasonCode.get("reason");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.serialNumber).append("  On: ").append(this.revocationDate);
        if (this.certIssuer != null) {
            sb.append("\n    Certificate issuer: ").append(this.certIssuer);
        }
        if (this.extensions != null) {
            Collection<Extension> allEntryExts = this.extensions.getAllExtensions();
            Extension[] exts = allEntryExts.toArray(new Extension[0]);
            sb.append("\n    CRL Entry Extensions: ").append(exts.length);
            for (int i = 0; i < exts.length; ++i) {
                sb.append("\n    [").append(i + 1).append("]: ");
                Extension ext = exts[i];
                try {
                    if (OIDMap.getClass(ext.getExtensionId()) == null) {
                        sb.append(ext);
                        byte[] extValue = ext.getExtensionValue();
                        if (extValue == null) continue;
                        DerOutputStream out = new DerOutputStream();
                        out.putOctetString(extValue);
                        extValue = out.toByteArray();
                        HexDumpEncoder enc = new HexDumpEncoder();
                        sb.append("Extension unknown: ").append("DER encoded OCTET string =\n").append(enc.encodeBuffer(extValue)).append('\n');
                        continue;
                    }
                    sb.append(ext);
                    continue;
                }
                catch (Exception e) {
                    sb.append(", Error parsing this extension");
                }
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        if (this.extensions == null) {
            return false;
        }
        return this.extensions.hasUnsupportedCriticalExtension();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        TreeSet<String> extSet = new TreeSet<String>();
        for (Extension ex : this.extensions.getAllExtensions()) {
            if (!ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        return extSet;
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        TreeSet<String> extSet = new TreeSet<String>();
        for (Extension ex : this.extensions.getAllExtensions()) {
            if (ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        return extSet;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        if (this.extensions == null) {
            return null;
        }
        try {
            String extAlias = OIDMap.getName(ObjectIdentifier.of(oid));
            Extension crlExt = null;
            if (extAlias == null) {
                ObjectIdentifier findOID = ObjectIdentifier.of(oid);
                Extension ex = null;
                Enumeration<Extension> e = this.extensions.getElements();
                while (e.hasMoreElements()) {
                    ex = e.nextElement();
                    ObjectIdentifier inCertOID = ex.getExtensionId();
                    if (!inCertOID.equals(findOID)) continue;
                    crlExt = ex;
                    break;
                }
            } else {
                crlExt = this.extensions.get(extAlias);
            }
            if (crlExt == null) {
                return null;
            }
            byte[] extData = crlExt.getExtensionValue();
            if (extData == null) {
                return null;
            }
            DerOutputStream out = new DerOutputStream();
            out.putOctetString(extData);
            return out.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Extension getExtension(ObjectIdentifier oid) {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.get(OIDMap.getName(oid));
    }

    private void parse(DerValue derVal) throws CRLException, IOException {
        if (derVal.tag != 48) {
            throw new CRLException("Invalid encoded RevokedCertificate, starting sequence tag missing.");
        }
        if (derVal.data.available() == 0) {
            throw new CRLException("No data encoded for RevokedCertificates");
        }
        this.revokedCert = derVal.toByteArray();
        DerInputStream in = derVal.toDerInputStream();
        DerValue val = in.getDerValue();
        this.serialNumber = new SerialNumber(val);
        int nextByte = derVal.data.peekByte();
        if ((byte)nextByte == 23) {
            this.revocationDate = derVal.data.getUTCTime();
        } else if ((byte)nextByte == 24) {
            this.revocationDate = derVal.data.getGeneralizedTime();
        } else {
            throw new CRLException("Invalid encoding for revocation date");
        }
        if (derVal.data.available() == 0) {
            return;
        }
        this.extensions = new CRLExtensions(derVal.toDerInputStream());
    }

    public static X509CRLEntryImpl toImpl(X509CRLEntry entry) throws CRLException {
        if (entry instanceof X509CRLEntryImpl) {
            return (X509CRLEntryImpl)entry;
        }
        return new X509CRLEntryImpl(entry.getEncoded());
    }

    CertificateIssuerExtension getCertificateIssuerExtension() {
        return (CertificateIssuerExtension)this.getExtension(PKIXExtensions.CertificateIssuer_Id);
    }

    public Map<String, java.security.cert.Extension> getExtensions() {
        if (this.extensions == null) {
            return Collections.emptyMap();
        }
        Collection<Extension> exts = this.extensions.getAllExtensions();
        TreeMap<String, java.security.cert.Extension> map = new TreeMap<String, java.security.cert.Extension>();
        for (Extension ext : exts) {
            map.put(ext.getId(), ext);
        }
        return map;
    }

    @Override
    public int compareTo(X509CRLEntryImpl that) {
        int compSerial = this.getSerialNumber().compareTo(that.getSerialNumber());
        if (compSerial != 0) {
            return compSerial;
        }
        try {
            byte[] thisEncoded = this.getEncoded0();
            byte[] thatEncoded = that.getEncoded0();
            for (int i = 0; i < thisEncoded.length && i < thatEncoded.length; ++i) {
                int a = thisEncoded[i] & 0xFF;
                int b = thatEncoded[i] & 0xFF;
                if (a == b) continue;
                return a - b;
            }
            return thisEncoded.length - thatEncoded.length;
        }
        catch (CRLException ce) {
            return -1;
        }
    }
}

