/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.HexDumpEncoder;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.Extension;
import sun.security.x509.GeneralNames;
import sun.security.x509.OIDMap;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.UniqueIdentity;
import sun.security.x509.X500Name;
import sun.security.x509.X509AttributeName;

public class X509CertInfo
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info";
    public static final String NAME = "info";
    public static final String DN_NAME = "dname";
    public static final String VERSION = "version";
    public static final String SERIAL_NUMBER = "serialNumber";
    public static final String ALGORITHM_ID = "algorithmID";
    public static final String ISSUER = "issuer";
    public static final String SUBJECT = "subject";
    public static final String VALIDITY = "validity";
    public static final String KEY = "key";
    public static final String ISSUER_ID = "issuerID";
    public static final String SUBJECT_ID = "subjectID";
    public static final String EXTENSIONS = "extensions";
    protected CertificateVersion version = new CertificateVersion();
    protected CertificateSerialNumber serialNum = null;
    protected CertificateAlgorithmId algId = null;
    protected X500Name issuer = null;
    protected X500Name subject = null;
    protected CertificateValidity interval = null;
    protected CertificateX509Key pubKey = null;
    protected UniqueIdentity issuerUniqueId = null;
    protected UniqueIdentity subjectUniqueId = null;
    protected CertificateExtensions extensions = null;
    private static final int ATTR_VERSION = 1;
    private static final int ATTR_SERIAL = 2;
    private static final int ATTR_ALGORITHM = 3;
    private static final int ATTR_ISSUER = 4;
    private static final int ATTR_VALIDITY = 5;
    private static final int ATTR_SUBJECT = 6;
    private static final int ATTR_KEY = 7;
    private static final int ATTR_ISSUER_ID = 8;
    private static final int ATTR_SUBJECT_ID = 9;
    private static final int ATTR_EXTENSIONS = 10;
    private byte[] rawCertInfo = null;
    private static final Map<String, Integer> map = new HashMap<String, Integer>();

    public X509CertInfo() {
    }

    public X509CertInfo(byte[] cert) throws CertificateParsingException {
        try {
            DerValue in = new DerValue(cert);
            this.parse(in);
        }
        catch (IOException e) {
            throw new CertificateParsingException(e);
        }
    }

    public X509CertInfo(DerValue derVal) throws CertificateParsingException {
        try {
            this.parse(derVal);
        }
        catch (IOException e) {
            throw new CertificateParsingException(e);
        }
    }

    @Override
    public void encode(OutputStream out) throws CertificateException, IOException {
        if (this.rawCertInfo == null) {
            DerOutputStream tmp = new DerOutputStream();
            this.emit(tmp);
            this.rawCertInfo = tmp.toByteArray();
        }
        out.write((byte[])this.rawCertInfo.clone());
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(VERSION);
        elements.addElement(SERIAL_NUMBER);
        elements.addElement(ALGORITHM_ID);
        elements.addElement(ISSUER);
        elements.addElement(VALIDITY);
        elements.addElement(SUBJECT);
        elements.addElement(KEY);
        elements.addElement(ISSUER_ID);
        elements.addElement(SUBJECT_ID);
        elements.addElement(EXTENSIONS);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public byte[] getEncodedInfo() throws CertificateEncodingException {
        try {
            if (this.rawCertInfo == null) {
                DerOutputStream tmp = new DerOutputStream();
                this.emit(tmp);
                this.rawCertInfo = tmp.toByteArray();
            }
            return (byte[])this.rawCertInfo.clone();
        }
        catch (IOException e) {
            throw new CertificateEncodingException(e.toString());
        }
        catch (CertificateException e) {
            throw new CertificateEncodingException(e.toString());
        }
    }

    public boolean equals(Object other) {
        if (other instanceof X509CertInfo) {
            return this.equals((X509CertInfo)other);
        }
        return false;
    }

    public boolean equals(X509CertInfo other) {
        if (this == other) {
            return true;
        }
        if (this.rawCertInfo == null || other.rawCertInfo == null) {
            return false;
        }
        if (this.rawCertInfo.length != other.rawCertInfo.length) {
            return false;
        }
        for (int i = 0; i < this.rawCertInfo.length; ++i) {
            if (this.rawCertInfo[i] == other.rawCertInfo[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int retval = 0;
        for (int i = 1; i < this.rawCertInfo.length; ++i) {
            retval += this.rawCertInfo[i] * i;
        }
        return retval;
    }

    @Override
    public String toString() {
        if (this.subject == null || this.pubKey == null || this.interval == null || this.issuer == null || this.algId == null || this.serialNum == null) {
            throw new NullPointerException("X.509 cert is incomplete");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[\n").append("  ").append(this.version).append('\n').append("  Subject: ").append(this.subject).append('\n').append("  Signature Algorithm: ").append(this.algId).append('\n').append("  Key:  ").append(this.pubKey).append('\n').append("  ").append(this.interval).append('\n').append("  Issuer: ").append(this.issuer).append('\n').append("  ").append(this.serialNum).append('\n');
        if (this.issuerUniqueId != null) {
            sb.append("  Issuer Id:\n").append(this.issuerUniqueId).append('\n');
        }
        if (this.subjectUniqueId != null) {
            sb.append("  Subject Id:\n").append(this.subjectUniqueId).append('\n');
        }
        if (this.extensions != null) {
            Collection<Extension> allExts = this.extensions.getAllExtensions();
            Extension[] exts = allExts.toArray(new Extension[0]);
            sb.append("\nCertificate Extensions: ").append(exts.length);
            for (int i = 0; i < exts.length; ++i) {
                sb.append("\n[").append(i + 1).append("]: ");
                Extension ext = exts[i];
                try {
                    if (OIDMap.getClass(ext.getExtensionId()) == null) {
                        sb.append(ext);
                        byte[] extValue = ext.getExtensionValue();
                        if (extValue == null) continue;
                        DerOutputStream out = new DerOutputStream();
                        out.putOctetString(extValue);
                        extValue = out.toByteArray();
                        HexDumpEncoder enc = new HexDumpEncoder();
                        sb.append("Extension unknown: ").append("DER encoded OCTET string =\n").append(enc.encodeBuffer(extValue)).append('\n');
                        continue;
                    }
                    sb.append(ext);
                    continue;
                }
                catch (Exception e) {
                    sb.append(", Error parsing this extension");
                }
            }
            Map<String, Extension> invalid = this.extensions.getUnparseableExtensions();
            if (!invalid.isEmpty()) {
                sb.append("\nUnparseable certificate extensions: ").append(invalid.size());
                int i = 1;
                for (Extension ext : invalid.values()) {
                    sb.append("\n[").append(i++).append("]: ").append(ext);
                }
            }
        }
        sb.append("\n]");
        return sb.toString();
    }

    @Override
    public void set(String name, Object val) throws CertificateException, IOException {
        X509AttributeName attrName = new X509AttributeName(name);
        int attr = this.attributeMap(attrName.getPrefix());
        if (attr == 0) {
            throw new CertificateException("Attribute name not recognized: " + name);
        }
        this.rawCertInfo = null;
        String suffix = attrName.getSuffix();
        switch (attr) {
            case 1: {
                if (suffix == null) {
                    this.setVersion(val);
                    break;
                }
                this.version.set(suffix, val);
                break;
            }
            case 2: {
                if (suffix == null) {
                    this.setSerialNumber(val);
                    break;
                }
                this.serialNum.set(suffix, val);
                break;
            }
            case 3: {
                if (suffix == null) {
                    this.setAlgorithmId(val);
                    break;
                }
                this.algId.set(suffix, val);
                break;
            }
            case 4: {
                this.setIssuer(val);
                break;
            }
            case 5: {
                if (suffix == null) {
                    this.setValidity(val);
                    break;
                }
                this.interval.set(suffix, val);
                break;
            }
            case 6: {
                this.setSubject(val);
                break;
            }
            case 7: {
                if (suffix == null) {
                    this.setKey(val);
                    break;
                }
                this.pubKey.set(suffix, val);
                break;
            }
            case 8: {
                this.setIssuerUniqueId(val);
                break;
            }
            case 9: {
                this.setSubjectUniqueId(val);
                break;
            }
            case 10: {
                if (suffix == null) {
                    this.setExtensions(val);
                    break;
                }
                if (this.extensions == null) {
                    this.extensions = new CertificateExtensions();
                }
                this.extensions.set(suffix, val);
            }
        }
    }

    @Override
    public void delete(String name) throws CertificateException, IOException {
        X509AttributeName attrName = new X509AttributeName(name);
        int attr = this.attributeMap(attrName.getPrefix());
        if (attr == 0) {
            throw new CertificateException("Attribute name not recognized: " + name);
        }
        this.rawCertInfo = null;
        String suffix = attrName.getSuffix();
        switch (attr) {
            case 1: {
                if (suffix == null) {
                    this.version = null;
                    break;
                }
                this.version.delete(suffix);
                break;
            }
            case 2: {
                if (suffix == null) {
                    this.serialNum = null;
                    break;
                }
                this.serialNum.delete(suffix);
                break;
            }
            case 3: {
                if (suffix == null) {
                    this.algId = null;
                    break;
                }
                this.algId.delete(suffix);
                break;
            }
            case 4: {
                this.issuer = null;
                break;
            }
            case 5: {
                if (suffix == null) {
                    this.interval = null;
                    break;
                }
                this.interval.delete(suffix);
                break;
            }
            case 6: {
                this.subject = null;
                break;
            }
            case 7: {
                if (suffix == null) {
                    this.pubKey = null;
                    break;
                }
                this.pubKey.delete(suffix);
                break;
            }
            case 8: {
                this.issuerUniqueId = null;
                break;
            }
            case 9: {
                this.subjectUniqueId = null;
                break;
            }
            case 10: {
                if (suffix == null) {
                    this.extensions = null;
                    break;
                }
                if (this.extensions == null) break;
                this.extensions.delete(suffix);
            }
        }
    }

    @Override
    public Object get(String name) throws CertificateException, IOException {
        X509AttributeName attrName = new X509AttributeName(name);
        int attr = this.attributeMap(attrName.getPrefix());
        if (attr == 0) {
            throw new CertificateParsingException("Attribute name not recognized: " + name);
        }
        String suffix = attrName.getSuffix();
        switch (attr) {
            case 10: {
                if (suffix == null) {
                    return this.extensions;
                }
                if (this.extensions == null) {
                    return null;
                }
                return this.extensions.get(suffix);
            }
            case 6: {
                if (suffix == null) {
                    return this.subject;
                }
                return this.getX500Name(suffix, false);
            }
            case 4: {
                if (suffix == null) {
                    return this.issuer;
                }
                return this.getX500Name(suffix, true);
            }
            case 7: {
                if (suffix == null) {
                    return this.pubKey;
                }
                return this.pubKey.get(suffix);
            }
            case 3: {
                if (suffix == null) {
                    return this.algId;
                }
                return this.algId.get(suffix);
            }
            case 5: {
                if (suffix == null) {
                    return this.interval;
                }
                return this.interval.get(suffix);
            }
            case 1: {
                if (suffix == null) {
                    return this.version;
                }
                return this.version.get(suffix);
            }
            case 2: {
                if (suffix == null) {
                    return this.serialNum;
                }
                return this.serialNum.get(suffix);
            }
            case 8: {
                return this.issuerUniqueId;
            }
            case 9: {
                return this.subjectUniqueId;
            }
        }
        return null;
    }

    private Object getX500Name(String name, boolean getIssuer) throws IOException {
        if (name.equalsIgnoreCase(DN_NAME)) {
            return getIssuer ? this.issuer : this.subject;
        }
        if (name.equalsIgnoreCase("x500principal")) {
            return getIssuer ? this.issuer.asX500Principal() : this.subject.asX500Principal();
        }
        throw new IOException("Attribute name not recognized.");
    }

    private void parse(DerValue val) throws CertificateParsingException, IOException {
        if (val.tag != 48) {
            throw new CertificateParsingException("signed fields invalid");
        }
        this.rawCertInfo = val.toByteArray();
        DerInputStream in = val.data;
        DerValue tmp = in.getDerValue();
        if (tmp.isContextSpecific((byte)0)) {
            this.version = new CertificateVersion(tmp);
            tmp = in.getDerValue();
        }
        this.serialNum = new CertificateSerialNumber(tmp);
        this.algId = new CertificateAlgorithmId(in);
        this.issuer = new X500Name(in);
        if (this.issuer.isEmpty()) {
            throw new CertificateParsingException("Empty issuer DN not allowed in X509Certificates");
        }
        this.interval = new CertificateValidity(in);
        this.subject = new X500Name(in);
        if (this.version.compare(0) == 0 && this.subject.isEmpty()) {
            throw new CertificateParsingException("Empty subject DN not allowed in v1 certificate");
        }
        this.pubKey = new CertificateX509Key(in);
        if (in.available() != 0) {
            if (this.version.compare(0) == 0) {
                throw new CertificateParsingException("no more data allowed for version 1 certificate");
            }
        } else {
            return;
        }
        tmp = in.getDerValue();
        if (tmp.isContextSpecific((byte)1)) {
            this.issuerUniqueId = new UniqueIdentity(tmp);
            if (in.available() == 0) {
                return;
            }
            tmp = in.getDerValue();
        }
        if (tmp.isContextSpecific((byte)2)) {
            this.subjectUniqueId = new UniqueIdentity(tmp);
            if (in.available() == 0) {
                return;
            }
            tmp = in.getDerValue();
        }
        if (this.version.compare(2) != 0) {
            throw new CertificateParsingException("Extensions not allowed in v2 certificate");
        }
        if (tmp.isConstructed() && tmp.isContextSpecific((byte)3)) {
            this.extensions = new CertificateExtensions(tmp.data);
        }
        this.verifyCert(this.subject, this.extensions);
    }

    private void verifyCert(X500Name subject, CertificateExtensions extensions) throws CertificateParsingException, IOException {
        if (subject.isEmpty()) {
            if (extensions == null) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and certificate has no extensions");
            }
            SubjectAlternativeNameExtension subjectAltNameExt = null;
            Object extValue = null;
            GeneralNames names = null;
            try {
                subjectAltNameExt = (SubjectAlternativeNameExtension)extensions.get("SubjectAlternativeName");
                names = subjectAltNameExt.get("subject_name");
            }
            catch (IOException e) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and SubjectAlternativeName extension is absent");
            }
            if (names == null || names.isEmpty()) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and SubjectAlternativeName extension is empty");
            }
            if (!subjectAltNameExt.isCritical()) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: SubjectAlternativeName extension MUST be marked critical when subject field is empty");
            }
        }
    }

    private void emit(DerOutputStream out) throws CertificateException, IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.version.encode(tmp);
        this.serialNum.encode(tmp);
        this.algId.encode(tmp);
        if (this.version.compare(0) == 0 && this.issuer.toString() == null) {
            throw new CertificateParsingException("Null issuer DN not allowed in v1 certificate");
        }
        this.issuer.encode(tmp);
        this.interval.encode(tmp);
        if (this.version.compare(0) == 0 && this.subject.toString() == null) {
            throw new CertificateParsingException("Null subject DN not allowed in v1 certificate");
        }
        this.subject.encode(tmp);
        this.pubKey.encode(tmp);
        if (this.issuerUniqueId != null) {
            this.issuerUniqueId.encode(tmp, DerValue.createTag((byte)-128, false, (byte)1));
        }
        if (this.subjectUniqueId != null) {
            this.subjectUniqueId.encode(tmp, DerValue.createTag((byte)-128, false, (byte)2));
        }
        if (this.extensions != null) {
            this.extensions.encode(tmp);
        }
        out.write((byte)48, tmp);
    }

    private int attributeMap(String name) {
        Integer num = map.get(name);
        if (num == null) {
            return 0;
        }
        return num;
    }

    private void setVersion(Object val) throws CertificateException {
        if (!(val instanceof CertificateVersion)) {
            throw new CertificateException("Version class type invalid.");
        }
        this.version = (CertificateVersion)val;
    }

    private void setSerialNumber(Object val) throws CertificateException {
        if (!(val instanceof CertificateSerialNumber)) {
            throw new CertificateException("SerialNumber class type invalid.");
        }
        this.serialNum = (CertificateSerialNumber)val;
    }

    private void setAlgorithmId(Object val) throws CertificateException {
        if (!(val instanceof CertificateAlgorithmId)) {
            throw new CertificateException("AlgorithmId class type invalid.");
        }
        this.algId = (CertificateAlgorithmId)val;
    }

    private void setIssuer(Object val) throws CertificateException {
        if (!(val instanceof X500Name)) {
            throw new CertificateException("Issuer class type invalid.");
        }
        this.issuer = (X500Name)val;
    }

    private void setValidity(Object val) throws CertificateException {
        if (!(val instanceof CertificateValidity)) {
            throw new CertificateException("CertificateValidity class type invalid.");
        }
        this.interval = (CertificateValidity)val;
    }

    private void setSubject(Object val) throws CertificateException {
        if (!(val instanceof X500Name)) {
            throw new CertificateException("Subject class type invalid.");
        }
        this.subject = (X500Name)val;
    }

    private void setKey(Object val) throws CertificateException {
        if (!(val instanceof CertificateX509Key)) {
            throw new CertificateException("Key class type invalid.");
        }
        this.pubKey = (CertificateX509Key)val;
    }

    private void setIssuerUniqueId(Object val) throws CertificateException {
        if (this.version.compare(1) < 0) {
            throw new CertificateException("Invalid version");
        }
        if (!(val instanceof UniqueIdentity)) {
            throw new CertificateException("IssuerUniqueId class type invalid.");
        }
        this.issuerUniqueId = (UniqueIdentity)val;
    }

    private void setSubjectUniqueId(Object val) throws CertificateException {
        if (this.version.compare(1) < 0) {
            throw new CertificateException("Invalid version");
        }
        if (!(val instanceof UniqueIdentity)) {
            throw new CertificateException("SubjectUniqueId class type invalid.");
        }
        this.subjectUniqueId = (UniqueIdentity)val;
    }

    private void setExtensions(Object val) throws CertificateException {
        if (this.version.compare(2) < 0) {
            throw new CertificateException("Invalid version");
        }
        if (!(val instanceof CertificateExtensions)) {
            throw new CertificateException("Extensions class type invalid.");
        }
        this.extensions = (CertificateExtensions)val;
    }

    static {
        map.put(VERSION, 1);
        map.put(SERIAL_NUMBER, 2);
        map.put(ALGORITHM_ID, 3);
        map.put(ISSUER, 4);
        map.put(VALIDITY, 5);
        map.put(SUBJECT, 6);
        map.put(KEY, 7);
        map.put(ISSUER_ID, 8);
        map.put(SUBJECT_ID, 9);
        map.put(EXTENSIONS, 10);
    }
}

