/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.MissingResourceException;
import sun.text.CompactByteArray;
import sun.text.SupplementaryCharacterData;

class BreakDictionary {
    private static int supportedVersion = 1;
    private CompactByteArray columnMap = null;
    private SupplementaryCharacterData supplementaryCharColumnMap = null;
    private int numCols;
    private int numColGroups;
    private short[] table = null;
    private short[] rowIndex = null;
    private int[] rowIndexFlags = null;
    private short[] rowIndexFlagsIndex = null;
    private byte[] rowIndexShifts = null;

    BreakDictionary(String dictionaryName, byte[] dictionaryData) {
        try {
            this.setupDictionary(dictionaryName, dictionaryData);
        }
        catch (BufferUnderflowException bue) {
            MissingResourceException e = new MissingResourceException("Corrupted dictionary data", dictionaryName, "");
            e.initCause(bue);
            throw e;
        }
    }

    private void setupDictionary(String dictionaryName, byte[] dictionaryData) {
        int i;
        ByteBuffer bb = ByteBuffer.wrap(dictionaryData);
        int version = bb.getInt();
        if (version != supportedVersion) {
            throw new MissingResourceException("Dictionary version(" + version + ") is unsupported", dictionaryName, "");
        }
        int len = bb.getInt();
        if (bb.position() + len != bb.limit()) {
            throw new MissingResourceException("Dictionary size is wrong: " + bb.limit(), dictionaryName, "");
        }
        len = bb.getInt();
        short[] temp = new short[len];
        for (int i2 = 0; i2 < len; ++i2) {
            temp[i2] = bb.getShort();
        }
        len = bb.getInt();
        byte[] temp2 = new byte[len];
        bb.get(temp2);
        this.columnMap = new CompactByteArray(temp, temp2);
        this.numCols = bb.getInt();
        this.numColGroups = bb.getInt();
        len = bb.getInt();
        this.rowIndex = new short[len];
        for (i = 0; i < len; ++i) {
            this.rowIndex[i] = bb.getShort();
        }
        len = bb.getInt();
        this.rowIndexFlagsIndex = new short[len];
        for (i = 0; i < len; ++i) {
            this.rowIndexFlagsIndex[i] = bb.getShort();
        }
        len = bb.getInt();
        this.rowIndexFlags = new int[len];
        for (i = 0; i < len; ++i) {
            this.rowIndexFlags[i] = bb.getInt();
        }
        len = bb.getInt();
        this.rowIndexShifts = new byte[len];
        bb.get(this.rowIndexShifts);
        len = bb.getInt();
        this.table = new short[len];
        for (i = 0; i < len; ++i) {
            this.table[i] = bb.getShort();
        }
        len = bb.getInt();
        int[] temp3 = new int[len];
        for (int i3 = 0; i3 < len; ++i3) {
            temp3[i3] = bb.getInt();
        }
        assert (bb.position() == bb.limit());
        this.supplementaryCharColumnMap = new SupplementaryCharacterData(temp3);
    }

    public final short getNextStateFromCharacter(int row, int ch) {
        int col = ch < 65536 ? (int)this.columnMap.elementAt((char)ch) : this.supplementaryCharColumnMap.getValue(ch);
        return this.getNextState(row, col);
    }

    public final short getNextState(int row, int col) {
        if (this.cellIsPopulated(row, col)) {
            return this.internalAt(this.rowIndex[row], col + this.rowIndexShifts[row]);
        }
        return 0;
    }

    private boolean cellIsPopulated(int row, int col) {
        if (this.rowIndexFlagsIndex[row] < 0) {
            return col == -this.rowIndexFlagsIndex[row];
        }
        int flags = this.rowIndexFlags[this.rowIndexFlagsIndex[row] + (col >> 5)];
        return (flags & 1 << (col & 0x1F)) != 0;
    }

    private short internalAt(int row, int col) {
        return this.table[row * this.numCols + col];
    }
}

