/*
 * Decompiled with CFR 0.152.
 */
package sun.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import sun.util.locale.provider.CalendarDataUtility;

public class BuddhistCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = -8527488697350388578L;
    private static final int BUDDHIST_YEAR_OFFSET = 543;
    private transient int yearOffset = 543;

    public BuddhistCalendar() {
    }

    public BuddhistCalendar(TimeZone zone) {
        super(zone);
    }

    public BuddhistCalendar(Locale aLocale) {
        super(aLocale);
    }

    public BuddhistCalendar(TimeZone zone, Locale aLocale) {
        super(zone, aLocale);
    }

    @Override
    public String getCalendarType() {
        return "buddhist";
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof BuddhistCalendar && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ 0x21F;
    }

    @Override
    public int get(int field) {
        if (field == 1) {
            return super.get(field) + this.yearOffset;
        }
        return super.get(field);
    }

    @Override
    public void set(int field, int value) {
        if (field == 1) {
            super.set(field, value - this.yearOffset);
        } else {
            super.set(field, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int field, int amount) {
        int savedYearOffset = this.yearOffset;
        this.yearOffset = 0;
        try {
            super.add(field, amount);
        }
        finally {
            this.yearOffset = savedYearOffset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void roll(int field, int amount) {
        int savedYearOffset = this.yearOffset;
        this.yearOffset = 0;
        try {
            super.roll(field, amount);
        }
        finally {
            this.yearOffset = savedYearOffset;
        }
    }

    @Override
    public String getDisplayName(int field, int style, Locale locale) {
        if (field != 0) {
            return super.getDisplayName(field, style, locale);
        }
        return CalendarDataUtility.retrieveFieldValueName("buddhist", field, this.get(field), style, locale);
    }

    @Override
    public Map<String, Integer> getDisplayNames(int field, int style, Locale locale) {
        if (field != 0) {
            return super.getDisplayNames(field, style, locale);
        }
        return CalendarDataUtility.retrieveFieldValueNames("buddhist", field, style, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActualMaximum(int field) {
        int savedYearOffset = this.yearOffset;
        this.yearOffset = 0;
        try {
            int n = super.getActualMaximum(field);
            return n;
        }
        finally {
            this.yearOffset = savedYearOffset;
        }
    }

    @Override
    public String toString() {
        String s = super.toString();
        if (!this.isSet(1)) {
            return s;
        }
        String yearField = "YEAR=";
        int p = s.indexOf("YEAR=");
        if (p == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 10);
        sb.append(s, 0, p += "YEAR=".length());
        while (Character.isDigit(s.charAt(p++))) {
        }
        int year = this.internalGet(1) + 543;
        sb.append(year).append(s, p - 1, s.length());
        return sb.toString();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.yearOffset = 543;
    }
}

