/*
 * Decompiled with CFR 0.152.
 */
package sun.util.cldr;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import sun.util.locale.provider.CalendarDataProviderImpl;
import sun.util.locale.provider.LocaleProviderAdapter;

public class CLDRCalendarDataProviderImpl
extends CalendarDataProviderImpl {
    private static Map<String, Integer> firstDay = new ConcurrentHashMap<String, Integer>();
    private static Map<String, Integer> minDays = new ConcurrentHashMap<String, Integer>();

    public CLDRCalendarDataProviderImpl(LocaleProviderAdapter.Type type, Set<String> langtags) {
        super(type, langtags);
    }

    @Override
    public int getFirstDayOfWeek(Locale locale) {
        return CLDRCalendarDataProviderImpl.findValue("firstDayOfWeek", locale);
    }

    @Override
    public int getMinimalDaysInFirstWeek(Locale locale) {
        return CLDRCalendarDataProviderImpl.findValue("minimalDaysInFirstWeek", locale);
    }

    private static int findValue(String key, Locale locale) {
        Integer val;
        Map<String, Integer> map = "firstDayOfWeek".equals(key) ? firstDay : minDays;
        String region = locale.getCountry();
        if (region.isEmpty()) {
            region = "US";
        }
        if ((val = map.get(region)) == null) {
            String valStr = LocaleProviderAdapter.forType(LocaleProviderAdapter.Type.CLDR).getLocaleResources(Locale.ROOT).getCalendarData(key);
            val = CLDRCalendarDataProviderImpl.retrieveInteger(valStr, region).orElse(CLDRCalendarDataProviderImpl.retrieveInteger(valStr, "001").orElse(0));
            map.putIfAbsent(region, val);
        }
        return val;
    }

    private static Optional<Integer> retrieveInteger(String src, String region) {
        int regionIndex = src.indexOf(region);
        if (regionIndex >= 0) {
            int start = src.lastIndexOf(59, regionIndex) + 1;
            return Optional.of(Integer.parseInt(src, start, src.indexOf(58, start), 10));
        }
        return Optional.empty();
    }
}

