/*
 * Decompiled with CFR 0.152.
 */
package sun.util.cldr;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import sun.util.calendar.ZoneInfo;
import sun.util.calendar.ZoneInfoFile;
import sun.util.cldr.CLDRLocaleProviderAdapter;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleResources;
import sun.util.locale.provider.TimeZoneNameProviderImpl;
import sun.util.locale.provider.TimeZoneNameUtility;

public class CLDRTimeZoneNameProviderImpl
extends TimeZoneNameProviderImpl {
    private static final String NO_INHERITANCE_MARKER = "\u2205\u2205\u2205";
    private static final int INDEX_TZID = 0;
    private static final int INDEX_STD_LONG = 1;
    private static final int INDEX_STD_SHORT = 2;
    private static final int INDEX_DST_LONG = 3;
    private static final int INDEX_DST_SHORT = 4;
    private static final int INDEX_GEN_LONG = 5;
    private static final int INDEX_GEN_SHORT = 6;

    public CLDRTimeZoneNameProviderImpl(LocaleProviderAdapter.Type type, Set<String> langtags) {
        super(type, langtags);
    }

    @Override
    protected String[] getDisplayNameArray(String id, Locale locale) {
        String[] namesSuper = super.getDisplayNameArray(id, locale);
        if (namesSuper == null) {
            namesSuper = super.getDisplayNameArray(TimeZoneNameUtility.canonicalTZID(id).orElse(id), locale);
        }
        if (namesSuper != null) {
            namesSuper[0] = id;
            block8: for (int i = 1; i < namesSuper.length; ++i) {
                switch (namesSuper[i]) {
                    case "": {
                        this.deriveFallbackName(namesSuper, i, locale, !TimeZone.getTimeZone(id).useDaylightTime());
                        continue block8;
                    }
                    case "\u2205\u2205\u2205": {
                        namesSuper[i] = this.toGMTFormat(id, i == 3 || i == 4, locale);
                        continue block8;
                    }
                }
            }
            return namesSuper;
        }
        if (Arrays.binarySearch(AVAILABLE_IDS.INSTANCE, id) >= 0) {
            String[] names = new String[7];
            names[0] = id;
            this.deriveFallbackNames(names, locale);
            return names;
        }
        return null;
    }

    @Override
    protected String[][] getZoneStrings(Locale locale) {
        String[][] ret = super.getZoneStrings(locale);
        for (int zoneIndex = 0; zoneIndex < ret.length; ++zoneIndex) {
            this.deriveFallbackNames(ret[zoneIndex], locale);
        }
        return ret;
    }

    private void deriveFallbackNames(String[] names, Locale locale) {
        boolean noDST = !TimeZone.getTimeZone(names[0]).useDaylightTime();
        for (int i = 1; i <= 6; ++i) {
            this.deriveFallbackName(names, i, locale, noDST);
        }
    }

    private void deriveFallbackName(String[] names, int index, Locale locale, boolean noDST) {
        String[] compatNames;
        Locale parentLoc;
        String[] parentNames;
        CLDRLocaleProviderAdapter clpa;
        List<Locale> cands;
        String id = names[0];
        if (this.exists(names, index)) {
            if (names[index].equals(NO_INHERITANCE_MARKER)) {
                names[index] = this.toGMTFormat(id, index == 3 || index == 4, locale);
            }
            return;
        }
        if (!this.exists(names, index) && (cands = (clpa = (CLDRLocaleProviderAdapter)LocaleProviderAdapter.forType(LocaleProviderAdapter.Type.CLDR)).getCandidateLocales("", locale)).size() > 1 && (parentNames = super.getDisplayNameArray(id, parentLoc = cands.get(1))) != null && !parentNames[index].isEmpty()) {
            names[index] = parentNames[index];
            return;
        }
        if (LocaleProviderAdapter.getAdapterPreference().contains((Object)LocaleProviderAdapter.Type.JRE) && (compatNames = (String[])LocaleProviderAdapter.forJRE().getLocaleResources(this.mapChineseLocale(locale)).getTimeZoneNames(id)) != null) {
            for (int i = 1; i <= 6; ++i) {
                if (i != index && this.exists(names, i)) continue;
                names[i] = compatNames[i];
            }
            return;
        }
        if (this.regionFormatFallback(names, index, locale)) {
            return;
        }
        if (noDST && this.typeFallback(names, index)) {
            return;
        }
        names[index] = this.toGMTFormat(id, index == 3 || index == 4, locale);
        if (this.exists(names, 1) && (id.startsWith("Etc/") || id.startsWith("GMT") || id.startsWith("Greenwich"))) {
            switch (id) {
                case "Etc/GMT": 
                case "Etc/GMT-0": 
                case "Etc/GMT+0": 
                case "Etc/GMT0": 
                case "GMT+0": 
                case "GMT-0": 
                case "GMT0": 
                case "Greenwich": {
                    names[3] = names[5] = names[1];
                }
            }
        }
    }

    private boolean exists(String[] names, int index) {
        return Objects.nonNull(names) && Objects.nonNull(names[index]) && !names[index].isEmpty();
    }

    private boolean typeFallback(String[] names, int index) {
        int genIndex = 6 - index % 2;
        if (!this.exists(names, index) && this.exists(names, genIndex) && !names[genIndex].startsWith("GMT")) {
            names[index] = names[genIndex];
        } else {
            int stdIndex = 2 - index % 2;
            if (!this.exists(names, index) && this.exists(names, stdIndex) && !names[stdIndex].startsWith("GMT")) {
                names[index] = names[stdIndex];
            }
        }
        return this.exists(names, index);
    }

    private boolean regionFormatFallback(String[] names, int index, Locale l) {
        int slash;
        String id = names[0];
        LocaleResources lr = LocaleProviderAdapter.forType(LocaleProviderAdapter.Type.CLDR).getLocaleResources(l);
        ResourceBundle fd = lr.getJavaTimeFormatData();
        id = TimeZoneNameUtility.canonicalTZID(id).orElse(id);
        String rgn = (String)lr.getTimeZoneNames("timezone.excity." + id);
        if (rgn == null && !id.startsWith("Etc") && !id.startsWith("SystemV") && (slash = id.lastIndexOf(47)) > 0) {
            rgn = id.substring(slash + 1).replaceAll("_", " ");
        }
        if (rgn != null) {
            String fmt = "";
            switch (index) {
                case 1: {
                    fmt = fd.getString("timezone.regionFormat.standard");
                    break;
                }
                case 3: {
                    fmt = fd.getString("timezone.regionFormat.daylight");
                    break;
                }
                case 5: {
                    fmt = fd.getString("timezone.regionFormat");
                }
            }
            if (!fmt.isEmpty()) {
                names[index] = MessageFormat.format(fmt, rgn);
            }
        }
        return this.exists(names, index);
    }

    private String toGMTFormat(String id, boolean daylight, Locale l) {
        ZoneInfo tz = ZoneInfoFile.getZoneInfo(id);
        int offset = (((TimeZone)tz).getRawOffset() + (daylight ? ((TimeZone)tz).getDSTSavings() : 0)) / 60000;
        LocaleResources lr = LocaleProviderAdapter.forType(LocaleProviderAdapter.Type.CLDR).getLocaleResources(l);
        ResourceBundle fd = lr.getJavaTimeFormatData();
        if (offset == 0) {
            return fd.getString("timezone.gmtZeroFormat");
        }
        String gmtFormat = fd.getString("timezone.gmtFormat");
        String hourFormat = fd.getString("timezone.hourFormat");
        if (offset > 0) {
            hourFormat = hourFormat.substring(0, hourFormat.indexOf(";"));
        } else {
            hourFormat = hourFormat.substring(hourFormat.indexOf(";") + 1);
            offset = -offset;
        }
        hourFormat = hourFormat.replaceFirst("H+", "\\%1\\$02d").replaceFirst("m+", "\\%2\\$02d");
        return MessageFormat.format(gmtFormat, String.format(l, hourFormat, offset / 60, offset % 60));
    }

    private Locale mapChineseLocale(Locale locale) {
        if (locale.getLanguage() == "zh") {
            switch (locale.getScript()) {
                case "Hans": {
                    return Locale.CHINA;
                }
                case "Hant": {
                    return Locale.TAIWAN;
                }
                case "": {
                    switch (locale.getCountry()) {
                        case "": 
                        case "CN": 
                        case "SG": {
                            return Locale.CHINA;
                        }
                        case "HK": 
                        case "MO": 
                        case "TW": {
                            return Locale.TAIWAN;
                        }
                    }
                }
            }
        }
        return locale;
    }

    private static class AVAILABLE_IDS {
        static final String[] INSTANCE = (String[])Arrays.stream(ZoneInfoFile.getZoneIds()).sorted().toArray(String[]::new);

        private AVAILABLE_IDS() {
        }
    }
}

