/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

import java.lang.ref.SoftReference;
import java.util.StringJoiner;
import jdk.internal.misc.CDS;
import jdk.internal.vm.annotation.Stable;
import sun.security.action.GetPropertyAction;
import sun.util.locale.LocaleObjectCache;
import sun.util.locale.LocaleUtils;

public final class BaseLocale {
    @Stable
    public static BaseLocale[] constantBaseLocales;
    public static final byte ENGLISH = 0;
    public static final byte FRENCH = 1;
    public static final byte GERMAN = 2;
    public static final byte ITALIAN = 3;
    public static final byte JAPANESE = 4;
    public static final byte KOREAN = 5;
    public static final byte CHINESE = 6;
    public static final byte SIMPLIFIED_CHINESE = 7;
    public static final byte TRADITIONAL_CHINESE = 8;
    public static final byte FRANCE = 9;
    public static final byte GERMANY = 10;
    public static final byte ITALY = 11;
    public static final byte JAPAN = 12;
    public static final byte KOREA = 13;
    public static final byte UK = 14;
    public static final byte US = 15;
    public static final byte CANADA = 16;
    public static final byte CANADA_FRENCH = 17;
    public static final byte ROOT = 18;
    public static final byte NUM_CONSTANTS = 19;
    public static final String SEP = "_";
    private final String language;
    private final String script;
    private final String region;
    private final String variant;
    private volatile int hash;
    private static final boolean OLD_ISO_CODES;

    private BaseLocale(String language, String script, String region, String variant, boolean normalize) {
        if (normalize) {
            this.language = LocaleUtils.toLowerString(language).intern();
            this.script = LocaleUtils.toTitleString(script).intern();
            this.region = LocaleUtils.toUpperString(region).intern();
            this.variant = variant.intern();
        } else {
            this.language = language;
            this.script = script;
            this.region = region;
            this.variant = variant;
        }
    }

    private static BaseLocale createInstance(String language, String region) {
        return new BaseLocale(language, "", region, "", false);
    }

    public static BaseLocale getInstance(String language, String script, String region, String variant) {
        if (script == null) {
            script = "";
        }
        if (region == null) {
            region = "";
        }
        if (language == null) {
            language = null;
        }
        if (variant == null) {
            variant = "";
        }
        language = LocaleUtils.toLowerString(language);
        region = LocaleUtils.toUpperString(region);
        if (script.isEmpty() && variant.isEmpty()) {
            for (BaseLocale baseLocale : constantBaseLocales) {
                if (!baseLocale.getLanguage().equals(language) || !baseLocale.getRegion().equals(region)) continue;
                return baseLocale;
            }
        }
        if (!language.isEmpty()) {
            language = BaseLocale.convertOldISOCodes(language);
        }
        Key key = new Key(language, script, region, variant, false);
        return (BaseLocale)Cache.CACHE.get(key);
    }

    public static String convertOldISOCodes(String language) {
        return switch (language) {
            case "he", "iw" -> {
                if (OLD_ISO_CODES) {
                    yield "iw";
                }
                yield "he";
            }
            case "id", "in" -> {
                if (OLD_ISO_CODES) {
                    yield "in";
                }
                yield "id";
            }
            case "yi", "ji" -> {
                if (OLD_ISO_CODES) {
                    yield "ji";
                }
                yield "yi";
            }
            default -> language;
        };
    }

    public String getLanguage() {
        return this.language;
    }

    public String getScript() {
        return this.script;
    }

    public String getRegion() {
        return this.region;
    }

    public String getVariant() {
        return this.variant;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BaseLocale)) {
            return false;
        }
        BaseLocale other = (BaseLocale)obj;
        return this.language == other.language && this.script == other.script && this.region == other.region && this.variant == other.variant;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ");
        if (!this.language.isEmpty()) {
            sj.add("language=" + this.language);
        }
        if (!this.script.isEmpty()) {
            sj.add("script=" + this.script);
        }
        if (!this.region.isEmpty()) {
            sj.add("region=" + this.region);
        }
        if (!this.variant.isEmpty()) {
            sj.add("variant=" + this.variant);
        }
        return sj.toString();
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = this.language.hashCode();
            h = 31 * h + this.script.hashCode();
            h = 31 * h + this.region.hashCode();
            if ((h = 31 * h + this.variant.hashCode()) != 0) {
                this.hash = h;
            }
        }
        return h;
    }

    static {
        CDS.initializeFromArchive(BaseLocale.class);
        BaseLocale[] baseLocales = constantBaseLocales;
        if (baseLocales == null) {
            baseLocales = new BaseLocale[]{BaseLocale.createInstance("en", ""), BaseLocale.createInstance("fr", ""), BaseLocale.createInstance("de", ""), BaseLocale.createInstance("it", ""), BaseLocale.createInstance("ja", ""), BaseLocale.createInstance("ko", ""), BaseLocale.createInstance("zh", ""), BaseLocale.createInstance("zh", "CN"), BaseLocale.createInstance("zh", "TW"), BaseLocale.createInstance("fr", "FR"), BaseLocale.createInstance("de", "DE"), BaseLocale.createInstance("it", "IT"), BaseLocale.createInstance("ja", "JP"), BaseLocale.createInstance("ko", "KR"), BaseLocale.createInstance("en", "GB"), BaseLocale.createInstance("en", "US"), BaseLocale.createInstance("en", "CA"), BaseLocale.createInstance("fr", "CA"), BaseLocale.createInstance("", "")};
            constantBaseLocales = baseLocales;
        }
        OLD_ISO_CODES = GetPropertyAction.privilegedGetProperties().getProperty("java.locale.useOldISOCodes", "false").equalsIgnoreCase("true");
    }

    private static final class Key {
        private final SoftReference<BaseLocale> holderRef;
        private final BaseLocale holder;
        private final boolean normalized;
        private final int hash;

        private Key(String language, String script, String region, String variant, boolean normalize) {
            BaseLocale locale = new BaseLocale(language, script, region, variant, normalize);
            this.normalized = normalize;
            if (this.normalized) {
                this.holderRef = new SoftReference<BaseLocale>(locale);
                this.holder = null;
            } else {
                this.holderRef = null;
                this.holder = locale;
            }
            this.hash = this.hashCode(locale);
        }

        public int hashCode() {
            return this.hash;
        }

        private int hashCode(BaseLocale locale) {
            int h = 0;
            String lang = locale.getLanguage();
            int len = lang.length();
            for (int i = 0; i < len; ++i) {
                h = 31 * h + LocaleUtils.toLower(lang.charAt(i));
            }
            String scrt = locale.getScript();
            len = scrt.length();
            for (int i = 0; i < len; ++i) {
                h = 31 * h + LocaleUtils.toLower(scrt.charAt(i));
            }
            String regn = locale.getRegion();
            len = regn.length();
            for (int i = 0; i < len; ++i) {
                h = 31 * h + LocaleUtils.toLower(regn.charAt(i));
            }
            String vart = locale.getVariant();
            len = vart.length();
            for (int i = 0; i < len; ++i) {
                h = 31 * h + vart.charAt(i);
            }
            return h;
        }

        private BaseLocale getBaseLocale() {
            return this.holder == null ? this.holderRef.get() : this.holder;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Key && this.hash == ((Key)obj).hash) {
                BaseLocale other = ((Key)obj).getBaseLocale();
                BaseLocale locale = this.getBaseLocale();
                if (other != null && locale != null && LocaleUtils.caseIgnoreMatch(other.getLanguage(), locale.getLanguage()) && LocaleUtils.caseIgnoreMatch(other.getScript(), locale.getScript()) && LocaleUtils.caseIgnoreMatch(other.getRegion(), locale.getRegion()) && other.getVariant().equals(locale.getVariant())) {
                    return true;
                }
            }
            return false;
        }

        public static Key normalize(Key key) {
            if (key.normalized) {
                return key;
            }
            assert (key.holder != null && key.holderRef == null);
            BaseLocale locale = key.holder;
            return new Key(locale.getLanguage(), locale.getScript(), locale.getRegion(), locale.getVariant(), true);
        }
    }

    private static class Cache
    extends LocaleObjectCache<Key, BaseLocale> {
        private static final Cache CACHE = new Cache();

        @Override
        protected Key normalizeKey(Key key) {
            return Key.normalize(key);
        }

        @Override
        protected BaseLocale createObject(Key key) {
            return Key.normalize(key).getBaseLocale();
        }
    }
}

