/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import sun.util.locale.LocaleEquivalentMaps;

public final class LocaleMatcher {
    public static List<Locale> filter(List<Locale.LanguageRange> priorityList, Collection<Locale> locales, Locale.FilteringMode mode) {
        if (priorityList.isEmpty() || locales.isEmpty()) {
            return new ArrayList<Locale>();
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (Locale locale : locales) {
            tags.add(locale.toLanguageTag());
        }
        List<String> filteredTags = LocaleMatcher.filterTags(priorityList, tags, mode);
        ArrayList<Locale> filteredLocales = new ArrayList<Locale>(filteredTags.size());
        for (String tag : filteredTags) {
            filteredLocales.add(Locale.forLanguageTag(tag));
        }
        return filteredLocales;
    }

    public static List<String> filterTags(List<Locale.LanguageRange> priorityList, Collection<String> tags, Locale.FilteringMode mode) {
        if (priorityList.isEmpty() || tags.isEmpty()) {
            return new ArrayList<String>();
        }
        if (mode == Locale.FilteringMode.EXTENDED_FILTERING) {
            return LocaleMatcher.filterExtended(priorityList, tags);
        }
        ArrayList<Locale.LanguageRange> list = new ArrayList<Locale.LanguageRange>();
        for (Locale.LanguageRange lr : priorityList) {
            String range = lr.getRange();
            if (range.startsWith("*-") || range.indexOf("-*") != -1) {
                if (mode == Locale.FilteringMode.AUTOSELECT_FILTERING) {
                    return LocaleMatcher.filterExtended(priorityList, tags);
                }
                if (mode == Locale.FilteringMode.MAP_EXTENDED_RANGES) {
                    range = range.charAt(0) == '*' ? "*" : range.replaceAll("-[*]", "");
                    list.add(new Locale.LanguageRange(range, lr.getWeight()));
                    continue;
                }
                if (mode != Locale.FilteringMode.REJECT_EXTENDED_RANGES) continue;
                throw new IllegalArgumentException("An extended range \"" + range + "\" found in REJECT_EXTENDED_RANGES mode.");
            }
            list.add(lr);
        }
        return LocaleMatcher.filterBasic(list, tags);
    }

    private static List<String> filterBasic(List<Locale.LanguageRange> priorityList, Collection<String> tags) {
        List<Locale.LanguageRange> zeroRanges;
        List<Locale.LanguageRange> nonZeroRanges;
        int splitIndex = LocaleMatcher.splitRanges(priorityList);
        if (splitIndex != -1) {
            nonZeroRanges = priorityList.subList(0, splitIndex);
            zeroRanges = priorityList.subList(splitIndex, priorityList.size());
        } else {
            nonZeroRanges = priorityList;
            zeroRanges = List.of();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Locale.LanguageRange lr : nonZeroRanges) {
            String range = lr.getRange();
            if (range.equals("*")) {
                tags = LocaleMatcher.removeTagsMatchingBasicZeroRange(zeroRanges, tags);
                return new ArrayList<String>(tags);
            }
            for (String tag : tags) {
                String lowerCaseTag = tag.toLowerCase(Locale.ROOT);
                if (!lowerCaseTag.startsWith(range)) continue;
                int len = range.length();
                if (lowerCaseTag.length() != len && lowerCaseTag.charAt(len) != '-' || LocaleMatcher.caseInsensitiveMatch(list, lowerCaseTag) || LocaleMatcher.shouldIgnoreFilterBasicMatch(zeroRanges, lowerCaseTag)) continue;
                list.add(tag);
            }
        }
        return list;
    }

    private static Collection<String> removeTagsMatchingBasicZeroRange(List<Locale.LanguageRange> zeroRange, Collection<String> tags) {
        if (zeroRange.isEmpty()) {
            tags = LocaleMatcher.removeDuplicates(tags);
            return tags;
        }
        ArrayList<String> matchingTags = new ArrayList<String>();
        for (String tag : tags) {
            String lowerCaseTag = tag.toLowerCase(Locale.ROOT);
            if (LocaleMatcher.shouldIgnoreFilterBasicMatch(zeroRange, lowerCaseTag) || LocaleMatcher.caseInsensitiveMatch(matchingTags, lowerCaseTag)) continue;
            matchingTags.add(tag);
        }
        return matchingTags;
    }

    private static Collection<String> removeDuplicates(Collection<String> tags) {
        TreeSet distinctTags = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        return tags.stream().filter(x -> distinctTags.add(x)).toList();
    }

    private static boolean caseInsensitiveMatch(List<String> list, String tag) {
        return list.stream().anyMatch(element -> element.equalsIgnoreCase(tag));
    }

    private static boolean shouldIgnoreFilterBasicMatch(List<Locale.LanguageRange> zeroRange, String tag) {
        if (zeroRange.isEmpty()) {
            return false;
        }
        for (Locale.LanguageRange lr : zeroRange) {
            String range = lr.getRange();
            if (range.equals("*")) {
                return true;
            }
            if (!tag.startsWith(range)) continue;
            int len = range.length();
            if (tag.length() != len && tag.charAt(len) != '-') continue;
            return true;
        }
        return false;
    }

    private static List<String> filterExtended(List<Locale.LanguageRange> priorityList, Collection<String> tags) {
        List<Locale.LanguageRange> zeroRanges;
        List<Locale.LanguageRange> nonZeroRanges;
        int splitIndex = LocaleMatcher.splitRanges(priorityList);
        if (splitIndex != -1) {
            nonZeroRanges = priorityList.subList(0, splitIndex);
            zeroRanges = priorityList.subList(splitIndex, priorityList.size());
        } else {
            nonZeroRanges = priorityList;
            zeroRanges = List.of();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Locale.LanguageRange lr : nonZeroRanges) {
            String range = lr.getRange();
            if (range.equals("*")) {
                tags = LocaleMatcher.removeTagsMatchingExtendedZeroRange(zeroRanges, tags);
                return new ArrayList<String>(tags);
            }
            String[] rangeSubtags = range.split("-");
            for (String tag : tags) {
                int rangeIndex;
                String lowerCaseTag = tag.toLowerCase(Locale.ROOT);
                String[] tagSubtags = lowerCaseTag.split("-");
                if (!rangeSubtags[0].equals(tagSubtags[0]) && !rangeSubtags[0].equals("*") || rangeSubtags.length != (rangeIndex = LocaleMatcher.matchFilterExtendedSubtags(rangeSubtags, tagSubtags)) || LocaleMatcher.caseInsensitiveMatch(list, lowerCaseTag) || LocaleMatcher.shouldIgnoreFilterExtendedMatch(zeroRanges, lowerCaseTag)) continue;
                list.add(tag);
            }
        }
        return list;
    }

    private static Collection<String> removeTagsMatchingExtendedZeroRange(List<Locale.LanguageRange> zeroRange, Collection<String> tags) {
        if (zeroRange.isEmpty()) {
            tags = LocaleMatcher.removeDuplicates(tags);
            return tags;
        }
        ArrayList<String> matchingTags = new ArrayList<String>();
        for (String tag : tags) {
            String lowerCaseTag = tag.toLowerCase(Locale.ROOT);
            if (LocaleMatcher.shouldIgnoreFilterExtendedMatch(zeroRange, lowerCaseTag) || LocaleMatcher.caseInsensitiveMatch(matchingTags, lowerCaseTag)) continue;
            matchingTags.add(tag);
        }
        return matchingTags;
    }

    private static boolean shouldIgnoreFilterExtendedMatch(List<Locale.LanguageRange> zeroRange, String tag) {
        if (zeroRange.isEmpty()) {
            return false;
        }
        String[] tagSubtags = tag.split("-");
        for (Locale.LanguageRange lr : zeroRange) {
            int rangeIndex;
            String range = lr.getRange();
            if (range.equals("*")) {
                return true;
            }
            String[] rangeSubtags = range.split("-");
            if (!rangeSubtags[0].equals(tagSubtags[0]) && !rangeSubtags[0].equals("*") || rangeSubtags.length != (rangeIndex = LocaleMatcher.matchFilterExtendedSubtags(rangeSubtags, tagSubtags))) continue;
            return true;
        }
        return false;
    }

    private static int matchFilterExtendedSubtags(String[] rangeSubtags, String[] tagSubtags) {
        int rangeIndex = 1;
        int tagIndex = 1;
        while (rangeIndex < rangeSubtags.length && tagIndex < tagSubtags.length) {
            if (rangeSubtags[rangeIndex].equals("*")) {
                ++rangeIndex;
                continue;
            }
            if (rangeSubtags[rangeIndex].equals(tagSubtags[tagIndex])) {
                ++rangeIndex;
                ++tagIndex;
                continue;
            }
            if (tagSubtags[tagIndex].length() == 1 && !tagSubtags[tagIndex].equals("*")) break;
            ++tagIndex;
        }
        return rangeIndex;
    }

    public static Locale lookup(List<Locale.LanguageRange> priorityList, Collection<Locale> locales) {
        if (priorityList.isEmpty() || locales.isEmpty()) {
            return null;
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (Locale locale : locales) {
            tags.add(locale.toLanguageTag());
        }
        String lookedUpTag = LocaleMatcher.lookupTag(priorityList, tags);
        if (lookedUpTag == null) {
            return null;
        }
        return Locale.forLanguageTag(lookedUpTag);
    }

    public static String lookupTag(List<Locale.LanguageRange> priorityList, Collection<String> tags) {
        List<Locale.LanguageRange> zeroRanges;
        List<Locale.LanguageRange> nonZeroRanges;
        if (priorityList.isEmpty() || tags.isEmpty()) {
            return null;
        }
        int splitIndex = LocaleMatcher.splitRanges(priorityList);
        if (splitIndex != -1) {
            nonZeroRanges = priorityList.subList(0, splitIndex);
            zeroRanges = priorityList.subList(splitIndex, priorityList.size());
        } else {
            nonZeroRanges = priorityList;
            zeroRanges = List.of();
        }
        for (Locale.LanguageRange lr : nonZeroRanges) {
            String range = lr.getRange();
            if (range.equals("*")) continue;
            String rangeForRegex = range.replace("*", "\\p{Alnum}*");
            while (!rangeForRegex.isEmpty()) {
                for (String tag : tags) {
                    String lowerCaseTag = tag.toLowerCase(Locale.ROOT);
                    if (!lowerCaseTag.matches(rangeForRegex) || LocaleMatcher.shouldIgnoreLookupMatch(zeroRanges, lowerCaseTag)) continue;
                    return tag;
                }
                rangeForRegex = LocaleMatcher.truncateRange(rangeForRegex);
            }
        }
        return null;
    }

    private static boolean shouldIgnoreLookupMatch(List<Locale.LanguageRange> zeroRange, String tag) {
        for (Locale.LanguageRange lr : zeroRange) {
            String range = lr.getRange();
            if (range.equals("*")) continue;
            String rangeForRegex = range.replace("*", "\\p{Alnum}*");
            while (!rangeForRegex.isEmpty()) {
                if (tag.matches(rangeForRegex)) {
                    return true;
                }
                rangeForRegex = LocaleMatcher.truncateRange(rangeForRegex);
            }
        }
        return false;
    }

    private static String truncateRange(String rangeForRegex) {
        int index = rangeForRegex.lastIndexOf(45);
        if (index >= 0) {
            if ((index = (rangeForRegex = rangeForRegex.substring(0, index)).lastIndexOf(45)) >= 0 && index == rangeForRegex.length() - 2) {
                rangeForRegex = rangeForRegex.substring(0, rangeForRegex.length() - 2);
            }
        } else {
            rangeForRegex = "";
        }
        return rangeForRegex;
    }

    private static int splitRanges(List<Locale.LanguageRange> priorityList) {
        int size = priorityList.size();
        for (int index = 0; index < size; ++index) {
            Locale.LanguageRange range = priorityList.get(index);
            if (range.getWeight() != 0.0) continue;
            return index;
        }
        return -1;
    }

    public static List<Locale.LanguageRange> parse(String ranges) {
        if ((ranges = ranges.replace(" ", "").toLowerCase(Locale.ROOT)).startsWith("accept-language:")) {
            ranges = ranges.substring(16);
        }
        String[] langRanges = ranges.split(",");
        ArrayList<Locale.LanguageRange> list = new ArrayList<Locale.LanguageRange>(langRanges.length);
        ArrayList<String> tempList = new ArrayList<String>();
        int numOfRanges = 0;
        for (String range : langRanges) {
            String[] equivalents;
            double w;
            String r;
            int index = range.indexOf(";q=");
            if (index == -1) {
                r = range;
                w = 1.0;
            } else {
                r = range.substring(0, index);
                index += 3;
                try {
                    w = Double.parseDouble(range.substring(index));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("weight=\"" + range.substring(index) + "\" for language range \"" + r + "\"");
                }
                if (w < 0.0 || w > 1.0) {
                    throw new IllegalArgumentException("weight=" + w + " for language range \"" + r + "\". It must be between " + 0.0 + " and " + 1.0 + ".");
                }
            }
            if (tempList.contains(r)) continue;
            Locale.LanguageRange lr = new Locale.LanguageRange(r, w);
            index = numOfRanges;
            for (int j = 0; j < numOfRanges; ++j) {
                if (!(((Locale.LanguageRange)list.get(j)).getWeight() < w)) continue;
                index = j;
                break;
            }
            list.add(index, lr);
            ++numOfRanges;
            tempList.add(r);
            String equivalent = LocaleMatcher.getEquivalentForRegionAndVariant(r);
            if (equivalent != null && !tempList.contains(equivalent)) {
                list.add(index + 1, new Locale.LanguageRange(equivalent, w));
                ++numOfRanges;
                tempList.add(equivalent);
            }
            if ((equivalents = LocaleMatcher.getEquivalentsForLanguage(r)) == null) continue;
            for (String equiv : equivalents) {
                if (!tempList.contains(equiv)) {
                    list.add(index + 1, new Locale.LanguageRange(equiv, w));
                    ++numOfRanges;
                    tempList.add(equiv);
                }
                if ((equivalent = LocaleMatcher.getEquivalentForRegionAndVariant(equiv)) == null || tempList.contains(equivalent)) continue;
                list.add(index + 1, new Locale.LanguageRange(equivalent, w));
                ++numOfRanges;
                tempList.add(equivalent);
            }
        }
        return list;
    }

    private static String replaceFirstSubStringMatch(String range, String substr, String replacement) {
        int pos = range.indexOf(substr);
        if (pos == -1) {
            return range;
        }
        return range.substring(0, pos) + replacement + range.substring(pos + substr.length());
    }

    private static String[] getEquivalentsForLanguage(String range) {
        String r = range;
        while (!r.isEmpty()) {
            if (LocaleEquivalentMaps.singleEquivMap.containsKey(r)) {
                String equiv = LocaleEquivalentMaps.singleEquivMap.get(r);
                return new String[]{LocaleMatcher.replaceFirstSubStringMatch(range, r, equiv)};
            }
            if (LocaleEquivalentMaps.multiEquivsMap.containsKey(r)) {
                String[] equivs = LocaleEquivalentMaps.multiEquivsMap.get(r);
                String[] result = new String[equivs.length];
                for (int i = 0; i < equivs.length; ++i) {
                    result[i] = LocaleMatcher.replaceFirstSubStringMatch(range, r, equivs[i]);
                }
                return result;
            }
            int index = r.lastIndexOf(45);
            if (index == -1) break;
            r = r.substring(0, index);
        }
        return null;
    }

    private static String getEquivalentForRegionAndVariant(String range) {
        int extensionKeyIndex = LocaleMatcher.getExtentionKeyIndex(range);
        for (String subtag : LocaleEquivalentMaps.regionVariantEquivMap.keySet()) {
            int index = range.indexOf(subtag);
            if (index == -1 || extensionKeyIndex != Integer.MIN_VALUE && index > extensionKeyIndex) continue;
            int len = index + subtag.length();
            if (range.length() != len && range.charAt(len) != '-') continue;
            return LocaleMatcher.replaceFirstSubStringMatch(range, subtag, LocaleEquivalentMaps.regionVariantEquivMap.get(subtag));
        }
        return null;
    }

    private static int getExtentionKeyIndex(String s) {
        char[] c = s.toCharArray();
        int index = Integer.MIN_VALUE;
        for (int i = 1; i < c.length; ++i) {
            if (c[i] != '-') continue;
            if (i - index == 2) {
                return index;
            }
            index = i;
        }
        return Integer.MIN_VALUE;
    }

    public static List<Locale.LanguageRange> mapEquivalents(List<Locale.LanguageRange> priorityList, Map<String, List<String>> map) {
        if (priorityList.isEmpty()) {
            return new ArrayList<Locale.LanguageRange>();
        }
        if (map == null || map.isEmpty()) {
            return new ArrayList<Locale.LanguageRange>(priorityList);
        }
        HashMap<String, String> keyMap = new HashMap<String, String>();
        for (String key : map.keySet()) {
            keyMap.put(key.toLowerCase(Locale.ROOT), key);
        }
        ArrayList<Locale.LanguageRange> list = new ArrayList<Locale.LanguageRange>();
        for (Locale.LanguageRange lr : priorityList) {
            String range;
            String r = range = lr.getRange();
            boolean hasEquivalent = false;
            while (!r.isEmpty()) {
                if (keyMap.containsKey(r)) {
                    hasEquivalent = true;
                    List<String> equivalents = map.get(keyMap.get(r));
                    if (equivalents == null) break;
                    int len = r.length();
                    for (String equivalent : equivalents) {
                        list.add(new Locale.LanguageRange(equivalent.toLowerCase(Locale.ROOT) + range.substring(len), lr.getWeight()));
                    }
                    break;
                }
                int index = r.lastIndexOf(45);
                if (index == -1) break;
                r = r.substring(0, index);
            }
            if (hasEquivalent) continue;
            list.add(lr);
        }
        return list;
    }

    private LocaleMatcher() {
    }
}

