/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.text.spi.DateFormatProvider;
import java.util.Calendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TimeZone;
import sun.util.locale.provider.AvailableLanguageTags;
import sun.util.locale.provider.CalendarDataUtility;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.TimeZoneNameUtility;

public class DateFormatProviderImpl
extends DateFormatProvider
implements AvailableLanguageTags {
    private final LocaleProviderAdapter.Type type;
    private final Set<String> langtags;

    public DateFormatProviderImpl(LocaleProviderAdapter.Type type, Set<String> langtags) {
        this.type = type;
        this.langtags = langtags;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LocaleProviderAdapter.toLocaleArray(this.langtags);
    }

    @Override
    public boolean isSupportedLocale(Locale locale) {
        return LocaleProviderAdapter.forType(this.type).isSupportedProviderLocale(locale, this.langtags);
    }

    @Override
    public DateFormat getTimeInstance(int style, Locale locale) {
        return this.getInstance(-1, style, locale);
    }

    @Override
    public DateFormat getDateInstance(int style, Locale locale) {
        return this.getInstance(style, -1, locale);
    }

    @Override
    public DateFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale locale) {
        return this.getInstance(dateStyle, timeStyle, locale);
    }

    private DateFormat getInstance(int dateStyle, int timeStyle, Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        Locale rg = CalendarDataUtility.findRegionOverride(locale);
        SimpleDateFormat sdf = new SimpleDateFormat("", rg);
        Calendar cal = sdf.getCalendar();
        try {
            String pattern = LocaleProviderAdapter.forType(this.type).getLocaleResources(rg).getDateTimePattern(timeStyle, dateStyle, cal);
            sdf.applyPattern(pattern);
        }
        catch (MissingResourceException mre) {
            sdf.applyPattern("M/d/yy h:mm a");
        }
        String tz = locale.getUnicodeLocaleType("tz");
        if (tz != null) {
            sdf.setTimeZone(TimeZoneNameUtility.convertLDMLShortID(tz).map(TimeZone::getTimeZone).orElseGet(sdf::getTimeZone));
        }
        return sdf;
    }

    @Override
    public Set<String> getAvailableLanguageTags() {
        return this.langtags;
    }
}

