/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CalendarNameProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import sun.text.spi.JavaTimeDateTimePatternProvider;
import sun.util.locale.provider.HostLocaleProviderAdapter;
import sun.util.locale.provider.JRELocaleConstants;
import sun.util.spi.CalendarProvider;

public class HostLocaleProviderAdapterImpl {
    private static final int CAT_DISPLAY = 0;
    private static final int CAT_FORMAT = 1;
    private static final int NF_NUMBER = 0;
    private static final int NF_CURRENCY = 1;
    private static final int NF_PERCENT = 2;
    private static final int NF_INTEGER = 3;
    private static final int NF_MAX = 3;
    private static final int CD_FIRSTDAYOFWEEK = 0;
    private static final int CD_FIRSTWEEKOFYEAR = 1;
    private static final int DN_CURRENCY_NAME = 0;
    private static final int DN_CURRENCY_SYMBOL = 1;
    private static final int DN_LOCALE_LANGUAGE = 2;
    private static final int DN_LOCALE_SCRIPT = 3;
    private static final int DN_LOCALE_REGION = 4;
    private static final int DN_LOCALE_VARIANT = 5;
    private static final int CAL_JAPAN = 3;
    private static final String[] calIDToLDML = new String[]{"", "gregory", "gregory_en-US", "japanese", "roc", "", "islamic", "buddhist", "hebrew", "gregory_fr", "gregory_ar", "gregory_en", "gregory_fr", "", "", "", "", "", "", "", "", "", "", "islamic-umalqura"};
    private static final ConcurrentMap<Locale, SoftReference<AtomicReferenceArray<String>>> dateFormatCache = new ConcurrentHashMap<Locale, SoftReference<AtomicReferenceArray<String>>>();
    private static final ConcurrentMap<Locale, SoftReference<DateFormatSymbols>> dateFormatSymbolsCache = new ConcurrentHashMap<Locale, SoftReference<DateFormatSymbols>>();
    private static final ConcurrentMap<Locale, SoftReference<AtomicReferenceArray<String>>> numberFormatCache = new ConcurrentHashMap<Locale, SoftReference<AtomicReferenceArray<String>>>();
    private static final ConcurrentMap<Locale, SoftReference<DecimalFormatSymbols>> decimalFormatSymbolsCache = new ConcurrentHashMap<Locale, SoftReference<DecimalFormatSymbols>>();
    private static final Set<Locale> supportedLocaleSet;
    private static final String nativeDisplayLanguage;
    private static final Locale[] supportedLocale;

    public static DateFormatProvider getDateFormatProvider() {
        return new DateFormatProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public DateFormat getDateInstance(int style, Locale locale) {
                AtomicReferenceArray<String> patterns = this.getDateTimePatterns(locale);
                return new SimpleDateFormat(patterns.get(style / 2), HostLocaleProviderAdapterImpl.getCalendarLocale(locale));
            }

            @Override
            public DateFormat getTimeInstance(int style, Locale locale) {
                AtomicReferenceArray<String> patterns = this.getDateTimePatterns(locale);
                return new SimpleDateFormat(patterns.get(style / 2 + 2), HostLocaleProviderAdapterImpl.getCalendarLocale(locale));
            }

            @Override
            public DateFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale locale) {
                AtomicReferenceArray<String> patterns = this.getDateTimePatterns(locale);
                String pattern = patterns.get(dateStyle / 2) + " " + patterns.get(timeStyle / 2 + 2);
                return new SimpleDateFormat(pattern, HostLocaleProviderAdapterImpl.getCalendarLocale(locale));
            }

            private AtomicReferenceArray<String> getDateTimePatterns(Locale locale) {
                AtomicReferenceArray<String> patterns;
                SoftReference ref = (SoftReference)dateFormatCache.get(locale);
                if (ref == null || (patterns = (AtomicReferenceArray<String>)ref.get()) == null) {
                    String langtag = HostLocaleProviderAdapterImpl.removeExtensions(locale).toLanguageTag();
                    patterns = new AtomicReferenceArray<String>(4);
                    patterns.compareAndSet(0, null, HostLocaleProviderAdapterImpl.convertDateTimePattern(HostLocaleProviderAdapterImpl.getDateTimePattern(1, -1, langtag)));
                    patterns.compareAndSet(1, null, HostLocaleProviderAdapterImpl.convertDateTimePattern(HostLocaleProviderAdapterImpl.getDateTimePattern(3, -1, langtag)));
                    patterns.compareAndSet(2, null, HostLocaleProviderAdapterImpl.convertDateTimePattern(HostLocaleProviderAdapterImpl.getDateTimePattern(-1, 1, langtag)));
                    patterns.compareAndSet(3, null, HostLocaleProviderAdapterImpl.convertDateTimePattern(HostLocaleProviderAdapterImpl.getDateTimePattern(-1, 3, langtag)));
                    ref = new SoftReference(patterns);
                    dateFormatCache.put(locale, ref);
                }
                return patterns;
            }
        };
    }

    public static DateFormatSymbolsProvider getDateFormatSymbolsProvider() {
        return new DateFormatSymbolsProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public DateFormatSymbols getInstance(Locale locale) {
                DateFormatSymbols dfs;
                SoftReference<DateFormatSymbols> ref = (SoftReference<DateFormatSymbols>)dateFormatSymbolsCache.get(locale);
                if (ref == null || (dfs = (DateFormatSymbols)ref.get()) == null) {
                    dfs = new DateFormatSymbols(locale);
                    String langTag = HostLocaleProviderAdapterImpl.removeExtensions(locale).toLanguageTag();
                    dfs.setAmPmStrings(HostLocaleProviderAdapterImpl.getAmPmStrings(langTag, dfs.getAmPmStrings()));
                    dfs.setEras(HostLocaleProviderAdapterImpl.getEras(langTag, dfs.getEras()));
                    dfs.setMonths(HostLocaleProviderAdapterImpl.getMonths(langTag, dfs.getMonths()));
                    dfs.setShortMonths(HostLocaleProviderAdapterImpl.getShortMonths(langTag, dfs.getShortMonths()));
                    dfs.setWeekdays(HostLocaleProviderAdapterImpl.getWeekdays(langTag, dfs.getWeekdays()));
                    dfs.setShortWeekdays(HostLocaleProviderAdapterImpl.getShortWeekdays(langTag, dfs.getShortWeekdays()));
                    ref = new SoftReference<DateFormatSymbols>(dfs);
                    dateFormatSymbolsCache.put(locale, ref);
                }
                return (DateFormatSymbols)dfs.clone();
            }
        };
    }

    public static NumberFormatProvider getNumberFormatProvider() {
        return new NumberFormatProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedNativeDigitLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedNativeDigitLocale(locale);
            }

            @Override
            public NumberFormat getCurrencyInstance(Locale locale) {
                AtomicReferenceArray<String> patterns = this.getNumberPatterns(locale);
                return new DecimalFormat(patterns.get(1), DecimalFormatSymbols.getInstance(locale));
            }

            @Override
            public NumberFormat getIntegerInstance(Locale locale) {
                AtomicReferenceArray<String> patterns = this.getNumberPatterns(locale);
                DecimalFormat format = new DecimalFormat(patterns.get(3), DecimalFormatSymbols.getInstance(locale));
                return HostLocaleProviderAdapter.makeIntegerFormatter(format);
            }

            @Override
            public NumberFormat getNumberInstance(Locale locale) {
                AtomicReferenceArray<String> patterns = this.getNumberPatterns(locale);
                return new DecimalFormat(patterns.get(0), DecimalFormatSymbols.getInstance(locale));
            }

            @Override
            public NumberFormat getPercentInstance(Locale locale) {
                AtomicReferenceArray<String> patterns = this.getNumberPatterns(locale);
                return new DecimalFormat(patterns.get(2), DecimalFormatSymbols.getInstance(locale));
            }

            private AtomicReferenceArray<String> getNumberPatterns(Locale locale) {
                AtomicReferenceArray<String> patterns;
                SoftReference ref = (SoftReference)numberFormatCache.get(locale);
                if (ref == null || (patterns = (AtomicReferenceArray<String>)ref.get()) == null) {
                    String langtag = locale.toLanguageTag();
                    patterns = new AtomicReferenceArray<String>(4);
                    for (int i = 0; i <= 3; ++i) {
                        patterns.compareAndSet(i, null, HostLocaleProviderAdapterImpl.getNumberPattern(i, langtag));
                    }
                    ref = new SoftReference(patterns);
                    numberFormatCache.put(locale, ref);
                }
                return patterns;
            }
        };
    }

    public static DecimalFormatSymbolsProvider getDecimalFormatSymbolsProvider() {
        return new DecimalFormatSymbolsProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedNativeDigitLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedNativeDigitLocale(locale);
            }

            @Override
            public DecimalFormatSymbols getInstance(Locale locale) {
                DecimalFormatSymbols dfs;
                SoftReference<DecimalFormatSymbols> ref = (SoftReference<DecimalFormatSymbols>)decimalFormatSymbolsCache.get(locale);
                if (ref == null || (dfs = (DecimalFormatSymbols)ref.get()) == null) {
                    dfs = new DecimalFormatSymbols(HostLocaleProviderAdapterImpl.getNumberLocale(locale));
                    String langTag = HostLocaleProviderAdapterImpl.removeExtensions(locale).toLanguageTag();
                    dfs.setInternationalCurrencySymbol(HostLocaleProviderAdapterImpl.getInternationalCurrencySymbol(langTag, dfs.getInternationalCurrencySymbol()));
                    dfs.setCurrencySymbol(HostLocaleProviderAdapterImpl.getCurrencySymbol(langTag, dfs.getCurrencySymbol()));
                    dfs.setDecimalSeparator(HostLocaleProviderAdapterImpl.getDecimalSeparator(langTag, dfs.getDecimalSeparator()));
                    dfs.setGroupingSeparator(HostLocaleProviderAdapterImpl.getGroupingSeparator(langTag, dfs.getGroupingSeparator()));
                    dfs.setInfinity(HostLocaleProviderAdapterImpl.getInfinity(langTag, dfs.getInfinity()));
                    dfs.setMinusSign(HostLocaleProviderAdapterImpl.getMinusSign(langTag, dfs.getMinusSign()));
                    dfs.setMonetaryDecimalSeparator(HostLocaleProviderAdapterImpl.getMonetaryDecimalSeparator(langTag, dfs.getMonetaryDecimalSeparator()));
                    dfs.setNaN(HostLocaleProviderAdapterImpl.getNaN(langTag, dfs.getNaN()));
                    dfs.setPercent(HostLocaleProviderAdapterImpl.getPercent(langTag, dfs.getPercent()));
                    dfs.setPerMill(HostLocaleProviderAdapterImpl.getPerMill(langTag, dfs.getPerMill()));
                    dfs.setZeroDigit(HostLocaleProviderAdapterImpl.getZeroDigit(langTag, dfs.getZeroDigit()));
                    ref = new SoftReference<DecimalFormatSymbols>(dfs);
                    decimalFormatSymbolsCache.put(locale, ref);
                }
                return (DecimalFormatSymbols)dfs.clone();
            }
        };
    }

    public static CalendarDataProvider getCalendarDataProvider() {
        return new CalendarDataProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public int getFirstDayOfWeek(Locale locale) {
                int first = HostLocaleProviderAdapterImpl.getCalendarDataValue(HostLocaleProviderAdapterImpl.removeExtensions(locale).toLanguageTag(), 0);
                if (first != -1) {
                    return (first + 1) % 7 + 1;
                }
                return 0;
            }

            @Override
            public int getMinimalDaysInFirstWeek(Locale locale) {
                int firstWeek = HostLocaleProviderAdapterImpl.getCalendarDataValue(HostLocaleProviderAdapterImpl.removeExtensions(locale).toLanguageTag(), 1);
                return switch (firstWeek) {
                    case 1 -> 7;
                    case 2 -> 4;
                    default -> 1;
                };
            }
        };
    }

    public static CalendarNameProvider getCalendarNameProvider() {
        return new CalendarNameProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public String getDisplayName(String calendarType, int field, int value, int style, Locale locale) {
                String[] names = HostLocaleProviderAdapterImpl.getCalendarDisplayStrings(HostLocaleProviderAdapterImpl.removeExtensions(locale).toLanguageTag(), HostLocaleProviderAdapterImpl.getCalendarIDFromLDMLType(calendarType), field, style);
                if (field == 7) {
                    --value;
                }
                if (names != null && value >= 0 && value < names.length) {
                    return names[value];
                }
                return null;
            }

            @Override
            public Map<String, Integer> getDisplayNames(String calendarType, int field, int style, Locale locale) {
                HashMap<String, Integer> map = null;
                String[] names = HostLocaleProviderAdapterImpl.getCalendarDisplayStrings(HostLocaleProviderAdapterImpl.removeExtensions(locale).toLanguageTag(), HostLocaleProviderAdapterImpl.getCalendarIDFromLDMLType(calendarType), field, style);
                if (names != null) {
                    map = new HashMap<String, Integer>();
                    for (int value = 0; value < names.length; ++value) {
                        if (names[value] == null) continue;
                        map.put(names[value], field == 7 ? value + 1 : value);
                    }
                    map = map.isEmpty() ? null : map;
                }
                return map;
            }
        };
    }

    public static CalendarProvider getCalendarProvider() {
        return new CalendarProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public Calendar getInstance(TimeZone zone, Locale locale) {
                return new Calendar.Builder().setLocale(HostLocaleProviderAdapterImpl.getCalendarLocale(locale)).setTimeZone(zone).setInstant(System.currentTimeMillis()).build();
            }
        };
    }

    public static CurrencyNameProvider getCurrencyNameProvider() {
        return new CurrencyNameProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return supportedLocale;
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return supportedLocaleSet.contains(locale.stripExtensions()) && locale.getLanguage().equals(nativeDisplayLanguage);
            }

            @Override
            public String getSymbol(String currencyCode, Locale locale) {
                try {
                    if (Currency.getInstance(locale).getCurrencyCode().equals(currencyCode)) {
                        return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 1, currencyCode);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return null;
            }

            @Override
            public String getDisplayName(String currencyCode, Locale locale) {
                try {
                    if (Currency.getInstance(locale).getCurrencyCode().equals(currencyCode)) {
                        return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 0, currencyCode);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return null;
            }
        };
    }

    public static LocaleNameProvider getLocaleNameProvider() {
        return new LocaleNameProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return supportedLocale;
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return supportedLocaleSet.contains(locale.stripExtensions()) && locale.getLanguage().equals(nativeDisplayLanguage);
            }

            @Override
            public String getDisplayLanguage(String languageCode, Locale locale) {
                return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 2, languageCode);
            }

            @Override
            public String getDisplayCountry(String countryCode, Locale locale) {
                String str = HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 4, nativeDisplayLanguage + "-" + countryCode);
                if (str != null && str.endsWith("(" + countryCode + ")")) {
                    return null;
                }
                return str;
            }

            @Override
            public String getDisplayScript(String scriptCode, Locale locale) {
                return null;
            }

            @Override
            public String getDisplayVariant(String variantCode, Locale locale) {
                return null;
            }
        };
    }

    public static JavaTimeDateTimePatternProvider getJavaTimeDateTimePatternProvider() {
        return new JavaTimeDateTimePatternProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public String getJavaTimeDateTimePattern(int timeStyle, int dateStyle, String calType, Locale locale) {
                AtomicReferenceArray<String> patterns = this.getDateTimePatterns(locale);
                String datePattern = dateStyle != -1 ? patterns.get(dateStyle / 2) : "";
                String timePattern = timeStyle != -1 ? patterns.get(timeStyle / 2 + 2) : "";
                String delim = dateStyle != -1 && timeStyle != -1 ? " " : "";
                return this.toJavaTimeDateTimePattern(calType, datePattern + delim + timePattern);
            }

            private AtomicReferenceArray<String> getDateTimePatterns(Locale locale) {
                AtomicReferenceArray<String> patterns;
                SoftReference ref = (SoftReference)dateFormatCache.get(locale);
                if (ref == null || (patterns = (AtomicReferenceArray<String>)ref.get()) == null) {
                    String langtag = HostLocaleProviderAdapterImpl.removeExtensions(locale).toLanguageTag();
                    patterns = new AtomicReferenceArray<String>(4);
                    patterns.compareAndSet(0, null, HostLocaleProviderAdapterImpl.convertDateTimePattern(HostLocaleProviderAdapterImpl.getDateTimePattern(1, -1, langtag)));
                    patterns.compareAndSet(1, null, HostLocaleProviderAdapterImpl.convertDateTimePattern(HostLocaleProviderAdapterImpl.getDateTimePattern(3, -1, langtag)));
                    patterns.compareAndSet(2, null, HostLocaleProviderAdapterImpl.convertDateTimePattern(HostLocaleProviderAdapterImpl.getDateTimePattern(-1, 1, langtag)));
                    patterns.compareAndSet(3, null, HostLocaleProviderAdapterImpl.convertDateTimePattern(HostLocaleProviderAdapterImpl.getDateTimePattern(-1, 3, langtag)));
                    ref = new SoftReference(patterns);
                    dateFormatCache.put(locale, ref);
                }
                return patterns;
            }

            private String toJavaTimeDateTimePattern(String calendarType, String jrePattern) {
                int length = jrePattern.length();
                StringBuilder sb = new StringBuilder(length);
                boolean inQuote = false;
                int count = 0;
                char lastLetter = '\u0000';
                for (int i = 0; i < length; ++i) {
                    char c = jrePattern.charAt(i);
                    if (c == '\'') {
                        char nextc;
                        if (i + 1 < length && (nextc = jrePattern.charAt(i + 1)) == '\'') {
                            ++i;
                            if (count != 0) {
                                this.convert(calendarType, lastLetter, count, sb);
                                lastLetter = '\u0000';
                                count = 0;
                            }
                            sb.append("''");
                            continue;
                        }
                        if (!inQuote) {
                            if (count != 0) {
                                this.convert(calendarType, lastLetter, count, sb);
                                lastLetter = '\u0000';
                                count = 0;
                            }
                            inQuote = true;
                        } else {
                            inQuote = false;
                        }
                        sb.append(c);
                        continue;
                    }
                    if (inQuote) {
                        sb.append(c);
                        continue;
                    }
                    if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                        if (count != 0) {
                            this.convert(calendarType, lastLetter, count, sb);
                            lastLetter = '\u0000';
                            count = 0;
                        }
                        sb.append(c);
                        continue;
                    }
                    if (lastLetter == '\u0000' || lastLetter == c) {
                        lastLetter = c;
                        ++count;
                        continue;
                    }
                    this.convert(calendarType, lastLetter, count, sb);
                    lastLetter = c;
                    count = 1;
                }
                if (inQuote) {
                    return null;
                }
                if (count != 0) {
                    this.convert(calendarType, lastLetter, count, sb);
                }
                return sb.toString();
            }

            private void convert(String calendarType, char letter, int count, StringBuilder sb) {
                switch (letter) {
                    case 'G': {
                        if (calendarType.equals("japanese")) {
                            if (count >= 4) {
                                count = 1;
                                break;
                            }
                            count = 5;
                            break;
                        }
                        if (calendarType.equals("iso8601")) break;
                        if (count >= 4) {
                            count = 4;
                            break;
                        }
                        count = 1;
                        break;
                    }
                    case 'y': {
                        if (!calendarType.equals("japanese") || count < 4) break;
                        count = 1;
                        break;
                    }
                    default: {
                        if (count <= 4) break;
                        count = 4;
                    }
                }
                this.appendN(letter, count, sb);
            }

            private void appendN(char c, int n, StringBuilder sb) {
                for (int i = 0; i < n; ++i) {
                    sb.append(c);
                }
            }
        };
    }

    private static String convertDateTimePattern(String winPattern) {
        String ret = winPattern.replaceAll("dddd", "EEEE");
        ret = ret.replaceAll("ddd", "EEE");
        ret = ret.replaceAll("tt", "a");
        ret = ret.replaceAll("g", "GG");
        return ret;
    }

    private static Locale[] getSupportedCalendarLocales() {
        if (supportedLocale.length != 0 && supportedLocaleSet.contains(Locale.JAPAN) && HostLocaleProviderAdapterImpl.isJapaneseCalendar()) {
            Locale[] sup = new Locale[supportedLocale.length + 1];
            sup[0] = JRELocaleConstants.JA_JP_JP;
            System.arraycopy(supportedLocale, 0, sup, 1, supportedLocale.length);
            return sup;
        }
        return supportedLocale;
    }

    private static boolean isSupportedCalendarLocale(Locale locale) {
        Locale base = HostLocaleProviderAdapterImpl.stripVariantAndExtensions(locale);
        if (!supportedLocaleSet.contains(base)) {
            return false;
        }
        int calid = HostLocaleProviderAdapterImpl.getCalendarID(base.toLanguageTag());
        if (calid <= 0 || calid >= calIDToLDML.length) {
            return false;
        }
        String requestedCalType = locale.getUnicodeLocaleType("ca");
        String nativeCalType = calIDToLDML[calid].replaceFirst("_.*", "");
        if (requestedCalType == null) {
            return Calendar.getAvailableCalendarTypes().contains(nativeCalType);
        }
        return requestedCalType.equals(nativeCalType);
    }

    private static Locale[] getSupportedNativeDigitLocales() {
        if (supportedLocale.length != 0 && supportedLocaleSet.contains(JRELocaleConstants.TH_TH) && HostLocaleProviderAdapterImpl.isNativeDigit("th-TH")) {
            Locale[] sup = new Locale[supportedLocale.length + 1];
            sup[0] = JRELocaleConstants.TH_TH_TH;
            System.arraycopy(supportedLocale, 0, sup, 1, supportedLocale.length);
            return sup;
        }
        return supportedLocale;
    }

    private static boolean isSupportedNativeDigitLocale(Locale locale) {
        if (JRELocaleConstants.TH_TH_TH.equals(locale)) {
            return HostLocaleProviderAdapterImpl.isNativeDigit("th-TH");
        }
        String numtype = null;
        Locale base = locale;
        if (locale.hasExtensions()) {
            numtype = locale.getUnicodeLocaleType("nu");
            base = locale.stripExtensions();
        }
        if (supportedLocaleSet.contains(base)) {
            if (numtype == null || numtype.equals("latn")) {
                return true;
            }
            if (locale.getLanguage().equals("th")) {
                return "thai".equals(numtype) && HostLocaleProviderAdapterImpl.isNativeDigit(locale.toLanguageTag());
            }
        }
        return false;
    }

    private static Locale removeExtensions(Locale src) {
        return new Locale.Builder().setLocale(src).clearExtensions().build();
    }

    private static boolean isJapaneseCalendar() {
        return HostLocaleProviderAdapterImpl.getCalendarID("ja-JP") == 3;
    }

    private static Locale stripVariantAndExtensions(Locale locale) {
        if (locale.hasExtensions() || locale.getVariant() != "") {
            locale = new Locale.Builder().setLocale(locale).clearExtensions().build();
        }
        return locale;
    }

    private static Locale getCalendarLocale(Locale locale) {
        int calid = HostLocaleProviderAdapterImpl.getCalendarID(HostLocaleProviderAdapterImpl.stripVariantAndExtensions(locale).toLanguageTag());
        if (calid > 0 && calid < calIDToLDML.length) {
            Locale.Builder lb = new Locale.Builder();
            String[] caltype = calIDToLDML[calid].split("_");
            if (caltype.length > 1) {
                lb.setLocale(Locale.forLanguageTag(caltype[1]));
            } else {
                lb.setLocale(locale);
            }
            lb.setUnicodeLocaleKeyword("ca", caltype[0]);
            return lb.build();
        }
        return locale;
    }

    private static int getCalendarIDFromLDMLType(String ldmlType) {
        for (int i = 0; i < calIDToLDML.length; ++i) {
            if (!calIDToLDML[i].startsWith(ldmlType)) continue;
            return i;
        }
        return -1;
    }

    private static Locale getNumberLocale(Locale src) {
        if (JRELocaleConstants.TH_TH.equals(src) && HostLocaleProviderAdapterImpl.isNativeDigit("th-TH")) {
            Locale.Builder lb = new Locale.Builder().setLocale(src);
            lb.setUnicodeLocaleKeyword("nu", "thai");
            return lb.build();
        }
        return src;
    }

    private static native boolean initialize();

    private static native String getDefaultLocale(int var0);

    private static native String getDateTimePattern(int var0, int var1, String var2);

    private static native int getCalendarID(String var0);

    private static native String[] getAmPmStrings(String var0, String[] var1);

    private static native String[] getEras(String var0, String[] var1);

    private static native String[] getMonths(String var0, String[] var1);

    private static native String[] getShortMonths(String var0, String[] var1);

    private static native String[] getWeekdays(String var0, String[] var1);

    private static native String[] getShortWeekdays(String var0, String[] var1);

    private static native String getNumberPattern(int var0, String var1);

    private static native boolean isNativeDigit(String var0);

    private static native String getCurrencySymbol(String var0, String var1);

    private static native char getDecimalSeparator(String var0, char var1);

    private static native char getGroupingSeparator(String var0, char var1);

    private static native String getInfinity(String var0, String var1);

    private static native String getInternationalCurrencySymbol(String var0, String var1);

    private static native char getMinusSign(String var0, char var1);

    private static native char getMonetaryDecimalSeparator(String var0, char var1);

    private static native String getNaN(String var0, String var1);

    private static native char getPercent(String var0, char var1);

    private static native char getPerMill(String var0, char var1);

    private static native char getZeroDigit(String var0, char var1);

    private static native int getCalendarDataValue(String var0, int var1);

    private static native String[] getCalendarDisplayStrings(String var0, int var1, int var2, int var3);

    private static native String getDisplayString(String var0, int var1, String var2);

    static {
        HashSet<Locale> tmpSet = new HashSet<Locale>();
        if (HostLocaleProviderAdapterImpl.initialize()) {
            ResourceBundle.Control c = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT);
            String displayLocale = HostLocaleProviderAdapterImpl.getDefaultLocale(0);
            Locale l = Locale.forLanguageTag(displayLocale.replace('_', '-'));
            tmpSet.addAll(c.getCandidateLocales("", l));
            nativeDisplayLanguage = l.getLanguage();
            String formatLocale = HostLocaleProviderAdapterImpl.getDefaultLocale(1);
            if (!formatLocale.equals(displayLocale)) {
                l = Locale.forLanguageTag(formatLocale.replace('_', '-'));
                tmpSet.addAll(c.getCandidateLocales("", l));
            }
        } else {
            nativeDisplayLanguage = "";
        }
        supportedLocaleSet = Collections.unmodifiableSet(tmpSet);
        supportedLocale = supportedLocaleSet.toArray(new Locale[0]);
    }
}

