/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import sun.util.locale.provider.JRELocaleConstants;
import sun.util.locale.provider.LocaleProviderAdapter;

public final class LocaleServiceProviderPool {
    private static final ConcurrentMap<Class<? extends LocaleServiceProvider>, LocaleServiceProviderPool> poolOfPools = new ConcurrentHashMap<Class<? extends LocaleServiceProvider>, LocaleServiceProviderPool>();
    private final ConcurrentMap<Locale, List<LocaleServiceProvider>> providersCache = new ConcurrentHashMap<Locale, List<LocaleServiceProvider>>();
    private Set<Locale> availableLocales = null;
    private final Class<? extends LocaleServiceProvider> providerClass;
    static final Class<LocaleServiceProvider>[] spiClasses = new Class[]{BreakIteratorProvider.class, CollatorProvider.class, DateFormatProvider.class, DateFormatSymbolsProvider.class, DecimalFormatSymbolsProvider.class, NumberFormatProvider.class, CurrencyNameProvider.class, LocaleNameProvider.class, TimeZoneNameProvider.class, CalendarDataProvider.class};
    private static final List<LocaleServiceProvider> NULL_LIST = Collections.emptyList();

    public static LocaleServiceProviderPool getPool(Class<? extends LocaleServiceProvider> providerClass) {
        LocaleServiceProviderPool newPool;
        LocaleServiceProviderPool pool = (LocaleServiceProviderPool)poolOfPools.get(providerClass);
        if (pool == null && (pool = poolOfPools.putIfAbsent(providerClass, newPool = new LocaleServiceProviderPool(providerClass))) == null) {
            pool = newPool;
        }
        return pool;
    }

    private LocaleServiceProviderPool(Class<? extends LocaleServiceProvider> c) {
        this.providerClass = c;
    }

    public static Locale[] getAllAvailableLocales() {
        return (Locale[])AllAvailableLocales.allAvailableLocales.clone();
    }

    public Locale[] getAvailableLocales() {
        HashSet<Locale> locList = new HashSet<Locale>();
        locList.addAll(this.getAvailableLocaleSet());
        locList.addAll(Arrays.asList(LocaleProviderAdapter.forJRE().getAvailableLocales()));
        Locale[] tmp = new Locale[locList.size()];
        locList.toArray(tmp);
        return tmp;
    }

    private synchronized Set<Locale> getAvailableLocaleSet() {
        if (this.availableLocales == null) {
            this.availableLocales = new HashSet<Locale>();
            for (LocaleProviderAdapter.Type type : LocaleProviderAdapter.getAdapterPreference()) {
                Locale[] locales;
                LocaleServiceProvider lsp;
                LocaleProviderAdapter lda = LocaleProviderAdapter.forType(type);
                if (lda == null || (lsp = lda.getLocaleServiceProvider(this.providerClass)) == null) continue;
                for (Locale locale : locales = lsp.getAvailableLocales()) {
                    this.availableLocales.add(LocaleServiceProviderPool.getLookupLocale(locale));
                }
            }
        }
        return this.availableLocales;
    }

    public <P extends LocaleServiceProvider, S> S getLocalizedObject(LocalizedObjectGetter<P, S> getter, Locale locale, Object ... params) {
        return this.getLocalizedObjectImpl(getter, locale, true, null, params);
    }

    public <P extends LocaleServiceProvider, S> S getLocalizedObject(LocalizedObjectGetter<P, S> getter, Locale locale, String key, Object ... params) {
        return this.getLocalizedObjectImpl(getter, locale, false, key, params);
    }

    public <P extends LocaleServiceProvider, S> S getLocalizedObject(LocalizedObjectGetter<P, S> getter, Locale locale, Boolean isObjectProvider, String key, Object ... params) {
        return this.getLocalizedObjectImpl(getter, locale, isObjectProvider, key, params);
    }

    private <P extends LocaleServiceProvider, S> S getLocalizedObjectImpl(LocalizedObjectGetter<P, S> getter, Locale locale, boolean isObjectProvider, String key, Object ... params) {
        if (locale == null) {
            throw new NullPointerException();
        }
        List<Locale> lookupLocales = LocaleServiceProviderPool.getLookupLocales(locale);
        for (Locale current : lookupLocales) {
            for (LocaleServiceProvider lsp : this.findProviders(current, isObjectProvider)) {
                S providersObj = getter.getObject(lsp, locale, key, params);
                if (providersObj != null) {
                    return providersObj;
                }
                if (!isObjectProvider) continue;
                System.getLogger(LocaleServiceProviderPool.class.getCanonicalName()).log(System.Logger.Level.INFO, "A locale sensitive service object provider returned null, which should not happen. Provider: " + lsp + " Locale: " + locale);
            }
        }
        return null;
    }

    private List<LocaleServiceProvider> findProviders(Locale locale, boolean isObjectProvider) {
        List<LocaleServiceProvider> providersList = (List<LocaleServiceProvider>)this.providersCache.get(locale);
        if (providersList == null) {
            List<LocaleServiceProvider> val;
            for (LocaleProviderAdapter.Type type : LocaleProviderAdapter.getAdapterPreference()) {
                LocaleServiceProvider lsp;
                LocaleProviderAdapter lda = LocaleProviderAdapter.forType(type);
                if (lda == null || (lsp = lda.getLocaleServiceProvider(this.providerClass)) == null || !lsp.isSupportedLocale(locale)) continue;
                if (providersList == null) {
                    providersList = new ArrayList<LocaleServiceProvider>(2);
                }
                providersList.add(lsp);
                if (!isObjectProvider) continue;
                break;
            }
            if (providersList == null) {
                providersList = NULL_LIST;
            }
            if ((val = this.providersCache.putIfAbsent(locale, providersList)) != null) {
                providersList = val;
            }
        }
        return providersList;
    }

    static List<Locale> getLookupLocales(Locale locale) {
        return ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT).getCandidateLocales("", locale);
    }

    static Locale getLookupLocale(Locale locale) {
        Locale lookupLocale = locale;
        if (locale.hasExtensions() && !locale.equals(JRELocaleConstants.JA_JP_JP) && !locale.equals(JRELocaleConstants.TH_TH_TH)) {
            Locale.Builder locbld = new Locale.Builder();
            try {
                locbld.setLocale(locale);
                locbld.clearExtensions();
                lookupLocale = locbld.build();
            }
            catch (IllformedLocaleException e) {
                System.getLogger(LocaleServiceProviderPool.class.getCanonicalName()).log(System.Logger.Level.INFO, "A locale(" + locale + ") has non-empty extensions, but has illformed fields.");
                lookupLocale = new Locale(locale.getLanguage(), locale.getCountry(), locale.getVariant());
            }
        }
        return lookupLocale;
    }

    private static class AllAvailableLocales {
        static final Locale[] allAvailableLocales;

        private AllAvailableLocales() {
        }

        static {
            HashSet<Locale> all = new HashSet<Locale>();
            for (Class<LocaleServiceProvider> c : spiClasses) {
                LocaleServiceProviderPool pool = LocaleServiceProviderPool.getPool(c);
                all.addAll(pool.getAvailableLocaleSet());
            }
            allAvailableLocales = all.toArray(new Locale[0]);
        }
    }

    public static interface LocalizedObjectGetter<P extends LocaleServiceProvider, S> {
        public S getObject(P var1, Locale var2, String var3, Object ... var4);
    }
}

