/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.text.CompactNumberFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.spi.NumberFormatProvider;
import java.util.Currency;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import sun.util.locale.provider.AvailableLanguageTags;
import sun.util.locale.provider.CalendarDataUtility;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleResources;

public class NumberFormatProviderImpl
extends NumberFormatProvider
implements AvailableLanguageTags {
    private static final int NUMBERSTYLE = 0;
    private static final int CURRENCYSTYLE = 1;
    private static final int PERCENTSTYLE = 2;
    private static final int ACCOUNTINGSTYLE = 3;
    private static final int INTEGERSTYLE = 4;
    private final LocaleProviderAdapter.Type type;
    private final Set<String> langtags;

    public NumberFormatProviderImpl(LocaleProviderAdapter.Type type, Set<String> langtags) {
        this.type = type;
        this.langtags = langtags;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LocaleProviderAdapter.forType(this.type).getAvailableLocales();
    }

    @Override
    public boolean isSupportedLocale(Locale locale) {
        return LocaleProviderAdapter.forType(this.type).isSupportedProviderLocale(locale, this.langtags);
    }

    @Override
    public NumberFormat getCurrencyInstance(Locale locale) {
        return this.getInstance(locale, 1);
    }

    @Override
    public NumberFormat getIntegerInstance(Locale locale) {
        return this.getInstance(locale, 4);
    }

    @Override
    public NumberFormat getNumberInstance(Locale locale) {
        return this.getInstance(locale, 0);
    }

    @Override
    public NumberFormat getPercentInstance(Locale locale) {
        return this.getInstance(locale, 2);
    }

    private NumberFormat getInstance(Locale locale, int choice) {
        int entry;
        if (locale == null) {
            throw new NullPointerException();
        }
        Locale override = locale.getUnicodeLocaleType("nu") == null ? CalendarDataUtility.findRegionOverride(locale) : locale;
        LocaleProviderAdapter adapter = LocaleProviderAdapter.forType(this.type);
        String[] numberPatterns = adapter.getLocaleResources(override).getNumberPatterns();
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(override);
        int n = entry = choice == 4 ? 0 : choice;
        if (choice == 1 && numberPatterns.length > 3 && !numberPatterns[3].isEmpty() && "account".equalsIgnoreCase(override.getUnicodeLocaleType("cf"))) {
            entry = 3;
        }
        DecimalFormat format = new DecimalFormat(numberPatterns[entry], symbols);
        if (choice == 4) {
            format.setMaximumFractionDigits(0);
            format.setDecimalSeparatorAlwaysShown(false);
            format.setParseIntegerOnly(true);
        } else if (choice == 1) {
            NumberFormatProviderImpl.adjustForCurrencyDefaultFractionDigits(format, symbols);
        }
        return format;
    }

    private static void adjustForCurrencyDefaultFractionDigits(DecimalFormat format, DecimalFormatSymbols symbols) {
        int digits;
        Currency currency = symbols.getCurrency();
        if (currency == null) {
            try {
                currency = Currency.getInstance(symbols.getInternationalCurrencySymbol());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (currency != null && (digits = currency.getDefaultFractionDigits()) != -1) {
            int oldMinDigits = format.getMinimumFractionDigits();
            if (oldMinDigits == format.getMaximumFractionDigits()) {
                format.setMinimumFractionDigits(digits);
                format.setMaximumFractionDigits(digits);
            } else {
                format.setMinimumFractionDigits(Math.min(digits, oldMinDigits));
                format.setMaximumFractionDigits(digits);
            }
        }
    }

    @Override
    public NumberFormat getCompactNumberInstance(Locale locale, NumberFormat.Style formatStyle) {
        Objects.requireNonNull(locale);
        Objects.requireNonNull(formatStyle);
        Locale override = locale.getUnicodeLocaleType("nu") == null ? CalendarDataUtility.findRegionOverride(locale) : locale;
        LocaleProviderAdapter adapter = LocaleProviderAdapter.forType(this.type);
        LocaleResources resource = adapter.getLocaleResources(override);
        String[] numberPatterns = resource.getNumberPatterns();
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(override);
        String[] cnPatterns = resource.getCNPatterns(formatStyle);
        String[] rules = resource.getRules();
        return new CompactNumberFormat(numberPatterns[0], symbols, cnPatterns, rules[0]);
    }

    @Override
    public Set<String> getAvailableLanguageTags() {
        return this.langtags;
    }
}

