/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.BreakIterator;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CalendarNameProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import sun.util.locale.provider.AuxLocaleProviderAdapter;
import sun.util.locale.provider.CalendarDataUtility;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleServiceProviderPool;

public class SPILocaleProviderAdapter
extends AuxLocaleProviderAdapter {
    @Override
    public LocaleProviderAdapter.Type getAdapterType() {
        return LocaleProviderAdapter.Type.SPI;
    }

    @Override
    protected <P extends LocaleServiceProvider> P findInstalledProvider(final Class<P> c) {
        try {
            return (P)((LocaleServiceProvider)AccessController.doPrivileged(new PrivilegedExceptionAction<P>(){

                @Override
                public P run() {
                    LocaleServiceProvider delegate = null;
                    for (LocaleServiceProvider provider : ServiceLoader.load(c, ClassLoader.getSystemClassLoader())) {
                        if (delegate == null) {
                            try {
                                delegate = (LocaleServiceProvider)Class.forName(SPILocaleProviderAdapter.class.getCanonicalName() + "$" + c.getSimpleName() + "Delegate").newInstance();
                            }
                            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                                throw new ServiceConfigurationError("SPI locale provider cannot be instantiated.", e);
                            }
                        }
                        ((Delegate)((Object)delegate)).addImpl(provider);
                    }
                    return delegate;
                }
            }));
        }
        catch (PrivilegedActionException e) {
            throw new ServiceConfigurationError("SPI locale provider cannot be instantiated.", e);
        }
    }

    static class TimeZoneNameProviderDelegate
    extends TimeZoneNameProvider
    implements Delegate<TimeZoneNameProvider> {
        private final Map<Locale, TimeZoneNameProvider> map = new ConcurrentHashMap<Locale, TimeZoneNameProvider>();

        TimeZoneNameProviderDelegate() {
        }

        @Override
        public Map<Locale, TimeZoneNameProvider> getDelegateMap() {
            return this.map;
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.getAvailableLocalesDelegate();
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.isSupportedLocaleDelegate(locale);
        }

        @Override
        public String getDisplayName(String ID, boolean daylight, int style, Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            TimeZoneNameProvider tznp = (TimeZoneNameProvider)this.getImpl(locale);
            return tznp.getDisplayName(ID, daylight, style, locale);
        }

        @Override
        public String getGenericDisplayName(String ID, int style, Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            TimeZoneNameProvider tznp = (TimeZoneNameProvider)this.getImpl(locale);
            return tznp.getGenericDisplayName(ID, style, locale);
        }
    }

    static class LocaleNameProviderDelegate
    extends LocaleNameProvider
    implements Delegate<LocaleNameProvider> {
        private final Map<Locale, LocaleNameProvider> map = new ConcurrentHashMap<Locale, LocaleNameProvider>();

        LocaleNameProviderDelegate() {
        }

        @Override
        public Map<Locale, LocaleNameProvider> getDelegateMap() {
            return this.map;
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.getAvailableLocalesDelegate();
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.isSupportedLocaleDelegate(locale);
        }

        @Override
        public String getDisplayLanguage(String languageCode, Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            LocaleNameProvider lnp = (LocaleNameProvider)this.getImpl(locale);
            return lnp.getDisplayLanguage(languageCode, locale);
        }

        @Override
        public String getDisplayScript(String scriptCode, Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            LocaleNameProvider lnp = (LocaleNameProvider)this.getImpl(locale);
            return lnp.getDisplayScript(scriptCode, locale);
        }

        @Override
        public String getDisplayCountry(String countryCode, Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            LocaleNameProvider lnp = (LocaleNameProvider)this.getImpl(locale);
            return lnp.getDisplayCountry(countryCode, locale);
        }

        @Override
        public String getDisplayVariant(String variant, Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            LocaleNameProvider lnp = (LocaleNameProvider)this.getImpl(locale);
            return lnp.getDisplayVariant(variant, locale);
        }

        @Override
        public String getDisplayUnicodeExtensionKey(String key, Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            LocaleNameProvider lnp = (LocaleNameProvider)this.getImpl(locale);
            return lnp.getDisplayUnicodeExtensionKey(key, locale);
        }

        @Override
        public String getDisplayUnicodeExtensionType(String extType, String key, Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            LocaleNameProvider lnp = (LocaleNameProvider)this.getImpl(locale);
            return lnp.getDisplayUnicodeExtensionType(extType, key, locale);
        }
    }

    static class CurrencyNameProviderDelegate
    extends CurrencyNameProvider
    implements Delegate<CurrencyNameProvider> {
        private final Map<Locale, CurrencyNameProvider> map = new ConcurrentHashMap<Locale, CurrencyNameProvider>();

        CurrencyNameProviderDelegate() {
        }

        @Override
        public Map<Locale, CurrencyNameProvider> getDelegateMap() {
            return this.map;
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.getAvailableLocalesDelegate();
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.isSupportedLocaleDelegate(locale);
        }

        @Override
        public String getSymbol(String currencyCode, Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            CurrencyNameProvider cnp = (CurrencyNameProvider)this.getImpl(locale);
            return cnp.getSymbol(currencyCode, locale);
        }

        @Override
        public String getDisplayName(String currencyCode, Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            CurrencyNameProvider cnp = (CurrencyNameProvider)this.getImpl(locale);
            return cnp.getDisplayName(currencyCode, locale);
        }
    }

    static class CalendarNameProviderDelegate
    extends CalendarNameProvider
    implements Delegate<CalendarNameProvider> {
        private final Map<Locale, CalendarNameProvider> map = new ConcurrentHashMap<Locale, CalendarNameProvider>();

        CalendarNameProviderDelegate() {
        }

        @Override
        public Map<Locale, CalendarNameProvider> getDelegateMap() {
            return this.map;
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.getAvailableLocalesDelegate();
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.isSupportedLocaleDelegate(locale);
        }

        @Override
        public String getDisplayName(String calendarType, int field, int value, int style, Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            CalendarNameProvider cdp = (CalendarNameProvider)this.getImpl(locale);
            return cdp.getDisplayName(calendarType, field, value, style, locale);
        }

        @Override
        public Map<String, Integer> getDisplayNames(String calendarType, int field, int style, Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            CalendarNameProvider cdp = (CalendarNameProvider)this.getImpl(locale);
            return cdp.getDisplayNames(calendarType, field, style, locale);
        }
    }

    static class CalendarDataProviderDelegate
    extends CalendarDataProvider
    implements Delegate<CalendarDataProvider> {
        private final Map<Locale, CalendarDataProvider> map = new ConcurrentHashMap<Locale, CalendarDataProvider>();

        CalendarDataProviderDelegate() {
        }

        @Override
        public Map<Locale, CalendarDataProvider> getDelegateMap() {
            return this.map;
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.getAvailableLocalesDelegate();
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.isSupportedLocaleDelegate(locale);
        }

        @Override
        public int getFirstDayOfWeek(Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            CalendarDataProvider cdp = (CalendarDataProvider)this.getImpl(locale);
            return cdp.getFirstDayOfWeek(locale);
        }

        @Override
        public int getMinimalDaysInFirstWeek(Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            CalendarDataProvider cdp = (CalendarDataProvider)this.getImpl(locale);
            return cdp.getMinimalDaysInFirstWeek(locale);
        }
    }

    static class NumberFormatProviderDelegate
    extends NumberFormatProvider
    implements Delegate<NumberFormatProvider> {
        private final Map<Locale, NumberFormatProvider> map = new ConcurrentHashMap<Locale, NumberFormatProvider>();

        NumberFormatProviderDelegate() {
        }

        @Override
        public Map<Locale, NumberFormatProvider> getDelegateMap() {
            return this.map;
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.getAvailableLocalesDelegate();
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.isSupportedLocaleDelegate(locale);
        }

        @Override
        public NumberFormat getCurrencyInstance(Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            NumberFormatProvider nfp = (NumberFormatProvider)this.getImpl(locale);
            return nfp.getCurrencyInstance(locale);
        }

        @Override
        public NumberFormat getIntegerInstance(Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            NumberFormatProvider nfp = (NumberFormatProvider)this.getImpl(locale);
            return nfp.getIntegerInstance(locale);
        }

        @Override
        public NumberFormat getNumberInstance(Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            NumberFormatProvider nfp = (NumberFormatProvider)this.getImpl(locale);
            return nfp.getNumberInstance(locale);
        }

        @Override
        public NumberFormat getPercentInstance(Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            NumberFormatProvider nfp = (NumberFormatProvider)this.getImpl(locale);
            return nfp.getPercentInstance(locale);
        }

        @Override
        public NumberFormat getCompactNumberInstance(Locale locale, NumberFormat.Style style) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            NumberFormatProvider nfp = (NumberFormatProvider)this.getImpl(locale);
            return nfp.getCompactNumberInstance(locale, style);
        }
    }

    static class DecimalFormatSymbolsProviderDelegate
    extends DecimalFormatSymbolsProvider
    implements Delegate<DecimalFormatSymbolsProvider> {
        private final Map<Locale, DecimalFormatSymbolsProvider> map = new ConcurrentHashMap<Locale, DecimalFormatSymbolsProvider>();

        DecimalFormatSymbolsProviderDelegate() {
        }

        @Override
        public Map<Locale, DecimalFormatSymbolsProvider> getDelegateMap() {
            return this.map;
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.getAvailableLocalesDelegate();
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.isSupportedLocaleDelegate(locale);
        }

        @Override
        public DecimalFormatSymbols getInstance(Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            DecimalFormatSymbolsProvider dfsp = (DecimalFormatSymbolsProvider)this.getImpl(locale);
            return dfsp.getInstance(locale);
        }
    }

    static class DateFormatSymbolsProviderDelegate
    extends DateFormatSymbolsProvider
    implements Delegate<DateFormatSymbolsProvider> {
        private final Map<Locale, DateFormatSymbolsProvider> map = new ConcurrentHashMap<Locale, DateFormatSymbolsProvider>();

        DateFormatSymbolsProviderDelegate() {
        }

        @Override
        public Map<Locale, DateFormatSymbolsProvider> getDelegateMap() {
            return this.map;
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.getAvailableLocalesDelegate();
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.isSupportedLocaleDelegate(locale);
        }

        @Override
        public DateFormatSymbols getInstance(Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            DateFormatSymbolsProvider dfsp = (DateFormatSymbolsProvider)this.getImpl(locale);
            return dfsp.getInstance(locale);
        }
    }

    static class DateFormatProviderDelegate
    extends DateFormatProvider
    implements Delegate<DateFormatProvider> {
        private final Map<Locale, DateFormatProvider> map = new ConcurrentHashMap<Locale, DateFormatProvider>();

        DateFormatProviderDelegate() {
        }

        @Override
        public Map<Locale, DateFormatProvider> getDelegateMap() {
            return this.map;
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.getAvailableLocalesDelegate();
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.isSupportedLocaleDelegate(locale);
        }

        @Override
        public DateFormat getTimeInstance(int style, Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            DateFormatProvider dfp = (DateFormatProvider)this.getImpl(locale);
            return dfp.getTimeInstance(style, locale);
        }

        @Override
        public DateFormat getDateInstance(int style, Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            DateFormatProvider dfp = (DateFormatProvider)this.getImpl(locale);
            return dfp.getDateInstance(style, locale);
        }

        @Override
        public DateFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            DateFormatProvider dfp = (DateFormatProvider)this.getImpl(locale);
            return dfp.getDateTimeInstance(dateStyle, timeStyle, locale);
        }
    }

    static class CollatorProviderDelegate
    extends CollatorProvider
    implements Delegate<CollatorProvider> {
        private final Map<Locale, CollatorProvider> map = new ConcurrentHashMap<Locale, CollatorProvider>();

        CollatorProviderDelegate() {
        }

        @Override
        public Map<Locale, CollatorProvider> getDelegateMap() {
            return this.map;
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.getAvailableLocalesDelegate();
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.isSupportedLocaleDelegate(locale);
        }

        @Override
        public Collator getInstance(Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            CollatorProvider cp = (CollatorProvider)this.getImpl(locale);
            return cp.getInstance(locale);
        }
    }

    static class BreakIteratorProviderDelegate
    extends BreakIteratorProvider
    implements Delegate<BreakIteratorProvider> {
        private final Map<Locale, BreakIteratorProvider> map = new ConcurrentHashMap<Locale, BreakIteratorProvider>();

        BreakIteratorProviderDelegate() {
        }

        @Override
        public Map<Locale, BreakIteratorProvider> getDelegateMap() {
            return this.map;
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.getAvailableLocalesDelegate();
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.isSupportedLocaleDelegate(locale);
        }

        @Override
        public BreakIterator getWordInstance(Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            BreakIteratorProvider bip = (BreakIteratorProvider)this.getImpl(locale);
            return bip.getWordInstance(locale);
        }

        @Override
        public BreakIterator getLineInstance(Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            BreakIteratorProvider bip = (BreakIteratorProvider)this.getImpl(locale);
            return bip.getLineInstance(locale);
        }

        @Override
        public BreakIterator getCharacterInstance(Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            BreakIteratorProvider bip = (BreakIteratorProvider)this.getImpl(locale);
            return bip.getCharacterInstance(locale);
        }

        @Override
        public BreakIterator getSentenceInstance(Locale locale) {
            locale = CalendarDataUtility.findRegionOverride(locale);
            BreakIteratorProvider bip = (BreakIteratorProvider)this.getImpl(locale);
            return bip.getSentenceInstance(locale);
        }
    }

    private static interface Delegate<P extends LocaleServiceProvider> {
        default public void addImpl(P impl) {
            for (Locale l : ((LocaleServiceProvider)impl).getAvailableLocales()) {
                this.getDelegateMap().putIfAbsent(l, impl);
            }
        }

        default public P getImpl(Locale locale) {
            for (Locale l : LocaleServiceProviderPool.getLookupLocales(locale.stripExtensions())) {
                LocaleServiceProvider ret = (LocaleServiceProvider)this.getDelegateMap().get(l);
                if (ret == null) continue;
                return (P)ret;
            }
            return null;
        }

        public Map<Locale, P> getDelegateMap();

        default public Locale[] getAvailableLocalesDelegate() {
            return this.getDelegateMap().keySet().toArray(new Locale[0]);
        }

        default public boolean isSupportedLocaleDelegate(Locale locale) {
            Locale override;
            Map<Locale, P> map = this.getDelegateMap();
            LocaleServiceProvider impl = (LocaleServiceProvider)map.get(override = CalendarDataUtility.findRegionOverride(locale));
            if (impl != null) {
                return impl.isSupportedLocale(override);
            }
            Locale overrideNoExt = override.stripExtensions();
            impl = (LocaleServiceProvider)map.get(overrideNoExt);
            if (impl != null) {
                return Arrays.stream(impl.getAvailableLocales()).anyMatch(overrideNoExt::equals);
            }
            return false;
        }
    }
}

