/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.spi.TimeZoneNameProvider;
import sun.util.locale.provider.LocaleProviderAdapter;

public class TimeZoneNameProviderImpl
extends TimeZoneNameProvider {
    private final LocaleProviderAdapter.Type type;
    private final Set<String> langtags;

    protected TimeZoneNameProviderImpl(LocaleProviderAdapter.Type type, Set<String> langtags) {
        this.type = type;
        this.langtags = langtags;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LocaleProviderAdapter.toLocaleArray(this.langtags);
    }

    @Override
    public boolean isSupportedLocale(Locale locale) {
        return LocaleProviderAdapter.forType(this.type).isSupportedProviderLocale(locale, this.langtags);
    }

    @Override
    public String getDisplayName(String id, boolean daylight, int style, Locale locale) {
        String[] names = this.getDisplayNameArray(id, locale);
        if (Objects.nonNull(names)) {
            int index;
            assert (names.length >= 7);
            int n = index = daylight ? 3 : 1;
            if (style == 0) {
                ++index;
            }
            return names[index];
        }
        return null;
    }

    @Override
    public String getGenericDisplayName(String id, int style, Locale locale) {
        String[] names = this.getDisplayNameArray(id, locale);
        if (Objects.nonNull(names)) {
            assert (names.length >= 7);
            return names[style == 1 ? 5 : 6];
        }
        return null;
    }

    protected String[] getDisplayNameArray(String id, Locale locale) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(locale);
        return (String[])LocaleProviderAdapter.forType(this.type).getLocaleResources(locale).getTimeZoneNames(id);
    }

    protected String[][] getZoneStrings(Locale locale) {
        return LocaleProviderAdapter.forType(this.type).getLocaleResources(locale).getZoneStrings();
    }
}

