/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.lang.ref.SoftReference;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.spi.TimeZoneNameProvider;
import sun.util.calendar.ZoneInfo;
import sun.util.cldr.CLDRLocaleProviderAdapter;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleServiceProviderPool;
import sun.util.locale.provider.TimeZoneNameProviderImpl;

public final class TimeZoneNameUtility {
    private static final ConcurrentHashMap<Locale, SoftReference<String[][]>> cachedZoneData = new ConcurrentHashMap();
    private static final Map<String, SoftReference<Map<Locale, String[]>>> cachedDisplayNames = new ConcurrentHashMap<String, SoftReference<Map<Locale, String[]>>>();

    public static String[][] getZoneStrings(Locale locale) {
        String[][] zones;
        SoftReference<String[][]> data = cachedZoneData.get(locale);
        if (data == null || (zones = data.get()) == null) {
            zones = TimeZoneNameUtility.loadZoneStrings(locale);
            data = new SoftReference<String[][]>(zones);
            cachedZoneData.put(locale, data);
        }
        return zones;
    }

    private static String[][] loadZoneStrings(Locale locale) {
        LocaleProviderAdapter adapter = LocaleProviderAdapter.getAdapter(TimeZoneNameProvider.class, locale);
        TimeZoneNameProvider provider = adapter.getTimeZoneNameProvider();
        if (provider instanceof TimeZoneNameProviderImpl) {
            String[][] zoneStrings = ((TimeZoneNameProviderImpl)provider).getZoneStrings(locale);
            if (zoneStrings.length == 0 && locale.equals(Locale.ROOT)) {
                zoneStrings = TimeZoneNameUtility.getZoneStrings(Locale.ENGLISH);
            }
            return zoneStrings;
        }
        Set<String> zoneIDs = LocaleProviderAdapter.forJRE().getLocaleResources(locale).getZoneIDs();
        LinkedList<String[]> zones = new LinkedList<String[]>();
        for (String key : zoneIDs) {
            String[] names = TimeZoneNameUtility.retrieveDisplayNamesImpl(key, locale);
            if (names == null) continue;
            zones.add(names);
        }
        String[][] zonesArray = new String[zones.size()][];
        return (String[][])zones.toArray((T[])zonesArray);
    }

    public static String[] retrieveDisplayNames(String id, Locale locale) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(locale);
        return TimeZoneNameUtility.retrieveDisplayNamesImpl(id, locale);
    }

    public static String retrieveGenericDisplayName(String id, int style, Locale locale) {
        String[] names = TimeZoneNameUtility.retrieveDisplayNamesImpl(id, locale);
        if (Objects.nonNull(names)) {
            return names[6 - style];
        }
        return null;
    }

    public static String retrieveDisplayName(String id, boolean daylight, int style, Locale locale) {
        String[] names = TimeZoneNameUtility.retrieveDisplayNamesImpl(id, locale);
        if (Objects.nonNull(names)) {
            return names[(daylight ? 4 : 2) - style];
        }
        return null;
    }

    public static Optional<String> convertLDMLShortID(String shortID) {
        return TimeZoneNameUtility.canonicalTZID(shortID);
    }

    public static Optional<String> canonicalTZID(String id) {
        return ((CLDRLocaleProviderAdapter)LocaleProviderAdapter.forType(LocaleProviderAdapter.Type.CLDR)).canonicalTZID(id);
    }

    private static String[] retrieveDisplayNamesImpl(String id, Locale locale) {
        String[] names;
        LocaleServiceProviderPool pool = LocaleServiceProviderPool.getPool(TimeZoneNameProvider.class);
        Map<Locale, String[]> perLocale = null;
        SoftReference<Map<Locale, String[]>> ref = cachedDisplayNames.get(id);
        if (Objects.nonNull(ref) && Objects.nonNull(perLocale = ref.get()) && Objects.nonNull(names = perLocale.get(locale))) {
            return names;
        }
        names = new String[7];
        names[0] = id;
        for (int i = 1; i <= 6; ++i) {
            names[i] = pool.getLocalizedObject(TimeZoneNameGetter.INSTANCE, locale, i < 5 ? (i < 3 ? "std" : "dst") : "generic", i % 2, id);
        }
        if (Objects.isNull(perLocale)) {
            perLocale = new ConcurrentHashMap<Locale, String[]>();
        }
        perLocale.put(locale, names);
        ref = new SoftReference<Map<Locale, String[]>>(perLocale);
        cachedDisplayNames.put(id, ref);
        return names;
    }

    private TimeZoneNameUtility() {
    }

    private static class TimeZoneNameGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<TimeZoneNameProvider, String> {
        private static final TimeZoneNameGetter INSTANCE = new TimeZoneNameGetter();

        private TimeZoneNameGetter() {
        }

        @Override
        public String getObject(TimeZoneNameProvider timeZoneNameProvider, Locale locale, String requestID, Object ... params) {
            Map<String, String> aliases;
            String tzid;
            assert (params.length == 2);
            int style = (Integer)params[0];
            String value = TimeZoneNameGetter.getName(timeZoneNameProvider, locale, requestID, style, tzid = (String)params[1]);
            if (value == null && (aliases = ZoneInfo.getAliasTable()) != null) {
                String canonicalID = aliases.get(tzid);
                if (canonicalID != null) {
                    value = TimeZoneNameGetter.getName(timeZoneNameProvider, locale, requestID, style, canonicalID);
                }
                if (value == null) {
                    value = TimeZoneNameGetter.examineAliases(timeZoneNameProvider, locale, requestID, canonicalID != null ? canonicalID : tzid, style, aliases);
                }
            }
            return value;
        }

        private static String examineAliases(TimeZoneNameProvider tznp, Locale locale, String requestID, String tzid, int style, Map<String, String> aliases) {
            for (Map.Entry<String, String> entry : aliases.entrySet()) {
                if (!entry.getValue().equals(tzid)) continue;
                String alias = entry.getKey();
                String name = TimeZoneNameGetter.getName(tznp, locale, requestID, style, alias);
                if (name != null) {
                    return name;
                }
                name = TimeZoneNameGetter.examineAliases(tznp, locale, requestID, alias, style, aliases);
                if (name == null) continue;
                return name;
            }
            return null;
        }

        private static String getName(TimeZoneNameProvider timeZoneNameProvider, Locale locale, String requestID, int style, String tzid) {
            String value = null;
            switch (requestID) {
                case "std": {
                    value = timeZoneNameProvider.getDisplayName(tzid, false, style, locale);
                    break;
                }
                case "dst": {
                    value = timeZoneNameProvider.getDisplayName(tzid, true, style, locale);
                    break;
                }
                case "generic": {
                    value = timeZoneNameProvider.getGenericDisplayName(tzid, style, locale);
                }
            }
            return value;
        }
    }
}

