/*
 * Decompiled with CFR 0.152.
 */
package sun.util.resources;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import sun.util.ResourceBundleEnumeration;

public abstract class OpenListResourceBundle
extends ResourceBundle {
    private volatile Map<String, Object> lookup;
    private volatile Set<String> keyset;

    protected OpenListResourceBundle() {
    }

    @Override
    protected Object handleGetObject(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.loadLookupTablesIfNecessary();
        return this.lookup.get(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        ResourceBundle parentBundle = this.parent;
        return new ResourceBundleEnumeration(this.handleKeySet(), parentBundle != null ? parentBundle.getKeys() : null);
    }

    @Override
    protected Set<String> handleKeySet() {
        this.loadLookupTablesIfNecessary();
        return this.lookup.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> keySet() {
        if (this.keyset != null) {
            return this.keyset;
        }
        Set<String> ks = this.createSet();
        ks.addAll(this.handleKeySet());
        if (this.parent != null) {
            ks.addAll(this.parent.keySet());
        }
        OpenListResourceBundle openListResourceBundle = this;
        synchronized (openListResourceBundle) {
            if (this.keyset == null) {
                this.keyset = ks;
            }
        }
        return this.keyset;
    }

    protected abstract Object[][] getContents();

    void loadLookupTablesIfNecessary() {
        if (this.lookup == null) {
            this.loadLookup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLookup() {
        Object[][] contents = this.getContents();
        Map<String, Object> temp = this.createMap(contents.length);
        for (int i = 0; i < contents.length; ++i) {
            String key = (String)contents[i][0];
            Object value = contents[i][1];
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            temp.put(key, value);
        }
        OpenListResourceBundle openListResourceBundle = this;
        synchronized (openListResourceBundle) {
            if (this.lookup == null) {
                this.lookup = temp;
            }
        }
    }

    protected <K, V> Map<K, V> createMap(int size) {
        return new HashMap(size);
    }

    protected <E> Set<E> createSet() {
        return new HashSet();
    }
}

