/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.emf;

import java.awt.Dimension;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.qenherkhopeshef.graphics.emf.EMFOpCodes;
import org.qenherkhopeshef.graphics.emf.EMFPen;
import org.qenherkhopeshef.graphics.emf.EMFPoint;
import org.qenherkhopeshef.graphics.emf.EMFRectangle;
import org.qenherkhopeshef.graphics.generic.RandomAccessStream;
import org.qenherkhopeshef.graphics.generic.RandomAccessStreamUtils;

public class EMFDeviceContext
implements EMFOpCodes {
    private ArrayList objects = new ArrayList();
    private RandomAccessStream out;
    private EMFHeader header;
    private double devicePointSize = 0.05;

    public EMFDeviceContext(RandomAccessStream stream, Dimension dims, String creator, String comment) throws IOException {
        this(stream, (long)dims.getWidth(), (long)dims.getHeight(), creator, comment);
    }

    public EMFDeviceContext(RandomAccessStream stream, long width, long height, String creator, String comment) throws IOException {
        this.initLowLevelGraphics(stream, width, height, creator, comment);
    }

    public void beginPath() throws IOException {
        this.addCommand(59L);
    }

    public void closeMetafile() throws IOException {
        this.addCommandABC(14L, 0L, 16L, 20L);
        this.header.write();
        this.out.close();
    }

    public void deleteObject(int nobj) throws IOException {
        this.objects.set(nobj, Boolean.FALSE);
        this.addCommandX(40L, nobj);
    }

    public void endPath() throws IOException {
        this.addCommand(60L);
    }

    public void fillPath() throws IOException {
        this.addRecordWithByteNumber(62L, 16L);
        RandomAccessStreamUtils.writeS32(this.out, 0L);
        RandomAccessStreamUtils.writeU32(this.out, 0L);
        RandomAccessStreamUtils.writeU32(this.out, Integer.MAX_VALUE);
        RandomAccessStreamUtils.writeU32(this.out, Integer.MAX_VALUE);
    }

    public void lineTo(long x, long y) throws IOException {
        this.addCommandXY(54L, x, y);
    }

    public void moveToEx(long x, long y) throws IOException {
        this.addCommandXY(27L, x, y);
    }

    public void polyBezierTo(EMFRectangle boundingBox, EMFPoint[] controls) throws IOException {
        int i;
        this.addRecord(5L, controls.length * 2 + 1 + 4);
        if (boundingBox == null) {
            boundingBox = new EMFRectangle();
            for (i = 0; i < controls.length; ++i) {
                if (controls[i].getX() > boundingBox.getMaxx()) {
                    boundingBox.setMaxx(controls[i].getX());
                }
                if (controls[i].getX() < boundingBox.getMinx()) {
                    boundingBox.setMinx(controls[i].getX());
                }
                if (controls[i].getY() > boundingBox.getMaxy()) {
                    boundingBox.setMaxy(controls[i].getY());
                }
                if (controls[i].getY() >= boundingBox.getMiny()) continue;
                boundingBox.setMiny(controls[i].getY());
            }
        }
        RandomAccessStreamUtils.writeU32(this.out, boundingBox.getMinx());
        RandomAccessStreamUtils.writeU32(this.out, boundingBox.getMiny());
        RandomAccessStreamUtils.writeU32(this.out, boundingBox.getMaxx());
        RandomAccessStreamUtils.writeU32(this.out, boundingBox.getMaxy());
        RandomAccessStreamUtils.writeU32(this.out, controls.length);
        for (i = 0; i < controls.length; ++i) {
            RandomAccessStreamUtils.writeU32(this.out, controls[i].getX());
            RandomAccessStreamUtils.writeU32(this.out, controls[i].getY());
        }
    }

    public void polyBezierTo16(EMFRectangle boundingBox, EMFPoint[] controls) throws IOException {
        this.addRecord(88L, controls.length + 1 + 4);
        RandomAccessStreamUtils.writeU32(this.out, boundingBox.getMinx());
        RandomAccessStreamUtils.writeU32(this.out, boundingBox.getMiny());
        RandomAccessStreamUtils.writeU32(this.out, boundingBox.getMaxx());
        RandomAccessStreamUtils.writeU32(this.out, boundingBox.getMaxy());
        RandomAccessStreamUtils.writeU32(this.out, controls.length);
        for (int i = 0; i < controls.length; ++i) {
            RandomAccessStreamUtils.writeU16(this.out, (short)controls[i].getX());
            RandomAccessStreamUtils.writeU16(this.out, (short)controls[i].getY());
        }
    }

    public short createBrush(long hatch, long colour, long style) throws IOException {
        this.addRecordWithByteNumber(39L, 16L);
        short objectId = this.allocObject();
        RandomAccessStreamUtils.writeU32(this.out, objectId);
        RandomAccessStreamUtils.writeU32(this.out, style);
        this.writeColor((int)colour);
        RandomAccessStreamUtils.writeU32(this.out, hatch);
        return objectId;
    }

    public short createPen(int penStyle, int width, long colour) throws IOException {
        this.addRecordWithByteNumber(38L, 20L);
        short objectId = this.allocObject();
        RandomAccessStreamUtils.writeU32(this.out, objectId);
        RandomAccessStreamUtils.writeU32(this.out, penStyle);
        RandomAccessStreamUtils.writeU32(this.out, width);
        RandomAccessStreamUtils.writeU32(this.out, 0L);
        this.writeColor((int)colour);
        return objectId;
    }

    public void setBkColor(long color) throws IOException {
        throw new UnsupportedOperationException("to do.");
    }

    public void strokePath(int minx, int miny, int maxx, int maxy) throws IOException {
        this.addRecord(64L, 4L);
        RandomAccessStreamUtils.writeS32(this.out, minx);
        RandomAccessStreamUtils.writeU32(this.out, miny);
        RandomAccessStreamUtils.writeU32(this.out, maxx);
        RandomAccessStreamUtils.writeU32(this.out, maxy);
    }

    private void writeColor(int colour) throws IOException {
        int red = (colour & 0xFF0000) >> 16;
        int green = (colour & 0xFF00) >> 8;
        int blue = colour & 0xFF;
        RandomAccessStreamUtils.writeU8(this.out, red);
        RandomAccessStreamUtils.writeU8(this.out, green);
        RandomAccessStreamUtils.writeU8(this.out, blue);
        RandomAccessStreamUtils.writeU8(this.out, 0);
    }

    public void setMapMode(long mapMode) throws IOException {
        this.addCommandX(17L, mapMode);
    }

    private void addCommand(long func) throws IOException {
        this.addRecord(func, 0L);
    }

    private void addCommandX(long emr_code, long arg0) throws IOException {
        this.addRecord(emr_code, 1L);
        RandomAccessStreamUtils.writeU32(this.out, arg0);
    }

    private void addCommandXY(long emr_code, long a, long b) throws IOException {
        this.addRecord(emr_code, 2L);
        RandomAccessStreamUtils.writeU32(this.out, a);
        RandomAccessStreamUtils.writeU32(this.out, b);
    }

    private void addCommandABC(long emr_code, long a, long b, long c) throws IOException {
        this.addRecord(emr_code, 3L);
        RandomAccessStreamUtils.writeU32(this.out, a);
        RandomAccessStreamUtils.writeU32(this.out, b);
        RandomAccessStreamUtils.writeU32(this.out, c);
    }

    private void addRecord(long func, long numberOfparameters) throws IOException {
        this.addRecordWithByteNumber(func, numberOfparameters * 4L);
    }

    private void addRecordWithByteNumber(long func, long byteNumber) {
        long size = 8L + byteNumber;
        ++this.header.numberOfRecords;
        this.header.metafileSize = (int)((long)this.header.metafileSize + size);
        RandomAccessStreamUtils.writeU32(this.out, func);
        RandomAccessStreamUtils.writeU32(this.out, size);
    }

    private void addByte(int data) {
        ++this.header.metafileSize;
        RandomAccessStreamUtils.writeU8(this.out, data);
    }

    private short allocObject() {
        short result;
        int i;
        for (i = 1; i < this.objects.size() && ((Boolean)this.objects.get(i)).booleanValue(); ++i) {
        }
        if (i == this.objects.size()) {
            result = (short)i;
            this.objects.add(Boolean.TRUE);
        } else {
            result = (short)i;
            this.objects.set(i, Boolean.TRUE);
        }
        this.header.numOfHandles = (short)(this.header.numOfHandles + 1);
        return result;
    }

    private void initLowLevelGraphics(RandomAccessStream stream, long width, long height, String creator, String comment) throws IOException {
        this.objects.add(new Integer(0));
        this.out = stream;
        this.header = new EMFHeader();
        this.header.boundsRight = (int)Math.ceil(width);
        this.header.boundsBottom = (int)Math.ceil(height);
        this.setDevicePointSize(0.01);
        if (creator != null || comment != null) {
            this.prepareCommentArray(creator, comment);
        }
        this.header.write();
    }

    private void prepareCommentArray(String creator, String comment) throws IOException {
        try {
            if (comment != null && creator == null) {
                creator = "org.qenherkhopeshef";
            }
            if (comment == null) {
                comment = "";
            }
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            o.write(creator.getBytes("UTF-16LE"));
            o.write(0);
            o.write(0);
            o.write(comment.getBytes("UTF-16LE"));
            o.write(0);
            o.write(0);
            o.write(0);
            o.write(0);
            o.close();
            this.header.setComment(o.toByteArray());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setReferenceRatios(long dXpixels, long dyPixels, long dxMM, long dyMM) {
        this.header.widthDevPixels = dXpixels;
        this.header.heightDevPixels = dyPixels;
        this.header.widthDevMM = dxMM;
        this.header.heightDevMM = dyMM;
    }

    public double getXScale() {
        return (double)this.header.widthDevMM / (double)this.header.widthDevPixels;
    }

    public double getYScale() {
        return (double)this.header.heightDevMM / (double)this.header.heightDevPixels;
    }

    public void setDevicePointSize(double devicePointSize) {
        this.devicePointSize = devicePointSize;
        this.header.frameRight = (long)Math.ceil((double)this.header.boundsRight * devicePointSize * 100.0);
        this.header.frameBottom = (long)Math.ceil((double)this.header.boundsBottom * devicePointSize * 100.0);
        this.header.widthDevMM = (long)Math.ceil((double)this.header.widthDevPixels * devicePointSize);
        this.header.heightDevMM = (long)Math.ceil((double)this.header.heightDevPixels * devicePointSize);
    }

    public double getDevicePointSize() {
        return this.devicePointSize;
    }

    public void selectObject(long nobj) throws IOException {
        this.addCommandX(37L, nobj);
    }

    public void closeFigure() throws IOException {
        this.addCommand(61L);
    }

    public void setWindowOrg(int x, int y) throws IOException {
        this.addCommandXY(10L, x, y);
    }

    public void setWindowExt(int w, int h) throws IOException {
        this.addCommandXY(9L, w, h);
    }

    public void setWindowOrgEx(int x, int y) throws IOException {
        this.addCommandXY(10L, x, y);
    }

    public void setWindowExtEx(int w, int h) throws IOException {
        this.addCommandXY(9L, w, h);
    }

    public void setBkMode(int bkMode) throws IOException {
        this.addCommandX(18L, bkMode);
    }

    public void lineTo(EMFPoint point) throws IOException {
        this.lineTo(point.getX(), point.getY());
    }

    public void moveToEx(EMFPoint point) throws IOException {
        this.moveToEx(point.getX(), point.getY());
    }

    public EMFPen createPenBrush(int penStyle, short width, long penColour, short fillhatch, long fillColour, int fillStyle) throws IOException {
        short p = this.createPen(penStyle, width, penColour);
        short b = this.createBrush(fillhatch, fillColour, fillStyle);
        return new EMFPen(p, b);
    }

    public EMFPen createDrawPen(int penStyle, short width, long colour) throws IOException {
        return this.createPenBrush(penStyle, width, colour, (short)1, colour, 1);
    }

    public EMFPen createDrawPen(short width, long colour) throws IOException {
        return this.createPenBrush(0, width, colour, (short)1, colour, 1);
    }

    public EMFPen createFillPen(short fillHatch, long colour, int fillStyle) throws IOException {
        return this.createPenBrush(5, (short)0, colour, fillHatch, colour, fillStyle);
    }

    public void deletePen(EMFPen pen) throws IOException {
        this.deleteObject(pen.brushNum);
        this.deleteObject(pen.penNum);
    }

    public void saveDC() throws IOException {
        this.addCommand(33L);
    }

    public void restoreDC() throws IOException {
        this.addCommandX(34L, 1L);
    }

    public EMFPen createFillPen(long colour) throws IOException {
        return this.createPenBrush(5, (short)0, colour, (short)1, colour, 0);
    }

    public void selectPen(EMFPen pen) throws IOException {
        this.selectObject(pen.getPenNum());
        this.selectObject(pen.getBrushNum());
    }

    public void freePen(EMFPen pen) throws IOException {
        this.deleteObject(pen.getPenNum());
        this.deleteObject(pen.getBrushNum());
    }

    public void setViewPortOrgEx(int x, int y) throws IOException {
        this.addCommandXY(12L, x, y);
    }

    public void setTextColor(int col) throws IOException {
        this.addCommandX(24L, col);
    }

    class EMFHeader {
        int recordType = 1;
        int recordSize = 88;
        long boundsLeft = 0L;
        long boundsTop = 0L;
        long boundsRight = 1000L;
        long boundsBottom = 1000L;
        long frameLeft = 0L;
        long frameTop = 0L;
        long frameRight = 1000L;
        long frameBottom = 1000L;
        int signature = 1179469088;
        int version = 65536;
        int metafileSize = 88;
        int numberOfRecords = 1;
        short numOfHandles = 1;
        short reserved = 0;
        int sizeOfDescrip;
        int offsOfDescrip;
        int numPalEntries;
        long widthDevPixels = 1000L;
        long heightDevPixels = 1000L;
        long widthDevMM = 10L;
        long heightDevMM = 10L;
        private byte[] comment = null;

        EMFHeader() {
        }

        private void write() throws IOException {
            EMFDeviceContext.this.out.seek(0);
            RandomAccessStreamUtils.writeU32(EMFDeviceContext.this.out, this.recordType);
            RandomAccessStreamUtils.writeU32(EMFDeviceContext.this.out, this.recordSize);
            RandomAccessStreamUtils.writeS32(EMFDeviceContext.this.out, this.boundsLeft);
            RandomAccessStreamUtils.writeS32(EMFDeviceContext.this.out, this.boundsTop);
            RandomAccessStreamUtils.writeS32(EMFDeviceContext.this.out, this.boundsRight);
            RandomAccessStreamUtils.writeS32(EMFDeviceContext.this.out, this.boundsBottom);
            RandomAccessStreamUtils.writeS32(EMFDeviceContext.this.out, this.frameLeft);
            RandomAccessStreamUtils.writeS32(EMFDeviceContext.this.out, this.frameTop);
            RandomAccessStreamUtils.writeS32(EMFDeviceContext.this.out, this.frameRight);
            RandomAccessStreamUtils.writeS32(EMFDeviceContext.this.out, this.frameBottom);
            RandomAccessStreamUtils.writeU32(EMFDeviceContext.this.out, this.signature);
            RandomAccessStreamUtils.writeU32(EMFDeviceContext.this.out, this.version);
            RandomAccessStreamUtils.writeU32(EMFDeviceContext.this.out, this.metafileSize);
            RandomAccessStreamUtils.writeU32(EMFDeviceContext.this.out, this.numberOfRecords);
            RandomAccessStreamUtils.writeU16(EMFDeviceContext.this.out, this.numOfHandles);
            RandomAccessStreamUtils.writeU16(EMFDeviceContext.this.out, this.reserved);
            if (this.comment == null) {
                RandomAccessStreamUtils.writeU32(EMFDeviceContext.this.out, this.sizeOfDescrip);
                RandomAccessStreamUtils.writeU32(EMFDeviceContext.this.out, this.offsOfDescrip);
            } else {
                RandomAccessStreamUtils.writeU32(EMFDeviceContext.this.out, this.comment.length / 2);
                RandomAccessStreamUtils.writeU32(EMFDeviceContext.this.out, 88L);
            }
            RandomAccessStreamUtils.writeU32(EMFDeviceContext.this.out, this.numPalEntries);
            RandomAccessStreamUtils.writeS32(EMFDeviceContext.this.out, this.widthDevPixels);
            RandomAccessStreamUtils.writeS32(EMFDeviceContext.this.out, this.heightDevPixels);
            RandomAccessStreamUtils.writeS32(EMFDeviceContext.this.out, this.widthDevMM);
            RandomAccessStreamUtils.writeS32(EMFDeviceContext.this.out, this.heightDevMM);
            if (this.comment != null) {
                for (int i = 0; i < this.comment.length; ++i) {
                    EMFDeviceContext.this.out.write(this.comment[i]);
                }
                if (this.comment.length % 4 != 0) {
                    EMFDeviceContext.this.out.write(0);
                    EMFDeviceContext.this.out.write(0);
                }
            }
        }

        public void setComment(byte[] comment) {
            if (comment.length % 2 != 0) {
                throw new RuntimeException("Comment array in EMF is an even sized byte array");
            }
            this.comment = comment;
            this.metafileSize += comment.length;
            this.recordSize += comment.length;
            if (comment.length % 4 != 0) {
                this.metafileSize += 2;
                this.recordSize += 2;
            }
        }
    }
}

