/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.generic;

import org.qenherkhopeshef.graphics.generic.RandomAccessStream;

public class RandomAccessByteArray
implements RandomAccessStream {
    private static final int CHUNK_SIZE = 0x100000;
    private int size = 0;
    private int pos = 0;
    private byte[] data = new byte[0x100000];

    public RandomAccessByteArray() {
    }

    public RandomAccessByteArray(byte[] array) {
        this.size = array.length;
        this.data = new byte[(array.length / 0x100000 + 1) * 0x100000];
        System.arraycopy(array, 0, this.data, 0, this.size);
    }

    @Override
    public void seek(int i) {
        this.ensureExist(i);
        this.pos = i;
        if (this.pos > this.size) {
            this.size = this.pos;
        }
    }

    @Override
    public int tell() {
        return this.pos;
    }

    private void ensureExist(int i) {
        if (i >= this.data.length) {
            int newSize;
            for (newSize = this.data.length; i >= newSize; newSize <<= 1) {
            }
            byte[] newArray = new byte[newSize];
            System.arraycopy(this.data, 0, newArray, 0, this.data.length);
            this.data = newArray;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void write(int s0) {
        this.ensureExist(this.pos);
        this.data[this.pos] = (byte)s0;
        ++this.pos;
        if (this.pos > this.size) {
            this.size = this.pos;
        }
    }

    public byte[] getByteArray() {
        return this.getByteArray(0);
    }

    public byte[] getByteArray(int first) {
        byte[] result = new byte[this.size - first];
        System.arraycopy(this.data, first, result, 0, this.size - first);
        return result;
    }

    @Override
    public void setLength(int i) {
        this.size = i;
        if (this.pos > this.size) {
            this.pos = this.size;
        }
    }

    public static void main(String[] args) {
        RandomAccessByteArray test = new RandomAccessByteArray();
        test.write(0);
        test.write(10);
        test.write(255);
        test.seek(500);
        test.write(128);
        test.seek(0);
        test.write(9);
        byte[] b = test.getByteArray();
        for (int i = 0; i < b.length; ++i) {
            System.out.println(b[i]);
        }
    }
}

