/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.pdf;

import com.lowagie.text.pdf.CMYKColor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.util.Map;
import java.util.Properties;
import org.qenherkhopeshef.graphics.generic.BaseGraphics2D;
import org.qenherkhopeshef.graphics.generic.StreamGraphicsConfiguration;

public class QenherPDFGraphics2D
extends BaseGraphics2D {
    Graphics2D delegate;
    int depth = 0;
    public static final CMYKColor CMYK_BLACK = new CMYKColor(0, 0, 0, 255);
    public static final CMYKColor CMYK_WHITE = new CMYKColor(0, 0, 0, 0);

    public QenherPDFGraphics2D(Graphics2D g2d) {
        this.delegate = g2d;
        this.setFont(new Font("SansSerif", 0, 12));
    }

    private QenherPDFGraphics2D(QenherPDFGraphics2D g) {
        super(g);
        this.delegate = g.delegate;
        this.depth = g.depth + 1;
    }

    @Override
    public void draw(Shape s) {
        Shape transformed = this.getStroke().createStrokedShape(s);
        this.fill(transformed);
    }

    @Override
    public void fill(Shape s) {
        if (!this.delegate.getColor().getClass().equals(this.getColor().getClass()) || !this.delegate.getColor().equals(this.getColor())) {
            this.delegate.setColor(this.getColor());
        }
        this.delegate.fill(this.getTransform().createTransformedShape(s));
    }

    @Override
    public Graphics create() {
        return new QenherPDFGraphics2D(this);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return new StreamGraphicsConfiguration(new Rectangle(0, 0, 10000, 10000), new AffineTransform());
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(this.getTransform(), false, true);
    }

    @Override
    public void dispose() {
        if (this.depth == 0) {
            this.delegate.dispose();
        }
    }

    @Override
    public void addRenderingHints(Map hints) {
        this.delegate.addRenderingHints(hints);
    }

    @Override
    public void setRenderingHints(Map hints) {
        this.delegate.setRenderingHints(hints);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return false;
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color c1) {
    }

    @Override
    public void setProperties(Properties properties) {
    }
}

