/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.vectorClipboard;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.qenherkhopeshef.graphics.vectorClipboard.EMFPicture;

public class EMFTransferable
implements Transferable {
    private static final String EMFATOM = "ENHMETAFILE";
    public static final DataFlavor EMF_FLAVOR = new DataFlavor("image/emf", "Enhanced MetaFile");
    private static final DataFlavor[] flavors = new DataFlavor[]{EMF_FLAVOR};
    private EMFPicture picture;

    public EMFTransferable(EMFPicture picture) {
        this.picture = picture;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (EMF_FLAVOR.equals(flavor)) {
            return new ByteArrayInputStream(this.picture.getAsByteArray());
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors = this.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    static {
        ((SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap()).addUnencodedNativeForFlavor(EMF_FLAVOR, EMFATOM);
    }
}

