/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.vectorClipboard;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.datatransfer.Transferable;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import org.qenherkhopeshef.graphics.pdf.QenherPDFGraphics2D;
import org.qenherkhopeshef.graphics.vectorClipboard.PDFTransferable;
import org.qenherkhopeshef.graphics.vectorClipboard.TransferablePicture;

public class PDFPicture
implements TransferablePicture {
    private float width;
    private float height;
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private Document document;
    private String comment = "";
    private Graphics2D graphics = null;

    public PDFPicture(float width, float height) throws FileNotFoundException {
        Rectangle pageSize = new Rectangle(width, height);
        this.document = new Document(pageSize);
        this.width = width;
        this.height = height;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void close() {
        this.document.close();
    }

    public byte[] getByteArray() {
        return this.out.toByteArray();
    }

    @Override
    public Graphics2D getGraphics() {
        if (this.graphics == null) {
            PdfWriter pdfWriter;
            try {
                pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)this.out);
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
            if (this.comment != null && !"".equals(this.comment)) {
                this.document.addSubject(this.comment);
            }
            this.document.open();
            Graphics2D g = pdfWriter.getDirectContent().createGraphicsShapes(this.width, this.height);
            this.graphics = new QenherPDFGraphics2D(g);
        }
        return this.graphics;
    }

    @Override
    public Transferable buildTransferable() {
        this.close();
        return new PDFTransferable(this);
    }
}

