/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.vectorClipboard;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.qenherkhopeshef.graphics.vectorClipboard.MACPictPicture;

public class PICTTransferable
implements Transferable {
    private static final String PICTATOM = "com.apple.pict";
    public static final DataFlavor PICT_FLAVOR = new DataFlavor("image/pict", "Mac Pict file");
    private static final DataFlavor[] flavors = new DataFlavor[]{PICT_FLAVOR};
    private MACPictPicture picture;

    public PICTTransferable(MACPictPicture currentPicture) {
        this.picture = currentPicture;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (PICT_FLAVOR.equals(flavor)) {
            return new ByteArrayInputStream(this.picture.getAsByteArray());
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors = this.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    static {
        ((SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap()).addUnencodedNativeForFlavor(PICT_FLAVOR, PICTATOM);
    }
}

