/*
 * Decompiled with CFR 0.152.
 */
package org.qenherkhopeshef.graphics.vectorClipboard;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.qenherkhopeshef.graphics.vectorClipboard.SimpleClipGraphics;

public class TestMe {
    private static final String DIRECT_EMF_WINDOWS_ONLY = "Direct EMF (Windows-only?). Should work with powerpoint, for instance.";
    private static final String STANDALONE_MACPICT = "Stand-alone Mac Pict (Mac only, very experimental- read doesn't work well at all)";
    private static final String PDF = "PDF picture (Mac only, works well with native mac applications (Mellel, word 2008)). doesn't work with ports.";
    private JComboBox<String> box;

    public TestMe() {
        JFrame frame = new JFrame();
        Container contentPanel = frame.getContentPane();
        frame.getContentPane().setLayout(new BoxLayout(frame.getContentPane(), 3));
        JButton button = new JButton("copy");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestMe.this.performCopy();
            }
        });
        contentPanel.add(button);
        this.box = new JComboBox<String>(new String[]{"MACPICT", "WMF", "EMF", DIRECT_EMF_WINDOWS_ONLY, STANDALONE_MACPICT, PDF});
        contentPanel.add(this.box);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public void performCopy() {
        SimpleClipGraphics clipGraphics = new SimpleClipGraphics(300, 200);
        if ("WMF".equals(this.box.getSelectedItem())) {
            clipGraphics.setPictureFormat(1);
        } else if ("EMF".equals(this.box.getSelectedItem())) {
            clipGraphics.setPictureFormat(2);
        } else if (DIRECT_EMF_WINDOWS_ONLY.equals(this.box.getSelectedItem())) {
            clipGraphics.setPictureFormat(4);
        } else if (STANDALONE_MACPICT.equals(this.box.getSelectedItem())) {
            clipGraphics.setPictureFormat(5);
        } else if ("MACPICT".equals(this.box.getSelectedItem())) {
            clipGraphics.setPictureFormat(3);
        } else {
            clipGraphics.setPictureFormat(6);
        }
        Graphics2D g = clipGraphics.getGraphics();
        g.setColor(Color.RED);
        g.fill(new Rectangle2D.Double(30.0, 30.0, 100.0, 100.0));
        Font f = new Font("Serif", 0, 12);
        g.setFont(f);
        String test = "just a test";
        float x = g.getFontMetrics().stringWidth(test);
        g.drawString(test, 5, 30);
        g.drawString(test, 5.0f + x, 30.0f);
        clipGraphics.copyToClipboard();
    }

    public static void main(String[] args) throws InterruptedException, InvocationTargetException {
        System.out.println("Running test");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                new TestMe();
            }
        });
    }
}

