/*
 * Decompiled with CFR 0.152.
 */
package org.qetools.task_generator;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookupFactory;

public class Utils {
    public static File getRelativeFile(File parentfile, String path) {
        StringSubstitutor defaultResolver = new StringSubstitutor(StringLookupFactory.INSTANCE.systemPropertyStringLookup());
        path = defaultResolver.replace(path);
        if (Paths.get(path, new String[0]).isAbsolute()) {
            return new File(path);
        }
        File parent = parentfile.isFile() ? parentfile.getParentFile() : parentfile;
        return new File(parent, path);
    }

    public static Map<String, String> parseQuery(String query) {
        HashMap<String, String> map = new HashMap<String, String>();
        String keyValueRegex = "(\\w+)\\s*[=~]\\s*'?\"([^(AND)]+)\"'?";
        Pattern keyValuePattern = Pattern.compile(keyValueRegex);
        Matcher m = keyValuePattern.matcher(query);
        while (m.find()) {
            map.put(m.group(1), m.group(2));
        }
        return map;
    }

    public static List<String> list(String ... strings) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : strings) {
            if (string.matches("\\[\\w*(, \\w+)*\\]")) {
                String[] newStrings;
                String newString = string.substring(1, string.length() - 1);
                for (String newStringItem : newStrings = newString.split(",")) {
                    list.add(newStringItem.trim());
                }
                continue;
            }
            list.add(string);
        }
        return list;
    }
}

