/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.jmx;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.modelmbean.RequiredModelMBean;
import org.qi4j.api.activation.Activation;
import org.qi4j.api.activation.ActivatorAdapter;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.composite.ModelDescriptor;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ImportedServiceDescriptor;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.service.qualifier.ServiceQualifier;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.Layer;
import org.qi4j.api.structure.LayerDescriptor;
import org.qi4j.api.structure.Module;
import org.qi4j.api.structure.ModuleDescriptor;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.HierarchicalVisitorAdapter;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.library.jmx.ModelMBeanBuilder;

@Mixins(value={Mixin.class})
@Activators(value={Activator.class})
public interface ApplicationManagerService
extends ServiceComposite {
    public void exportApplicationStructure() throws Exception;

    public void unexportApplicationStructure() throws Exception;

    public static class ImportedServiceBean {
        private final ImportedServiceDescriptor serviceDescriptor;

        public ImportedServiceBean(ImportedServiceDescriptor serviceDescriptor) {
            this.serviceDescriptor = serviceDescriptor;
        }

        public String getId() {
            return this.serviceDescriptor.identity();
        }

        public String getVisibility() {
            return this.serviceDescriptor.visibility().name();
        }

        public String getType() {
            Class mainType = (Class)Iterables.first((Iterable)this.serviceDescriptor.types());
            if (mainType == null) {
                return null;
            }
            return mainType.getName();
        }
    }

    public static class ServiceBean {
        private final ServiceDescriptor serviceDescriptor;
        private final Module module;

        public ServiceBean(ServiceDescriptor serviceDescriptor, Module module) {
            this.serviceDescriptor = serviceDescriptor;
            this.module = module;
        }

        public String getId() {
            return this.serviceDescriptor.identity();
        }

        public String getVisibility() {
            return this.serviceDescriptor.visibility().name();
        }

        public String getType() {
            Class first = (Class)Iterables.first((Iterable)this.serviceDescriptor.types());
            if (first == null) {
                return null;
            }
            return first.getName();
        }

        public boolean isActive() {
            Class mainType = (Class)Iterables.first((Iterable)this.serviceDescriptor.types());
            ServiceReference first = (ServiceReference)Iterables.first((Iterable)Iterables.filter((Specification)ServiceQualifier.withId((String)this.serviceDescriptor.identity()), (Iterable)this.module.findServices(mainType)));
            return first != null && first.isActive();
        }

        public boolean isAvailable() {
            Class mainType = (Class)Iterables.first((Iterable)this.serviceDescriptor.types());
            ServiceReference first = (ServiceReference)Iterables.first((Iterable)Iterables.filter((Specification)ServiceQualifier.withId((String)this.serviceDescriptor.identity()), (Iterable)this.module.findServices(mainType)));
            return first != null && first.isAvailable();
        }

        public String restart() {
            Iterable services = this.module.findServices((Class)Iterables.first((Iterable)this.serviceDescriptor.types()));
            ServiceReference serviceRef = (ServiceReference)Iterables.first((Iterable)Iterables.filter((Specification)ServiceQualifier.withId((String)this.serviceDescriptor.identity()), (Iterable)services));
            if (serviceRef != null) {
                try {
                    ((Activation)serviceRef).passivate();
                    ((Activation)serviceRef).activate();
                    return "Restarted service";
                }
                catch (Exception e) {
                    return "Could not restart service:" + e.getMessage();
                }
            }
            return "Could not find service";
        }
    }

    public static class LayerBean {
        private final Layer layer;
        private final LayerDescriptor layerDescriptor;
        private String uses;

        public LayerBean(Layer layer, LayerDescriptor layerDescriptor) {
            this.layer = layer;
            this.layerDescriptor = layerDescriptor;
            this.uses = "Uses: ";
            for (LayerDescriptor usedLayer : layerDescriptor.usedLayers().layers()) {
                this.uses = this.uses + usedLayer.name() + " ";
            }
        }

        public String getUses() {
            return this.uses;
        }

        public String restart() throws Exception {
            try {
                this.layer.passivate();
                this.layer.activate();
                return "Restarted layer";
            }
            catch (Exception e) {
                return "Could not restart layer:" + e.getMessage();
            }
        }
    }

    public static abstract class Mixin
    implements ApplicationManagerService {
        @Service
        public MBeanServer server;
        @Structure
        public Application application;
        private List<ObjectName> mbeans = new ArrayList<ObjectName>();

        @Override
        public void exportApplicationStructure() throws Exception {
            this.application.descriptor().accept((HierarchicalVisitor)new HierarchicalVisitorAdapter<Object, Object, Exception>(){
                Layer layer;
                Module module;
                Stack<ObjectName> names = new Stack();

                public boolean visitEnter(Object visited) throws Exception {
                    if (visited instanceof LayerDescriptor) {
                        LayerDescriptor layerDescriptor = (LayerDescriptor)visited;
                        this.layer = Mixin.this.application.findLayer(layerDescriptor.name());
                        LayerBean layerBean = new LayerBean(this.layer, layerDescriptor);
                        ObjectName objectName = new ObjectName("Zest:application=" + Mixin.this.application.name() + ",layer=" + this.layer.name());
                        this.names.push(objectName);
                        RequiredModelMBean mbean = new ModelMBeanBuilder(objectName, layerDescriptor.name(), LayerBean.class.getName()).attribute("uses", "Layer usages", String.class.getName(), "Other layers that this layer uses", "getUses", null).operation("restart", "Restart layer", String.class.getName(), 2, new MBeanParameterInfo[0]).newModelMBean();
                        mbean.setManagedResource(layerBean, "ObjectReference");
                        Mixin.this.server.registerMBean(mbean, objectName);
                        Mixin.this.mbeans.add(objectName);
                    } else if (visited instanceof ModuleDescriptor) {
                        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)visited;
                        this.module = Mixin.this.application.findModule(this.layer.name(), moduleDescriptor.name());
                        ObjectName objectName = new ObjectName(this.names.peek().toString() + ",module=" + moduleDescriptor.name());
                        this.names.push(objectName);
                        RequiredModelMBean mbean = new ModelMBeanBuilder(objectName, moduleDescriptor.name(), moduleDescriptor.getClass().getName()).attribute("name", "Module name", String.class.getName(), "Name of module", "name", null).newModelMBean();
                        mbean.setManagedResource(moduleDescriptor, "ObjectReference");
                        Mixin.this.server.registerMBean(mbean, objectName);
                        Mixin.this.mbeans.add(objectName);
                    } else if (visited instanceof ServiceDescriptor) {
                        ServiceDescriptor serviceDescriptor = (ServiceDescriptor)visited;
                        ObjectName objectName = new ObjectName(this.names.peek().toString() + ",class=Service,service=" + serviceDescriptor.identity());
                        RequiredModelMBean mbean = new ModelMBeanBuilder(objectName, serviceDescriptor.identity(), ServiceBean.class.getName()).attribute("Id", "Service id", String.class.getName(), "Id of service", "getId", null).attribute("Visibility", "Service visibility", String.class.getName(), "Visibility of service", "getVisibility", null).attribute("Type", "Service type", String.class.getName(), "Type of service", "getType", null).attribute("Active", "Service is active", Boolean.class.getName(), "Service is active", "isActive", null).attribute("Available", "Service is available", Boolean.class.getName(), "Service is available", "isAvailable", null).operation("restart", "Restart service", String.class.getName(), 2, new MBeanParameterInfo[0]).newModelMBean();
                        mbean.setManagedResource(new ServiceBean(serviceDescriptor, this.module), "ObjectReference");
                        Mixin.this.server.registerMBean(mbean, objectName);
                        Mixin.this.mbeans.add(objectName);
                    } else if (visited instanceof ImportedServiceDescriptor) {
                        ImportedServiceDescriptor importedServiceDescriptor = (ImportedServiceDescriptor)visited;
                        ObjectName objectName = new ObjectName(this.names.peek().toString() + ",class=Imported service,importedservice=" + importedServiceDescriptor.identity());
                        RequiredModelMBean mbean = new ModelMBeanBuilder(objectName, importedServiceDescriptor.identity(), ImportedServiceBean.class.getName()).attribute("Id", "Service id", String.class.getName(), "Id of service", "getId", null).attribute("Visibility", "Service visibility", String.class.getName(), "Visibility of service", "getVisibility", null).attribute("Type", "Service type", String.class.getName(), "Type of imported service", "getType", null).newModelMBean();
                        mbean.setManagedResource(new ImportedServiceBean(importedServiceDescriptor), "ObjectReference");
                        Mixin.this.server.registerMBean(mbean, objectName);
                        Mixin.this.mbeans.add(objectName);
                    }
                    return !(visited instanceof ModelDescriptor);
                }

                public boolean visitLeave(Object visited) throws Exception {
                    if (visited instanceof ModuleDescriptor || visited instanceof LayerDescriptor) {
                        this.names.pop();
                    }
                    return true;
                }
            });
        }

        @Override
        public void unexportApplicationStructure() throws Exception {
            for (ObjectName mbean : this.mbeans) {
                this.server.unregisterMBean(mbean);
            }
        }
    }

    public static class Activator
    extends ActivatorAdapter<ServiceReference<ApplicationManagerService>> {
        public void afterActivation(ServiceReference<ApplicationManagerService> activated) throws Exception {
            ((ApplicationManagerService)activated.get()).exportApplicationStructure();
        }

        public void beforePassivation(ServiceReference<ApplicationManagerService> passivating) throws Exception {
            ((ApplicationManagerService)passivating.get()).unexportApplicationStructure();
        }
    }
}

