/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.jmx;

import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collections;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXPrincipal;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import org.qi4j.api.activation.ActivatorAdapter;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.library.jmx.JMXConnectorConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mixins(value={JmxConnectorMixin.class})
@Activators(value={Activator.class})
public interface JMXConnectorService
extends ServiceComposite {
    public void startJMXConnector() throws Exception;

    public void stopJMXConnector() throws Exception;

    public static abstract class JmxConnectorMixin
    implements JMXConnectorService {
        final Logger logger = LoggerFactory.getLogger((String)JMXConnectorService.class.getName());
        @This
        Configuration<JMXConnectorConfiguration> config;
        @Service
        MBeanServer server;
        Registry registry;
        JMXConnectorServer connector;

        @Override
        public void startJMXConnector() throws Exception {
            if (((Boolean)((JMXConnectorConfiguration)this.config.get()).enabled().get()).booleanValue()) {
                System.setProperty("java.rmi.server.randomIDs", "true");
                int jmxAgentPort = (Integer)((JMXConnectorConfiguration)this.config.get()).port().get();
                this.registry = LocateRegistry.createRegistry(jmxAgentPort);
                String hostName = InetAddress.getLocalHost().getHostName();
                JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://" + hostName + ":" + jmxAgentPort + "/jndi/rmi://" + hostName + ":" + jmxAgentPort + "/jmxrmi");
                HashMap<String, ConfigurationJmxAuthenticator> env = new HashMap<String, ConfigurationJmxAuthenticator>();
                if (((JMXConnectorConfiguration)this.config.get()).username().get() != null) {
                    env.put("jmx.remote.authenticator", new ConfigurationJmxAuthenticator());
                }
                try {
                    this.connector = JMXConnectorServerFactory.newJMXConnectorServer(url, env, this.server);
                    this.connector.start();
                }
                catch (Exception e) {
                    this.logger.error("Could not start JMX connector", (Throwable)e);
                }
            }
        }

        @Override
        public void stopJMXConnector() throws Exception {
            if (this.connector != null) {
                this.connector.stop();
                this.connector = null;
            }
            if (this.registry != null) {
                UnicastRemoteObject.unexportObject(this.registry, true);
                this.registry = null;
            }
        }

        class ConfigurationJmxAuthenticator
        implements JMXAuthenticator {
            ConfigurationJmxAuthenticator() {
            }

            @Override
            public Subject authenticate(Object credentials) {
                Subject subject = null;
                if (!(credentials instanceof String[])) {
                    if (credentials == null) {
                        throw new SecurityException("Credentials required");
                    }
                    throw new SecurityException("Credentials should be String[]");
                }
                String[] aCredentials = (String[])credentials;
                if (aCredentials.length != 2) {
                    throw new SecurityException("Credentials should have 2 elements");
                }
                String username = aCredentials[0];
                String password = aCredentials[1];
                String configUsername = (String)((JMXConnectorConfiguration)JmxConnectorMixin.this.config.get()).username().get();
                if (configUsername != null && (!configUsername.equals(username) || password.equals(((JMXConnectorConfiguration)JmxConnectorMixin.this.config.get()).password().get()))) {
                    throw new SecurityException("User/password combination not valid.");
                }
                subject = new Subject(true, Collections.singleton(new JMXPrincipal(username)), Collections.EMPTY_SET, Collections.EMPTY_SET);
                return subject;
            }
        }
    }

    public static class Activator
    extends ActivatorAdapter<ServiceReference<JMXConnectorService>> {
        public void afterActivation(ServiceReference<JMXConnectorService> activated) throws Exception {
            ((JMXConnectorService)activated.get()).startJMXConnector();
        }

        public void beforePassivation(ServiceReference<JMXConnectorService> passivating) throws Exception {
            ((JMXConnectorService)passivating.get()).stopJMXConnector();
        }
    }
}

