/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.jmx;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;

public class ModelMBeanBuilder {
    List<ModelMBeanAttributeInfo> attributes = new ArrayList<ModelMBeanAttributeInfo>();
    List<ModelMBeanConstructorInfo> constructors = new ArrayList<ModelMBeanConstructorInfo>();
    List<ModelMBeanOperationInfo> operations = new ArrayList<ModelMBeanOperationInfo>();
    List<ModelMBeanNotificationInfo> notifications = new ArrayList<ModelMBeanNotificationInfo>();
    ObjectName objectName;
    String displayName;
    private final String className;

    public ModelMBeanBuilder(ObjectName objectName, String displayName, String className) {
        this.objectName = objectName;
        this.displayName = displayName;
        this.className = className;
    }

    public ModelMBeanBuilder attribute(String name, String displayName, String type, String description, String getMethod, String setMethod) {
        DescriptorSupport stateDesc = new DescriptorSupport();
        stateDesc.setField("name", name);
        stateDesc.setField("descriptorType", "attribute");
        stateDesc.setField("displayName", displayName);
        if (getMethod != null) {
            stateDesc.setField("getMethod", getMethod);
            this.operation(getMethod, description, type, 0, new MBeanParameterInfo[0]);
        }
        if (setMethod != null) {
            stateDesc.setField("setMethod", setMethod);
            this.operation(setMethod, description, type, 0, new MBeanParameterInfo("Value", type, description));
        }
        ModelMBeanAttributeInfo attributeInfo = new ModelMBeanAttributeInfo(name, type, description, getMethod != null, setMethod != null, getMethod != null && getMethod.startsWith("is"), stateDesc);
        this.attributes.add(attributeInfo);
        return this;
    }

    public ModelMBeanAttributeInfo getAttribute(String name) {
        for (ModelMBeanAttributeInfo attribute : this.attributes) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    public ModelMBeanBuilder operation(String name, String description, String returnType, int impact, MBeanParameterInfo ... parameters) {
        DescriptorSupport stateDesc = new DescriptorSupport();
        stateDesc.setField("name", name);
        stateDesc.setField("descriptorType", "operation");
        stateDesc.setField("class", this.className);
        stateDesc.setField("role", "operation");
        stateDesc.setField("targetType", "objectReference");
        ModelMBeanOperationInfo operationInfo = new ModelMBeanOperationInfo(name, description, parameters, returnType, impact, stateDesc);
        this.operations.add(operationInfo);
        return this;
    }

    public RequiredModelMBean newModelMBean() throws MBeanException {
        DescriptorSupport mmbDesc = new DescriptorSupport();
        mmbDesc.setField("name", this.objectName.toString());
        mmbDesc.setField("descriptorType", "mbean");
        mmbDesc.setField("displayName", this.displayName);
        ModelMBeanInfoSupport modelMBeanInfo = new ModelMBeanInfoSupport(this.className, this.displayName, this.attributes.toArray(new ModelMBeanAttributeInfo[this.attributes.size()]), this.constructors.toArray(new ModelMBeanConstructorInfo[this.constructors.size()]), this.operations.toArray(new ModelMBeanOperationInfo[this.operations.size()]), this.notifications.toArray(new ModelMBeanNotificationInfo[this.notifications.size()]));
        modelMBeanInfo.setMBeanDescriptor(mmbDesc);
        return new RequiredModelMBean(modelMBeanInfo);
    }
}

