/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.quartz.TriggerKey;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;

public class MSSQLDelegate
extends StdJDBCDelegate {
    @Override
    protected Object getObjectFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        InputStream binaryInput = rs.getBinaryStream(colName);
        if (binaryInput == null || binaryInput.available() == 0) {
            return null;
        }
        Object obj = null;
        try (ObjectInputStream in = new ObjectInputStream(binaryInput);){
            obj = in.readObject();
        }
        return obj;
    }

    @Override
    protected Object getJobDataFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        if (this.canUseProperties()) {
            return rs.getBinaryStream(colName);
        }
        return this.getObjectFromBlob(rs, colName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TriggerKey> selectTriggerToAcquire(Connection conn, long noLaterThan, long noEarlierThan, int maxCount) throws SQLException {
        LinkedList<TriggerKey> linkedList;
        if (maxCount < 1) {
            maxCount = 1;
        }
        String selectTriggerToAcquire = "SELECT TOP " + maxCount + " " + "SELECT TRIGGER_NAME, TRIGGER_GROUP, NEXT_FIRE_TIME, PRIORITY FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_STATE = ? AND NEXT_FIRE_TIME <= ? AND (MISFIRE_INSTR = -1 OR (MISFIRE_INSTR <> -1 AND NEXT_FIRE_TIME >= ?)) ORDER BY NEXT_FIRE_TIME ASC, PRIORITY DESC".substring(6);
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<TriggerKey> nextTriggers = new LinkedList<TriggerKey>();
        try {
            ps = conn.prepareStatement(this.rtp(selectTriggerToAcquire));
            ps.setMaxRows(maxCount);
            ps.setFetchSize(maxCount);
            ps.setString(1, "WAITING");
            ps.setBigDecimal(2, new BigDecimal(String.valueOf(noLaterThan)));
            ps.setBigDecimal(3, new BigDecimal(String.valueOf(noEarlierThan)));
            rs = ps.executeQuery();
            while (rs.next() && nextTriggers.size() < maxCount) {
                nextTriggers.add(TriggerKey.triggerKey(rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP")));
            }
            linkedList = nextTriggers;
        }
        catch (Throwable throwable) {
            MSSQLDelegate.closeResultSet(rs);
            MSSQLDelegate.closeStatement(ps);
            throw throwable;
        }
        MSSQLDelegate.closeResultSet(rs);
        MSSQLDelegate.closeStatement(ps);
        return linkedList;
    }
}

