/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.maven.rust;

import io.questdb.maven.rust.CargoMojoBase;
import io.questdb.maven.rust.Crate;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="build", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true)
public class CargoBuildMojo
extends CargoMojoBase {
    @Parameter(property="copyTo")
    private String copyTo;
    @Parameter(property="copyWithPlatformDir")
    private boolean copyWithPlatformDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Crate crate = new Crate(this.getCrateRoot(), this.getTargetRootDir(), this.extractCrateParams());
        crate.setLog(this.getLog());
        crate.build();
        crate.copyArtifacts();
    }

    private Crate.Params extractCrateParams() throws MojoExecutionException {
        Crate.Params params = this.getCommonCrateParams();
        if (this.copyTo != null) {
            Path copyToDir = Paths.get(this.copyTo, new String[0]);
            if (!copyToDir.isAbsolute()) {
                copyToDir = this.project.getBasedir().toPath().resolve(copyToDir);
            }
            params.copyToDir = copyToDir;
        }
        params.copyWithPlatformDir = this.copyWithPlatformDir;
        return params;
    }
}

