/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.maven.rust;

import io.questdb.maven.rust.Shlex;
import java.io.File;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;

public final class CargoInstalledChecker {
    public static final CargoInstalledChecker INSTANCE = new CargoInstalledChecker();
    private final HashMap<String, InstalledState> cache = new HashMap();

    private CargoInstalledChecker() {
    }

    public synchronized void check(String cargoPath) throws MojoExecutionException {
        InstalledState cached = this.cache.getOrDefault(cargoPath, InstalledState.UNKNOWN);
        if (cached == InstalledState.UNKNOWN) {
            try {
                ProcessBuilder pb = new ProcessBuilder(cargoPath, "--version");
                Process p = pb.start();
                int exitCode = p.waitFor();
                cached = exitCode == 0 ? InstalledState.INSTALLED : InstalledState.BROKEN;
                this.cache.put(cargoPath, cached);
            }
            catch (Exception e) {
                cached = InstalledState.NOT_INSTALLED;
                this.cache.put(cargoPath, cached);
            }
        }
        if (cached == InstalledState.INSTALLED) {
            return;
        }
        StringBuilder error = new StringBuilder();
        if (cached == InstalledState.BROKEN) {
            if (cargoPath.equals("cargo")) {
                error.append("Rust's `cargo` ");
            } else {
                error.append("Rust's `cargo` at ").append(Shlex.quote(cargoPath));
            }
            error.append(" is a broken install: Running `cargo --version` returned non-zero exit code");
        } else if (cargoPath.equals("cargo")) {
            error.append("Rust's `cargo` not found in PATH=").append(Shlex.quote(String.join((CharSequence)File.pathSeparator, System.getenv("PATH"))));
        } else {
            error.append("Rust's `cargo` not found at ").append(Shlex.quote(cargoPath));
        }
        error.append(".\n\nSee https://www.rust-lang.org/tools/install");
        throw new MojoExecutionException(error.toString());
    }

    private static enum InstalledState {
        UNKNOWN,
        NOT_INSTALLED,
        INSTALLED,
        BROKEN;

    }
}

