/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.maven.rust;

import io.questdb.maven.rust.Crate;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class CargoMojoBase
extends AbstractMojo {
    @Parameter(property="project", readonly=true)
    protected MavenProject project;
    @Parameter(property="environmentVariables")
    private HashMap<String, String> environmentVariables;
    @Parameter(property="cargoPath", defaultValue="cargo")
    private String cargoPath;
    @Parameter(property="path", required=true)
    private String path;
    @Parameter(property="release", defaultValue="false")
    private boolean release;
    @Parameter(property="features")
    private String[] features;
    @Parameter(property="all-features", defaultValue="false")
    private boolean allFeatures;
    @Parameter(property="no-default-features", defaultValue="false")
    private boolean noDefaultFeatures;
    @Parameter(property="verbosity")
    private String verbosity;
    @Parameter(property="extra-args")
    private String[] extraArgs;

    protected String getVerbosity() throws MojoExecutionException {
        if (this.verbosity == null) {
            return null;
        }
        switch (this.verbosity) {
            case "": {
                return null;
            }
            case "-q": 
            case "-v": 
            case "-vv": {
                return this.verbosity;
            }
        }
        throw new MojoExecutionException("Invalid verbosity: " + this.verbosity);
    }

    protected Path getCrateRoot() {
        Path crateRoot = Paths.get(this.path, new String[0]);
        if (!crateRoot.isAbsolute()) {
            crateRoot = this.project.getBasedir().toPath().resolve(this.path);
        }
        return crateRoot;
    }

    protected Path getTargetRootDir() {
        return Paths.get(this.project.getBuild().getDirectory(), "rust-maven-plugin");
    }

    protected Crate.Params getCommonCrateParams() throws MojoExecutionException {
        Crate.Params params = new Crate.Params();
        params.verbosity = this.getVerbosity();
        params.environmentVariables = this.environmentVariables;
        params.cargoPath = this.cargoPath;
        params.release = this.release;
        params.features = this.features;
        params.allFeatures = this.allFeatures;
        params.noDefaultFeatures = this.noDefaultFeatures;
        params.extraArgs = this.extraArgs;
        return params;
    }
}

