/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.maven.rust;

import java.util.List;
import java.util.regex.Pattern;

public interface Shlex {
    public static String quote(String s) {
        if (s.isEmpty()) {
            return "''";
        }
        Pattern unsafe = Pattern.compile("[^\\w@%+=:,./-]");
        if (unsafe.matcher(s).find()) {
            return "'" + s.replace("'", "'\"'\"'") + "'";
        }
        return s;
    }

    public static String quote(List<String> args) {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(Shlex.quote(arg));
        }
        return sb.toString();
    }
}

