/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.api.passes;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.api.passes.NamedPass;
import org.jetbrains.java.decompiler.api.passes.Pass;
import org.jetbrains.java.decompiler.api.passes.PassContext;
import org.jetbrains.java.decompiler.util.Pair;

public final class LoopingPassBuilder {
    private final List<Pair<Pass, Boolean>> passes = new ArrayList<Pair<Pass, Boolean>>();
    private final String name;

    public LoopingPassBuilder(String name) {
        this.name = name;
    }

    public void addFallthroughPass(String name, Pass pass) {
        this.passes.add(Pair.of(new NamedPass(name, pass), false));
    }

    public void addLoopingPass(String name, Pass pass) {
        this.passes.add(Pair.of(new NamedPass(name, pass), true));
    }

    public Pass build() {
        return new CompiledPass(this.name, this.passes);
    }

    private static final class CompiledPass
    implements Pass {
        private final List<Pair<Pass, Boolean>> passes;

        public CompiledPass(String name, List<Pair<Pass, Boolean>> passes) {
            this.passes = new ArrayList<Pair<Pass, Boolean>>(passes);
        }

        @Override
        public boolean run(PassContext ctx) {
            boolean loop;
            block0: do {
                loop = false;
                for (Pair<Pass, Boolean> pass : this.passes) {
                    if (!((Pass)pass.a).run(ctx) || !((Boolean)pass.b).booleanValue()) continue;
                    loop = true;
                    continue block0;
                }
            } while (loop);
            return true;
        }
    }
}

