/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code;

import java.util.Iterator;
import org.jetbrains.java.decompiler.code.ExceptionTable;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.util.TextUtil;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public abstract class InstructionSequence
implements Iterable<Instruction> {
    protected final VBStyleCollection<Instruction, Integer> collinstr;
    protected int pointer = 0;
    protected ExceptionTable exceptionTable = ExceptionTable.EMPTY;

    protected InstructionSequence() {
        this(new VBStyleCollection<Instruction, Integer>());
    }

    protected InstructionSequence(VBStyleCollection<Instruction, Integer> collinstr) {
        this.collinstr = collinstr;
    }

    public InstructionSequence clone() {
        return null;
    }

    public void clear() {
        this.collinstr.clear();
        this.pointer = 0;
        this.exceptionTable = ExceptionTable.EMPTY;
    }

    public void addInstruction(Instruction inst, int offset) {
        this.collinstr.addWithKey(inst, offset);
    }

    public void addInstruction(int index, Instruction inst, int offset) {
        this.collinstr.addWithKeyAndIndex(index, inst, offset);
    }

    public void addSequence(InstructionSequence seq) {
        for (int i = 0; i < seq.length(); ++i) {
            this.addInstruction(seq.getInstr(i), -1);
        }
    }

    public void removeInstruction(int index) {
        this.collinstr.remove(index);
    }

    public void removeInstruction(Instruction inst) {
        this.collinstr.removeIf(i -> i == inst);
    }

    public void removeLast() {
        if (!this.collinstr.isEmpty()) {
            this.collinstr.remove(this.collinstr.size() - 1);
        }
    }

    public Instruction getInstr(int index) {
        return (Instruction)this.collinstr.get(index);
    }

    public Instruction getLastInstr() {
        return this.collinstr.getLast();
    }

    public int getOffset(int index) {
        return this.collinstr.getKey(index);
    }

    public int getPointerByAbsOffset(int offset) {
        if (this.collinstr.containsKey(offset)) {
            return this.collinstr.getIndexByKey(offset);
        }
        return -1;
    }

    public int getPointerByRelOffset(int offset) {
        int absoffset = this.collinstr.getKey(this.pointer) + offset;
        if (this.collinstr.containsKey(absoffset)) {
            return this.collinstr.getIndexByKey(absoffset);
        }
        return -1;
    }

    public int length() {
        return this.collinstr.size();
    }

    public boolean isEmpty() {
        return this.collinstr.isEmpty();
    }

    public void addToPointer(int diff) {
        this.pointer += diff;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        String new_line_separator = DecompilerContext.getNewLineSeparator();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.collinstr.size(); ++i) {
            buf.append(TextUtil.getIndentString(indent));
            buf.append(this.collinstr.getKey(i));
            buf.append(": ");
            buf.append(((Instruction)this.collinstr.get(i)).toString());
            buf.append(new_line_separator);
        }
        return buf.toString();
    }

    public int getPointer() {
        return this.pointer;
    }

    public void setPointer(int pointer) {
        this.pointer = pointer;
    }

    public ExceptionTable getExceptionTable() {
        return this.exceptionTable;
    }

    @Override
    public Iterator<Instruction> iterator() {
        return this.collinstr.iterator();
    }
}

