/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.rels;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.main.collectors.CounterContainer;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.flow.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;

public class MethodWrapper {
    public final RootStatement root;
    public final VarProcessor varproc;
    public final StructMethod methodStruct;
    public final StructClass classStruct;
    public final CounterContainer counter;
    public final Set<String> setOuterVarNames = new HashSet<String>();
    public DirectGraph graph;
    public List<VarVersionPair> synthParameters;
    public Throwable decompileError;
    public Set<String> commentLines = null;
    public boolean addErrorComment = false;

    public MethodWrapper(RootStatement root, VarProcessor varproc, StructMethod methodStruct, StructClass classStruct, CounterContainer counter) {
        this.root = root;
        this.varproc = varproc;
        this.methodStruct = methodStruct;
        this.classStruct = classStruct;
        this.counter = counter;
        if (root != null && root.commentLines != null) {
            for (String s : root.commentLines) {
                this.addComment(s);
            }
            this.addErrorComment |= root.addErrorComment;
        }
    }

    public DirectGraph getOrBuildGraph() {
        if (this.graph == null && this.root != null) {
            this.graph = new FlattenStatementsHelper().buildDirectGraph(this.root);
        }
        return this.graph;
    }

    public void addComment(String comment) {
        if (this.commentLines == null) {
            this.commentLines = new LinkedHashSet<String>();
        }
        this.commentLines.add(comment);
    }

    public String toString() {
        return this.methodStruct.getName();
    }
}

