/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.DecHelper;
import org.jetbrains.java.decompiler.modules.decompiler.MergeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;

public final class ExitHelper {
    public static boolean condenseExits(RootStatement root) {
        int changed = ExitHelper.integrateExits(root);
        if (changed > 0) {
            ExitHelper.cleanUpUnreachableBlocks(root);
            SequenceHelper.condenseSequences(root);
        }
        return changed > 0;
    }

    private static void cleanUpUnreachableBlocks(Statement stat) {
        boolean found;
        block0: do {
            found = false;
            for (int i = 0; i < stat.getStats().size(); ++i) {
                Statement st = (Statement)stat.getStats().get(i);
                ExitHelper.cleanUpUnreachableBlocks(st);
                if (!(st instanceof SequenceStatement) || st.getStats().size() <= 1) continue;
                Statement last = st.getStats().getLast();
                Statement secondlast = (Statement)st.getStats().get(st.getStats().size() - 2);
                if (last.getExprents() != null && last.getExprents().isEmpty() || secondlast.hasBasicSuccEdge()) continue;
                Set<Statement> set = last.getNeighboursSet(0x40000000, Statement.EdgeDirection.BACKWARD);
                set.remove(secondlast);
                if (!set.isEmpty()) continue;
                last.setExprents(new ArrayList<Exprent>());
                found = true;
                continue block0;
            }
        } while (found);
    }

    private static int integrateExits(Statement stat) {
        StatEdge destedge;
        Statement parent;
        BasicBlockStatement bstat;
        Statement dest;
        int ret = 0;
        if (stat.getExprents() == null) {
            StatEdge ifedge;
            IfStatement ifst;
            int changed;
            block0: do {
                changed = 0;
                for (Statement st : stat.getStats()) {
                    changed = ExitHelper.integrateExits(st);
                    if (changed <= 0) continue;
                    ret = 1;
                    continue block0;
                }
            } while (changed != 0);
            if (stat instanceof IfStatement && (ifst = (IfStatement)stat).getIfstat() == null && (dest = ExitHelper.isExitEdge(ifedge = ifst.getIfEdge())) != null) {
                bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
                bstat.setExprents(DecHelper.copyExprentList(dest.getExprents()));
                ifst.getFirst().removeSuccessor(ifedge);
                StatEdge newedge = new StatEdge(1, ifst.getFirst(), bstat);
                ifst.getFirst().addSuccessor(newedge);
                ifst.setIfEdge(newedge);
                ifst.setIfstat(bstat);
                ifst.getStats().addWithKey(bstat, bstat.id);
                bstat.setParent(ifst);
                StatEdge oldexitedge = dest.getFirstSuccessor();
                StatEdge newexitedge = new StatEdge(4, (Statement)bstat, oldexitedge.getDestination());
                bstat.addSuccessor(newexitedge);
                oldexitedge.closure.addLabeledEdge(newexitedge);
                ret = 1;
            }
        }
        if (stat.getAllSuccessorEdges().size() == 1 && stat.getAllSuccessorEdges().get(0).getType() == 4 && stat.getLabelEdges().isEmpty() && (stat != (parent = stat.getParent()).getFirst() || !(parent instanceof IfStatement) && !(parent instanceof SwitchStatement)) && (dest = ExitHelper.isExitEdge(destedge = stat.getAllSuccessorEdges().get(0))) != null) {
            stat.removeSuccessor(destedge);
            bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
            bstat.setExprents(DecHelper.copyExprentList(dest.getExprents()));
            StatEdge oldexitedge = dest.getAllSuccessorEdges().get(0);
            StatEdge newexitedge = new StatEdge(4, (Statement)bstat, oldexitedge.getDestination());
            bstat.addSuccessor(newexitedge);
            oldexitedge.closure.addLabeledEdge(newexitedge);
            SequenceStatement block = new SequenceStatement(Arrays.asList(stat, bstat));
            block.setAllParent();
            parent.replaceStatement(stat, block);
            for (StatEdge prededge : block.getPredecessorEdges(8)) {
                block.removePredecessor(prededge);
                prededge.getSource().changeEdgeNode(Statement.EdgeDirection.FORWARD, prededge, stat);
                stat.addPredecessor(prededge);
                stat.addLabeledEdge(prededge);
            }
            stat.addSuccessor(new StatEdge(1, stat, bstat));
            for (StatEdge edge : dest.getAllPredecessorEdges()) {
                if (edge.explicit || !stat.containsStatementStrict(edge.getSource()) || !MergeHelper.isDirectPath(edge.getSource().getParent(), bstat)) continue;
                dest.removePredecessor(edge);
                edge.getSource().changeEdgeNode(Statement.EdgeDirection.FORWARD, edge, bstat);
                bstat.addPredecessor(edge);
                if (stat.containsStatementStrict(edge.closure)) continue;
                stat.addLabeledEdge(edge);
            }
            ret = 2;
        }
        return ret;
    }

    private static Statement isExitEdge(StatEdge edge) {
        List<Exprent> data;
        Statement dest = edge.getDestination();
        if (edge.getType() == 4 && dest instanceof BasicBlockStatement && edge.explicit && (edge.labeled || ExitHelper.isOnlyEdge(edge)) && edge.canInline && (data = dest.getExprents()) != null && data.size() == 1 && data.get(0) instanceof ExitExprent) {
            return dest;
        }
        return null;
    }

    private static boolean isOnlyEdge(StatEdge edge) {
        Statement stat = edge.getDestination();
        for (StatEdge ed : stat.getAllPredecessorEdges()) {
            if (ed == edge) continue;
            if (ed.getType() == 1) {
                Statement source = ed.getSource();
                if (!(source instanceof BasicBlockStatement) && (!(source instanceof IfStatement) || ((IfStatement)source).iftype != 0) && (!(source instanceof DoStatement) || ((DoStatement)source).getLooptype() == DoStatement.Type.INFINITE)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean removeRedundantReturns(RootStatement root) {
        boolean res = false;
        DummyExitStatement dummyExit = root.getDummyExit();
        for (StatEdge edge : dummyExit.getAllPredecessorEdges()) {
            ExitExprent ex;
            Exprent expr;
            Statement source;
            List<Exprent> lstExpr;
            if (edge.explicit || (lstExpr = (source = edge.getSource()).getExprents()) == null || lstExpr.isEmpty() || !((expr = lstExpr.get(lstExpr.size() - 1)) instanceof ExitExprent) || (ex = (ExitExprent)expr).getExitType() != ExitExprent.Type.RETURN || ex.getValue() != null) continue;
            dummyExit.addBytecodeOffsets(ex.bytecode);
            lstExpr.remove(lstExpr.size() - 1);
            res = true;
        }
        return res;
    }

    public static boolean adjustReturnType(RootStatement root, MethodDescriptor desc) {
        boolean res = false;
        for (StatEdge retEdge : root.getDummyExit().getAllPredecessorEdges()) {
            Exprent expr;
            Statement ret = retEdge.getSource();
            List<Exprent> exprents = ret.getExprents();
            if (exprents == null || exprents.isEmpty() || !((expr = exprents.get(exprents.size() - 1)) instanceof ExitExprent)) continue;
            ExitExprent ex = (ExitExprent)expr;
            List<Exprent> exitExprents = ex.getAllExprents(true);
            for (Exprent exprent : exitExprents) {
                if (!(exprent instanceof ConstExprent)) continue;
                ((ConstExprent)exprent).adjustConstType(desc.ret);
                res = true;
            }
        }
        return res;
    }
}

