/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationParameterAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;

public final class IdeaNotNullHelper {
    public static boolean removeHardcodedChecks(RootStatement root, StructMethod mt) {
        boolean checks_removed = false;
        while (IdeaNotNullHelper.findAndRemoveParameterCheck(root, mt)) {
            checks_removed = true;
            ValidationHelper.validateStatement(root);
        }
        while (IdeaNotNullHelper.findAndRemoveReturnCheck(root, mt)) {
            checks_removed = true;
            ValidationHelper.validateStatement(root);
        }
        return checks_removed;
    }

    private static boolean findAndRemoveParameterCheck(Statement stat, StructMethod mt) {
        Statement st = stat.getFirst();
        while (st instanceof SequenceStatement) {
            st = st.getFirst();
        }
        if (st instanceof IfStatement) {
            IfStatement ifstat = (IfStatement)st;
            Statement ifbranch = ifstat.getIfstat();
            Exprent if_condition = ifstat.getHeadexprent().getCondition();
            boolean is_notnull_check = false;
            if (ifbranch != null && if_condition instanceof FunctionExprent && ((FunctionExprent)if_condition).getFuncType() == FunctionExprent.FunctionType.EQ && ifbranch instanceof BasicBlockStatement && ifbranch.getExprents().size() == 1 && ifbranch.getExprents().get(0) instanceof InvocationExprent) {
                FunctionExprent func = (FunctionExprent)if_condition;
                Exprent first_param = func.getLstOperands().get(0);
                Exprent second_param = func.getLstOperands().get(1);
                if (second_param instanceof ConstExprent && second_param.getExprType().type == 13 && first_param instanceof VarExprent && ((InvocationExprent)ifbranch.getExprents().get(0)).getName().equals("$$$reportNull$$$0")) {
                    VarExprent var = (VarExprent)first_param;
                    boolean thisvar = !mt.hasModifier(8);
                    MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
                    StructAnnotationParameterAttribute param_annotations = mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS);
                    if (param_annotations != null) {
                        List<List<AnnotationExprent>> param_annotations_lists = param_annotations.getParamAnnotations();
                        int method_param_number = md.params.length;
                        int index = thisvar ? 1 : 0;
                        block1: for (int i = 0; i < method_param_number; ++i) {
                            if (index == var.getIndex()) {
                                if (param_annotations_lists.size() < method_param_number - i) break;
                                int shift = method_param_number - param_annotations_lists.size();
                                List<AnnotationExprent> annotations = param_annotations_lists.get(i - shift);
                                for (AnnotationExprent ann : annotations) {
                                    if (!ann.getClassName().equals("org/jetbrains/annotations/NotNull")) continue;
                                    is_notnull_check = true;
                                    break block1;
                                }
                                break;
                            }
                            index += md.params[i].stackSize;
                        }
                    }
                }
            }
            if (!is_notnull_check) {
                return false;
            }
            IdeaNotNullHelper.removeParameterCheck(stat);
            return true;
        }
        return false;
    }

    private static void removeParameterCheck(Statement stat) {
        Statement st = stat.getFirst();
        while (st instanceof SequenceStatement) {
            st = st.getFirst();
        }
        IfStatement ifstat = (IfStatement)st;
        if (ifstat.getElsestat() == null) {
            StatEdge ifedge = ifstat.getIfEdge();
            Statement ifbranch = ifstat.getIfstat();
            ifstat.getFirst().removeSuccessor(ifedge);
            ifstat.getStats().removeWithKey(ifbranch.id);
            if (ifbranch.hasAnySuccessor()) {
                ifbranch.removeSuccessor(ifbranch.getFirstSuccessor());
            }
            BasicBlockStatement block = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
            block.setExprents(new ArrayList<Exprent>());
            ifstat.getParent().replaceStatement(ifstat, block);
            ifstat.getParent().setAllParent();
            SequenceHelper.condenseSequences(stat.getTopParent());
        }
    }

    private static boolean findAndRemoveReturnCheck(Statement stat, StructMethod mt) {
        boolean is_notnull_check = false;
        StructAnnotationAttribute attr = mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_RUNTIME_INVISIBLE_ANNOTATIONS);
        if (attr != null) {
            List<AnnotationExprent> annotations = attr.getAnnotations();
            for (AnnotationExprent ann : annotations) {
                if (!ann.getClassName().equals("org/jetbrains/annotations/NotNull")) continue;
                is_notnull_check = true;
                break;
            }
        }
        return is_notnull_check && IdeaNotNullHelper.removeReturnCheck(stat, mt);
    }

    private static boolean removeReturnCheck(Statement stat, StructMethod mt) {
        Statement ifbranch;
        Exprent exprent_value;
        ExitExprent exit_exprent;
        Exprent exprent;
        Statement parent = stat.getParent();
        if (parent instanceof IfStatement && stat instanceof BasicBlockStatement && stat.getExprents().size() == 1) {
            exprent = stat.getExprents().get(0);
            if (exprent instanceof ExitExprent && (exit_exprent = (ExitExprent)exprent).getExitType() == ExitExprent.Type.RETURN) {
                exprent_value = exit_exprent.getValue();
                IfStatement ifparent = (IfStatement)parent;
                Exprent if_condition = ifparent.getHeadexprent().getCondition();
                if (ifparent.getElsestat() == stat && if_condition instanceof FunctionExprent && ((FunctionExprent)if_condition).getFuncType() == FunctionExprent.FunctionType.EQ) {
                    FunctionExprent func = (FunctionExprent)if_condition;
                    Exprent first_param = func.getLstOperands().get(0);
                    Exprent second_param = func.getLstOperands().get(1);
                    StatEdge ifedge = ifparent.getIfEdge();
                    StatEdge elseedge = ifparent.getElseEdge();
                    ifbranch = ifparent.getIfstat();
                    Statement elsebranch = ifparent.getElsestat();
                    if (second_param instanceof ConstExprent && second_param.getExprType().type == 13 && first_param.equals(exprent_value) && ifbranch instanceof BasicBlockStatement && ifbranch.getExprents().size() == 1 && ifbranch.getExprents().get(0) instanceof ExitExprent) {
                        ifparent.getFirst().removeSuccessor(ifedge);
                        ifparent.getFirst().removeSuccessor(elseedge);
                        ifparent.getStats().removeWithKey(ifbranch.id);
                        ifparent.getStats().removeWithKey(elsebranch.id);
                        if (ifbranch.hasAnySuccessor()) {
                            ifbranch.removeSuccessor(ifbranch.getFirstSuccessor());
                        }
                        if (!ifparent.getFirst().getExprents().isEmpty()) {
                            elsebranch.getExprents().addAll(0, ifparent.getFirst().getExprents());
                        }
                        ifparent.getParent().replaceStatement(ifparent, elsebranch);
                        ifparent.getParent().setAllParent();
                        return true;
                    }
                }
            }
        } else if (parent != null && parent instanceof SequenceStatement && stat instanceof BasicBlockStatement && stat.getExprents().size() == 1 && (exprent = stat.getExprents().get(0)) instanceof ExitExprent && (exit_exprent = (ExitExprent)exprent).getExitType() == ExitExprent.Type.RETURN) {
            exprent_value = exit_exprent.getValue();
            SequenceStatement sequence = (SequenceStatement)parent;
            int sequence_stats_number = sequence.getStats().size();
            if (sequence_stats_number > 1 && sequence.getStats().getLast() == stat && sequence.getStats().get(sequence_stats_number - 2) instanceof IfStatement) {
                IfStatement ifstat = (IfStatement)sequence.getStats().get(sequence_stats_number - 2);
                Exprent if_condition = ifstat.getHeadexprent().getCondition();
                if (ifstat.iftype == 0 && if_condition instanceof FunctionExprent && ((FunctionExprent)if_condition).getFuncType() == FunctionExprent.FunctionType.EQ) {
                    FunctionExprent func = (FunctionExprent)if_condition;
                    Exprent first_param = func.getLstOperands().get(0);
                    Exprent second_param = func.getLstOperands().get(1);
                    ifbranch = ifstat.getIfstat();
                    if (second_param instanceof ConstExprent && second_param.getExprType().type == 13 && first_param.equals(exprent_value) && ifbranch instanceof BasicBlockStatement && ifbranch.getExprents().size() == 1 && ifbranch.getExprents().get(0) instanceof InvocationExprent && ((InvocationExprent)ifbranch.getExprents().get(0)).getName().equals("$$$reportNull$$$0")) {
                        ifstat.getFirstSuccessor().remove();
                        if (!ifstat.getFirst().getExprents().isEmpty()) {
                            stat.getExprents().addAll(0, ifstat.getFirst().getExprents());
                        }
                        for (StatEdge edge : ifstat.getAllPredecessorEdges()) {
                            edge.changeDestination(stat);
                        }
                        ifbranch.getFirstSuccessor().remove();
                        sequence.getStats().removeWithKey(ifstat.id);
                        sequence.setFirst((Statement)sequence.getStats().get(0));
                        return true;
                    }
                }
            }
        }
        for (Statement st : stat.getStats()) {
            if (!IdeaNotNullHelper.removeReturnCheck(st, mt)) continue;
            return true;
        }
        return false;
    }
}

