/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.LabelHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.TryWithResourcesProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ArrayExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.IfExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.flow.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.SFormsConstructor;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SynchronizedStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public final class MergeHelper {
    public static void enhanceLoops(Statement root) {
        while (MergeHelper.enhanceLoopsRec(root)) {
        }
        SequenceHelper.condenseSequences(root);
    }

    private static boolean enhanceLoopsRec(Statement stat) {
        boolean res = false;
        for (Statement st : new ArrayList(stat.getStats())) {
            if (st.getExprents() != null) continue;
            res |= MergeHelper.enhanceLoopsRec(st);
        }
        if (stat instanceof DoStatement) {
            res |= MergeHelper.enhanceLoop((DoStatement)stat);
        }
        return res;
    }

    private static boolean enhanceLoop(DoStatement stat) {
        DoStatement.Type oldloop = stat.getLooptype();
        switch (oldloop) {
            case INFINITE: {
                if (!MergeHelper.matchWhile(stat) || MergeHelper.matchForEach(stat)) break;
                MergeHelper.matchFor(stat);
                break;
            }
            case WHILE: {
                if (MergeHelper.matchForEach(stat)) break;
                MergeHelper.matchFor(stat);
            }
        }
        return stat.getLooptype() != oldloop;
    }

    private static void matchDoWhile(DoStatement stat) {
        Statement last = stat.getFirst();
        while (last instanceof SequenceStatement) {
            last = last.getStats().getLast();
        }
        if (last instanceof IfStatement) {
            IfStatement lastif = (IfStatement)last;
            if (lastif.iftype == 0 && lastif.getIfstat() == null) {
                StatEdge ifedge = lastif.getIfEdge();
                StatEdge elseedge = lastif.getFirstSuccessor();
                if (ifedge.getType() == 4 && elseedge.getType() == 8 && elseedge.closure == stat && MergeHelper.isDirectPath(stat, ifedge.getDestination()) || ifedge.getType() == 8 && elseedge.getType() == 4 && ifedge.closure == stat && MergeHelper.isDirectPath(stat, elseedge.getDestination()) || ifedge.getType() == 8 && elseedge.getType() == 8 && elseedge.closure == stat && MergeHelper.isLastInLoop(stat) && MergeHelper.isDirectPath(stat, ifedge.getDestination())) {
                    Set<Statement> set = stat.getNeighboursSet(8, Statement.EdgeDirection.BACKWARD);
                    set.remove(last);
                    if (!set.isEmpty()) {
                        return;
                    }
                    stat.setLooptype(DoStatement.Type.DO_WHILE);
                    IfExprent ifexpr = (IfExprent)lastif.getHeadexprent().copy();
                    if (ifedge.getType() == 4) {
                        ifexpr.negateIf();
                    }
                    if (stat.getConditionExprent() != null) {
                        ifexpr.getCondition().addBytecodeOffsets(stat.getConditionExprent().bytecode);
                    }
                    ifexpr.getCondition().addBytecodeOffsets(lastif.getHeadexprent().bytecode);
                    stat.setConditionExprent(ifexpr.getCondition());
                    lastif.removeSuccessor(elseedge);
                    if (lastif.getFirst().getExprents().isEmpty()) {
                        lastif.getFirst().removeSuccessor(ifedge);
                        MergeHelper.removeLastEmptyStatement(stat, lastif);
                    } else if (stat.getStats().size() == 1 && ifedge.getType() == 8) {
                        lastif.replaceWith(lastif.getFirst());
                    } else {
                        lastif.setExprents(lastif.getFirst().getExprents());
                        StatEdge newedge = new StatEdge(8, (Statement)lastif, stat);
                        lastif.addSuccessor(newedge);
                        stat.addLabeledEdge(newedge);
                    }
                    if (stat.getAllSuccessorEdges().isEmpty()) {
                        StatEdge edge = elseedge.getType() == 8 ? ifedge : elseedge;
                        edge.setSource(stat);
                        if (edge.closure == stat) {
                            edge.closure = stat.getParent();
                        }
                        stat.addSuccessor(edge);
                    }
                }
            }
        }
    }

    private static boolean isLastInLoop(Statement stat) {
        while (stat.getParent() instanceof SequenceStatement) {
            if (stat.getParent().getStats().indexOf(stat) != stat.getParent().getStats().size() - 1) {
                return false;
            }
            if ((stat = stat.getParent()) != null) continue;
            return false;
        }
        return stat.getParent() instanceof DoStatement;
    }

    private static boolean matchWhile(DoStatement stat) {
        IfStatement firstif;
        Statement first = stat.getFirst();
        while (first instanceof SequenceStatement) {
            first = first.getFirst();
        }
        if (first instanceof IfStatement && (firstif = (IfStatement)first).getFirst().getExprents().isEmpty() && firstif.iftype == 0) {
            StatEdge ifedge;
            if (firstif.getIfstat() == null && (MergeHelper.isDirectPath(stat, (ifedge = firstif.getIfEdge()).getDestination()) || MergeHelper.addContinueOrBreak(stat, ifedge))) {
                stat.setLooptype(DoStatement.Type.WHILE);
                IfExprent ifexpr = (IfExprent)firstif.getHeadexprent().copy();
                ifexpr.negateIf();
                if (stat.getConditionExprent() != null) {
                    ifexpr.getCondition().addBytecodeOffsets(stat.getConditionExprent().bytecode);
                }
                ifexpr.getCondition().addBytecodeOffsets(firstif.getHeadexprent().bytecode);
                stat.setConditionExprent(ifexpr.getCondition());
                firstif.getFirst().removeSuccessor(ifedge);
                firstif.removeSuccessor(firstif.getAllSuccessorEdges().get(0));
                if (stat.getAllSuccessorEdges().isEmpty()) {
                    ifedge.setSource(stat);
                    if (ifedge.closure == stat) {
                        ifedge.closure = stat.getParent();
                    }
                    stat.addSuccessor(ifedge);
                }
                if (firstif == stat.getFirst()) {
                    BasicBlockStatement bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
                    bstat.setExprents(new ArrayList<Exprent>());
                    stat.replaceStatement(firstif, bstat);
                } else {
                    Statement sequence = firstif.getParent();
                    sequence.getStats().removeWithKey(firstif.id);
                    if (!sequence.getStats().isEmpty()) {
                        sequence.setFirst((Statement)sequence.getStats().get(0));
                    } else {
                        SequenceHelper.destroyAndFlattenStatement(sequence);
                    }
                }
                return true;
            }
            StatEdge elseEdge = firstif.getFirstSuccessor();
            if (MergeHelper.isDirectPath(stat, elseEdge.getDestination())) {
                if (MergeHelper.isIif(firstif.getHeadexprent().getCondition())) {
                    return false;
                }
                stat.setLooptype(DoStatement.Type.WHILE);
                IfExprent ifexpr = (IfExprent)firstif.getHeadexprent().copy();
                if (stat.getConditionExprent() != null) {
                    ifexpr.getCondition().addBytecodeOffsets(stat.getConditionExprent().bytecode);
                }
                ifexpr.getCondition().addBytecodeOffsets(firstif.getHeadexprent().bytecode);
                stat.setConditionExprent(ifexpr.getCondition());
                StatEdge ifedge2 = firstif.getIfEdge();
                firstif.getFirst().removeSuccessor(ifedge2);
                firstif.removeSuccessor(elseEdge);
                if (stat.getAllSuccessorEdges().isEmpty()) {
                    elseEdge.setSource(stat);
                    if (elseEdge.closure == stat) {
                        elseEdge.closure = stat.getParent();
                    }
                    stat.addSuccessor(elseEdge);
                }
                if (firstif.getIfstat() == null) {
                    BasicBlockStatement bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
                    bstat.setExprents(new ArrayList<Exprent>());
                    ifedge2.setSource(bstat);
                    bstat.addSuccessor(ifedge2);
                    stat.replaceStatement(firstif, bstat);
                } else {
                    first.getParent().replaceStatement(first, firstif.getIfstat());
                    for (StatEdge prededge : elseEdge.getDestination().getPredecessorEdges(4)) {
                        if (!stat.containsStatementStrict(prededge.closure)) continue;
                        stat.addLabeledEdge(prededge);
                    }
                    LabelHelper.lowClosures(stat);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isIif(Exprent exprent) {
        if (!(exprent instanceof FunctionExprent)) {
            return false;
        }
        Exprent check = exprent;
        while (check instanceof FunctionExprent && ((FunctionExprent)check).getFuncType() == FunctionExprent.FunctionType.BOOL_NOT) {
            check = ((FunctionExprent)check).getLstOperands().get(0);
        }
        return check instanceof FunctionExprent && ((FunctionExprent)check).getFuncType() == FunctionExprent.FunctionType.TERNARY;
    }

    public static boolean isDirectPath(Statement stat, Statement endstat) {
        Set<Statement> forwardEdges = stat.getNeighboursSet(0x40000000, Statement.EdgeDirection.FORWARD);
        if (forwardEdges.isEmpty()) {
            Statement parent = stat.getParent();
            if (parent == null) {
                return endstat instanceof DummyExitStatement;
            }
            switch (parent.type) {
                case ROOT: {
                    return endstat instanceof DummyExitStatement;
                }
                case DO: {
                    return endstat == parent;
                }
                case SWITCH: {
                    SwitchStatement swst = (SwitchStatement)parent;
                    for (int i = 0; i < swst.getCaseStatements().size() - 1; ++i) {
                        Statement caseStatement = swst.getCaseStatements().get(i);
                        if (caseStatement != stat) continue;
                        Statement nextCase = swst.getCaseStatements().get(i + 1);
                        if (nextCase.getExprents() != null && nextCase.getExprents().isEmpty()) {
                            nextCase = nextCase.getAllSuccessorEdges().get(0).getDestination();
                        }
                        return endstat == nextCase;
                    }
                    break;
                }
            }
            return MergeHelper.isDirectPath(parent, endstat);
        }
        return forwardEdges.contains(endstat);
    }

    private static void matchFor(DoStatement stat) {
        Statement parent;
        boolean haslast;
        Statement preData = null;
        Statement lastData = MergeHelper.getLastDirectData(stat.getFirst());
        if (lastData == null || lastData.getExprents().isEmpty()) {
            return;
        }
        Statement lastProt = SFormsConstructor.getFirstProtectedRange(lastData);
        if (stat.containsStatement(lastProt)) {
            return;
        }
        List<Exprent> lstExpr = lastData.getExprents();
        Exprent lastDoExprent = lstExpr.get(lstExpr.size() - 1);
        boolean issingle = false;
        if (lstExpr.size() == 1 && lastData.getAllPredecessorEdges().size() > 1) {
            issingle = true;
        }
        boolean bl = haslast = issingle || lastDoExprent instanceof AssignmentExprent || lastDoExprent instanceof FunctionExprent;
        if (!haslast) {
            return;
        }
        boolean hasinit = false;
        Statement current = stat;
        while ((parent = current.getParent()) != null && parent instanceof SequenceStatement) {
            Exprent initDoExprent;
            if (current == parent.getFirst()) {
                current = parent;
                continue;
            }
            preData = current.getNeighbours(1, Statement.EdgeDirection.BACKWARD).get(0);
            if (!(preData instanceof BasicBlockStatement) || (preData = MergeHelper.getLastDirectData(preData)) == null || preData.getExprents().isEmpty() || !((initDoExprent = preData.getExprents().get(preData.getExprents().size() - 1)) instanceof AssignmentExprent)) break;
            hasinit = true;
            break;
        }
        if (hasinit || issingle) {
            Statement fst;
            Set<Statement> set = stat.getNeighboursSet(8, Statement.EdgeDirection.BACKWARD);
            set.remove(lastData);
            if (!set.isEmpty()) {
                return;
            }
            Statement firstStat = stat.getFirst();
            while (firstStat instanceof SequenceStatement && firstStat.getStats().size() == 1 && (fst = firstStat.getFirst()) != null) {
                firstStat = fst;
            }
            if (firstStat instanceof BasicBlockStatement && firstStat.getExprents().size() == 1) {
                return;
            }
            Exprent lastExp = lastData.getExprents().get(lastData.getExprents().size() - 1);
            if (lastExp instanceof ExitExprent) {
                return;
            }
            stat.setLooptype(DoStatement.Type.FOR);
            if (hasinit) {
                Exprent exp = preData.getExprents().remove(preData.getExprents().size() - 1);
                if (stat.getInitExprent() != null) {
                    exp.addBytecodeOffsets(stat.getInitExprent().bytecode);
                }
                stat.setInitExprent(exp);
            }
            lastData.getExprents().remove(lastExp);
            if (stat.getIncExprent() != null) {
                lastExp.addBytecodeOffsets(stat.getIncExprent().bytecode);
            }
            stat.setIncExprent(lastExp);
        }
        MergeHelper.cleanEmptyStatements(stat, lastData);
    }

    private static void cleanEmptyStatements(DoStatement dostat, Statement stat) {
        if (stat != null && stat.getExprents().isEmpty()) {
            List<StatEdge> lst = stat.getAllSuccessorEdges();
            if (!lst.isEmpty()) {
                stat.removeSuccessor(lst.get(0));
            }
            if (stat.getParent() instanceof CatchStatement || stat.getParent() instanceof CatchAllStatement || stat.getParent() instanceof SynchronizedStatement) {
                return;
            }
            MergeHelper.removeLastEmptyStatement(dostat, stat);
        }
    }

    private static void removeLastEmptyStatement(DoStatement dostat, Statement stat) {
        if (stat == dostat.getFirst()) {
            BasicBlockStatement bstat = BasicBlockStatement.create();
            dostat.replaceStatement(stat, bstat);
        } else {
            for (StatEdge edge : stat.getAllPredecessorEdges()) {
                edge.getSource().changeEdgeType(Statement.EdgeDirection.FORWARD, edge, 8);
                stat.removePredecessor(edge);
                edge.getSource().changeEdgeNode(Statement.EdgeDirection.FORWARD, edge, dostat);
                dostat.addPredecessor(edge);
                dostat.addLabeledEdge(edge);
            }
            stat.getParent().getStats().removeWithKey(stat.id);
            if (stat.getParent() instanceof IfStatement) {
                IfStatement parent = (IfStatement)stat.getParent();
                if (parent.getIfstat() == stat) {
                    parent.setIfstat(null);
                } else if (parent.getElsestat() == stat) {
                    parent.setElsestat(null);
                }
            }
        }
    }

    private static Statement getLastDirectData(Statement stat) {
        if (stat.getExprents() != null) {
            return stat;
        }
        for (int i = stat.getStats().size() - 1; i >= 0; --i) {
            Statement tmp = MergeHelper.getLastDirectData((Statement)stat.getStats().get(i));
            if (tmp != null && tmp.getExprents().isEmpty()) continue;
            return tmp;
        }
        return null;
    }

    private static boolean matchForEach(DoStatement stat) {
        Statement parent;
        AssignmentExprent firstDoExprent = null;
        AssignmentExprent[] initExprents = new AssignmentExprent[3];
        Statement firstData = null;
        Statement preData = null;
        Statement lastData = null;
        Exprent lastExprent = null;
        Statement current = stat;
        while ((parent = current.getParent()) != null && parent instanceof SequenceStatement) {
            if (current == parent.getFirst()) {
                current = parent;
                continue;
            }
            preData = current.getNeighbours(1, Statement.EdgeDirection.BACKWARD).get(0);
            if ((preData = MergeHelper.getLastDirectData(preData)) == null || preData.getExprents().isEmpty()) break;
            int size = preData.getExprents().size();
            for (int x = 0; x < initExprents.length; ++x) {
                Exprent exprent;
                if (size <= x || !((exprent = preData.getExprents().get(size - 1 - x)) instanceof AssignmentExprent)) continue;
                initExprents[x] = (AssignmentExprent)exprent;
            }
        }
        if ((firstData = MergeHelper.getFirstDirectData(stat.getFirst())) != null && firstData.getExprents().get(0) instanceof AssignmentExprent) {
            firstDoExprent = (AssignmentExprent)firstData.getExprents().get(0);
        }
        if ((lastData = MergeHelper.getLastDirectData(stat.getFirst())) != null && !lastData.getExprents().isEmpty()) {
            lastExprent = lastData.getExprents().get(lastData.getExprents().size() - 1);
        }
        if (stat.getLooptype() == DoStatement.Type.WHILE && initExprents[0] != null && firstDoExprent != null) {
            if (MergeHelper.isIteratorCall(initExprents[0].getRight())) {
                CheckTypesResult typeRes;
                InvocationExprent invc = (InvocationExprent)MergeHelper.getUncast(initExprents[0].getRight());
                if (invc.getClassname().contains("java/util/stream")) {
                    return false;
                }
                if (!MergeHelper.isHasNextCall(MergeHelper.drillNots(stat.getConditionExprent())) || !(firstDoExprent instanceof AssignmentExprent)) {
                    return false;
                }
                AssignmentExprent ass = firstDoExprent;
                if (!MergeHelper.isNextCall(ass.getRight()) && !MergeHelper.isNextUnboxing(ass.getRight()) || !(ass.getLeft() instanceof VarExprent)) {
                    return false;
                }
                InvocationExprent next = (InvocationExprent)MergeHelper.getUncast(ass.getRight());
                if (MergeHelper.isNextUnboxing(next)) {
                    next = (InvocationExprent)MergeHelper.getUncast(next.getInstance());
                }
                InvocationExprent hnext = (InvocationExprent)MergeHelper.getUncast(MergeHelper.drillNots(stat.getConditionExprent()));
                if (!(next.getInstance() instanceof VarExprent) || !(hnext.getInstance() instanceof VarExprent) || ((VarExprent)initExprents[0].getLeft()).isVarReferenced(stat, (VarExprent)next.getInstance(), (VarExprent)hnext.getInstance())) {
                    return false;
                }
                Exprent right = initExprents[0].getRight();
                if (right instanceof FunctionExprent) {
                    FunctionExprent fRight = (FunctionExprent)right;
                    if (fRight.getFuncType() == FunctionExprent.FunctionType.CAST) {
                        right = fRight.getLstOperands().get(0);
                    }
                    if (right instanceof InvocationExprent) {
                        return false;
                    }
                }
                if (MergeHelper.isVarUsedBefore((VarExprent)ass.getLeft(), stat)) {
                    return false;
                }
                InvocationExprent holder = (InvocationExprent)right;
                initExprents[0].getBytecodeRange(holder.getInstance().bytecode);
                holder.getBytecodeRange(holder.getInstance().bytecode);
                firstDoExprent.getBytecodeRange(ass.getLeft().bytecode);
                ass.getRight().getBytecodeRange(ass.getLeft().bytecode);
                if (stat.getIncExprent() != null) {
                    stat.getIncExprent().getBytecodeRange(holder.getInstance().bytecode);
                }
                if (stat.getInitExprent() != null) {
                    stat.getInitExprent().getBytecodeRange(ass.getLeft().bytecode);
                }
                stat.setLooptype(DoStatement.Type.FOR_EACH);
                stat.setInitExprent(ass.getLeft());
                stat.setIncExprent(holder.getInstance());
                preData.getExprents().remove(initExprents[0]);
                firstData.getExprents().remove(firstDoExprent);
                if (initExprents[1] != null && initExprents[1].getLeft() instanceof VarExprent && holder.getInstance() instanceof VarExprent) {
                    VarExprent copy = (VarExprent)initExprents[1].getLeft();
                    VarExprent inc = (VarExprent)holder.getInstance();
                    if (copy.getIndex() == inc.getIndex() && copy.getVersion() == inc.getVersion() && !inc.isVarReferenced(stat.getTopParent(), copy) && !MergeHelper.isNextCall(initExprents[1].getRight())) {
                        preData.getExprents().remove(initExprents[1]);
                        initExprents[1].getBytecodeRange(initExprents[1].getRight().bytecode);
                        stat.getIncExprent().getBytecodeRange(initExprents[1].getRight().bytecode);
                        stat.setIncExprent(initExprents[1].getRight());
                    }
                }
                if ((typeRes = ass.checkExprTypeBounds()) != null && !typeRes.getLstMinTypeExprents().isEmpty()) {
                    VarType boundType = typeRes.getLstMinTypeExprents().get((int)0).type;
                    VarExprent var = (VarExprent)ass.getLeft();
                    var.setBoundType(boundType);
                }
                return true;
            }
            if (initExprents[1] != null) {
                CheckTypesResult typeRes;
                VarExprent copy;
                if (!(firstDoExprent.getRight() instanceof ArrayExprent) || !(firstDoExprent.getLeft() instanceof VarExprent)) {
                    return false;
                }
                if (!(lastExprent instanceof FunctionExprent)) {
                    return false;
                }
                if (!(initExprents[0].getRight() instanceof ConstExprent && initExprents[1].getRight() instanceof FunctionExprent && stat.getConditionExprent() instanceof FunctionExprent)) {
                    return false;
                }
                FunctionExprent funcRight = (FunctionExprent)initExprents[1].getRight();
                FunctionExprent funcInc = (FunctionExprent)lastExprent;
                ArrayExprent arr = (ArrayExprent)firstDoExprent.getRight();
                FunctionExprent.FunctionType incType = funcInc.getFuncType();
                if (funcRight.getFuncType() != FunctionExprent.FunctionType.ARRAY_LENGTH || incType != FunctionExprent.FunctionType.PPI && incType != FunctionExprent.FunctionType.IPP || !(arr.getIndex() instanceof VarExprent) || !(arr.getArray() instanceof VarExprent)) {
                    return false;
                }
                VarExprent index = (VarExprent)arr.getIndex();
                VarExprent array = (VarExprent)arr.getArray();
                Exprent countExpr = funcInc.getLstOperands().get(0);
                if (countExpr instanceof VarExprent) {
                    VarExprent counter = (VarExprent)countExpr;
                    if (counter.getIndex() != index.getIndex() || counter.getVersion() != index.getVersion()) {
                        return false;
                    }
                    if (counter.isVarReferenced(stat.getFirst(), index)) {
                        return false;
                    }
                }
                if (MergeHelper.isVarUsedBefore((VarExprent)firstDoExprent.getLeft(), stat)) {
                    return false;
                }
                funcRight.getLstOperands().get(0).addBytecodeOffsets(initExprents[0].bytecode);
                funcRight.getLstOperands().get(0).addBytecodeOffsets(initExprents[1].bytecode);
                funcRight.getLstOperands().get(0).addBytecodeOffsets(lastExprent.bytecode);
                firstDoExprent.getLeft().addBytecodeOffsets(firstDoExprent.bytecode);
                firstDoExprent.getLeft().addBytecodeOffsets(initExprents[0].bytecode);
                stat.setLooptype(DoStatement.Type.FOR_EACH);
                stat.setInitExprent(firstDoExprent.getLeft());
                stat.setIncExprent(funcRight.getLstOperands().get(0));
                preData.getExprents().remove(initExprents[0]);
                preData.getExprents().remove(initExprents[1]);
                firstData.getExprents().remove(firstDoExprent);
                lastData.getExprents().remove(lastExprent);
                if (initExprents[2] != null && initExprents[2].getLeft() instanceof VarExprent && (copy = (VarExprent)initExprents[2].getLeft()).getIndex() == array.getIndex() && copy.getVersion() == array.getVersion()) {
                    preData.getExprents().remove(initExprents[2]);
                    initExprents[2].getRight().addBytecodeOffsets(initExprents[2].bytecode);
                    initExprents[2].getRight().addBytecodeOffsets(stat.getIncExprent().bytecode);
                    stat.setIncExprent(initExprents[2].getRight());
                }
                if ((typeRes = firstDoExprent.checkExprTypeBounds()) != null && !typeRes.getLstMinTypeExprents().isEmpty()) {
                    VarType boundType = typeRes.getLstMinTypeExprents().get((int)0).type;
                    VarExprent var = (VarExprent)firstDoExprent.getLeft();
                    var.setBoundType(boundType);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isVarUsedBefore(VarExprent var, Statement st) {
        FlattenStatementsHelper flatten = new FlattenStatementsHelper();
        DirectGraph digraph = flatten.buildDirectGraph(st.getTopParent());
        String diblockId = digraph.mapDestinationNodes.get(st.id)[0];
        DirectNode stnd = digraph.nodes.getWithKey(diblockId);
        LinkedList<DirectNode> stack = new LinkedList<DirectNode>(stnd.preds());
        HashSet<DirectNode> visited = new HashSet<DirectNode>();
        while (!stack.isEmpty()) {
            DirectNode node = (DirectNode)stack.pop();
            if (st.containsStatement(node.statement)) continue;
            if (node.exprents != null) {
                for (Exprent exprent : node.exprents) {
                    for (Exprent ex : exprent.getAllExprents(true, true)) {
                        if (!(ex instanceof VarExprent) || ((VarExprent)ex).getIndex() != var.getIndex()) continue;
                        return true;
                    }
                }
            }
            for (DirectNode pred : node.preds()) {
                if (!visited.add(pred)) continue;
                stack.push(pred);
            }
        }
        return false;
    }

    private static Exprent drillNots(Exprent exp) {
        while (exp instanceof FunctionExprent) {
            FunctionExprent fun = (FunctionExprent)exp;
            if (fun.getFuncType() == FunctionExprent.FunctionType.BOOL_NOT) {
                exp = fun.getLstOperands().get(0);
                continue;
            }
            if (fun.getFuncType() == FunctionExprent.FunctionType.EQ || fun.getFuncType() == FunctionExprent.FunctionType.NE) {
                return fun.getLstOperands().get(0);
            }
            return exp;
        }
        return exp;
    }

    private static Statement getFirstDirectData(Statement stat) {
        if (stat.getExprents() != null && !stat.getExprents().isEmpty()) {
            return stat;
        }
        for (Statement tmp : stat.getStats()) {
            Statement ret = MergeHelper.getFirstDirectData(tmp);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private static Exprent getUncast(Exprent exp) {
        FunctionExprent func;
        if (exp instanceof FunctionExprent && (func = (FunctionExprent)exp).getFuncType() == FunctionExprent.FunctionType.CAST) {
            return MergeHelper.getUncast(func.getLstOperands().get(0));
        }
        return exp;
    }

    private static InvocationExprent asInvocationExprent(Exprent exp) {
        if ((exp = MergeHelper.getUncast(exp)) instanceof InvocationExprent) {
            return (InvocationExprent)exp;
        }
        return null;
    }

    private static boolean isIteratorCall(Exprent exp) {
        InvocationExprent iexp = MergeHelper.asInvocationExprent(exp);
        if (iexp == null) {
            return false;
        }
        MethodDescriptor descriptor = iexp.getDescriptor();
        if (!DecompilerContext.getStructContext().instanceOf(descriptor.ret.value, "java/util/Iterator")) {
            return false;
        }
        String name = iexp.getName();
        return "iterator".equals(name) || "listIterator".equals(name);
    }

    private static boolean isHasNextCall(Exprent exp) {
        InvocationExprent iexp = MergeHelper.asInvocationExprent(exp);
        if (iexp == null) {
            return false;
        }
        if (!DecompilerContext.getStructContext().instanceOf(iexp.getClassname(), "java/util/Iterator")) {
            return false;
        }
        return "hasNext".equals(iexp.getName()) && "()Z".equals(iexp.getStringDescriptor());
    }

    private static boolean isNextCall(Exprent exp) {
        InvocationExprent iexp = MergeHelper.asInvocationExprent(exp);
        if (iexp == null) {
            return false;
        }
        if (!DecompilerContext.getStructContext().instanceOf(iexp.getClassname(), "java/util/Iterator")) {
            return false;
        }
        return "next".equals(iexp.getName()) && "()Ljava/lang/Object;".equals(iexp.getStringDescriptor());
    }

    private static boolean isNextUnboxing(Exprent exprent) {
        Exprent exp = MergeHelper.getUncast(exprent);
        if (!(exp instanceof InvocationExprent)) {
            return false;
        }
        InvocationExprent inv = (InvocationExprent)exp;
        return inv.isUnboxingCall() && MergeHelper.isNextCall(inv.getInstance());
    }

    public static boolean makeDoWhileLoops(RootStatement root) {
        if (MergeHelper.makeDoWhileRec(root)) {
            SequenceHelper.condenseSequences(root);
            return true;
        }
        return false;
    }

    private static boolean makeDoWhileRec(Statement stat) {
        DoStatement dostat;
        boolean ret = false;
        for (Statement st : stat.getStats()) {
            ret |= MergeHelper.makeDoWhileRec(st);
        }
        if (stat instanceof DoStatement && (dostat = (DoStatement)stat).getLooptype() == DoStatement.Type.INFINITE) {
            MergeHelper.matchDoWhile(dostat);
            if (dostat.getLooptype() != DoStatement.Type.INFINITE) {
                ret = true;
                ValidationHelper.validateStatement(stat.getTopParent());
            }
        }
        return ret;
    }

    private static boolean addContinueOrBreak(DoStatement stat, StatEdge ifedge) {
        Statement parent;
        Statement outer;
        for (outer = stat.getParent(); outer != null && !(outer instanceof SwitchStatement) && !(outer instanceof DoStatement); outer = outer.getParent()) {
        }
        if (!(outer == null || !(outer instanceof SwitchStatement) && ((DoStatement)outer).getLooptype() == DoStatement.Type.INFINITE || (parent = stat.getParent()) instanceof SequenceStatement && !parent.getStats().getLast().equals(stat))) {
            if (ifedge.getDestination().equals(outer)) {
                stat.addSuccessor(new StatEdge(8, stat, ifedge.getDestination(), outer));
                return true;
            }
            if (MergeHelper.isDirectPath(outer, ifedge.getDestination())) {
                stat.addSuccessor(new StatEdge(4, stat, ifedge.getDestination(), outer));
                return true;
            }
        }
        return false;
    }

    public static boolean condenseInfiniteLoopsWithReturn(Statement root) {
        boolean ret = MergeHelper.condenseInfiniteLoopsWithReturnRec(root);
        if (ret) {
            SequenceHelper.condenseSequences(root);
        }
        return ret;
    }

    private static boolean condenseInfiniteLoopsWithReturnRec(Statement stat) {
        DoStatement loop;
        boolean res = false;
        if (stat instanceof DoStatement && (loop = (DoStatement)stat).getLooptype() == DoStatement.Type.INFINITE) {
            res = MergeHelper.condenseLoop(loop);
        }
        for (Statement st : new ArrayList(stat.getStats())) {
            res |= MergeHelper.condenseInfiniteLoopsWithReturnRec(st);
        }
        return res;
    }

    private static boolean condenseLoop(DoStatement stat) {
        if (stat.getFirst() instanceof SequenceStatement && stat.getSuccessorEdges(1).isEmpty()) {
            Statement first = stat.getFirst();
            int extractStart = MergeHelper.extractableFromLoop((SequenceStatement)first, stat);
            if (first.getStats().size() >= 1 && extractStart > 0) {
                List<StatEdge> breaks;
                Statement firstBody = (Statement)first.getStats().get(0);
                Statement lastBody = first.getStats().getLast();
                Statement preExtract = (Statement)first.getStats().get(extractStart - 1);
                ArrayList<DoStatement> extract = new ArrayList<DoStatement>(first.getStats().subList(extractStart, first.getStats().size()));
                if (firstBody instanceof IfStatement && ((IfStatement)firstBody).iftype == 0 && firstBody.getBasichead().getExprents().isEmpty() && !(breaks = lastBody.getSuccessorEdges(4)).isEmpty() && breaks.get(0).getDestination() instanceof DummyExitStatement) {
                    HashSet<StatEdge> edges = new HashSet<StatEdge>();
                    TryWithResourcesProcessor.findEdgesLeaving(firstBody, firstBody, edges);
                    boolean continueFound = false;
                    for (StatEdge statEdge : edges) {
                        if (statEdge.getDestination() != stat || statEdge.getType() != 8) continue;
                        continueFound = true;
                        break;
                    }
                    if (!continueFound) {
                        return false;
                    }
                    for (Statement statement : extract) {
                        for (StatEdge edge : statement.getAllPredecessorEdges()) {
                            if (edge.getType() == 1 && edge.getSource() == preExtract) {
                                preExtract.removeSuccessor(edge);
                            }
                            if (edge.getType() != 4 || !stat.containsStatementStrict(edge.getSource())) continue;
                            stat.addLabeledEdge(edge);
                        }
                    }
                    extract.add(0, stat);
                    SequenceStatement seq = new SequenceStatement(extract);
                    for (Statement st : new ArrayList(extract)) {
                        stat.getFirst().getStats().removeWithKey(st.id);
                    }
                    stat.replaceWith(seq);
                    for (StatEdge edge : new ArrayList<StatEdge>(seq.getLabelEdges())) {
                        stat.addLabeledEdge(edge);
                    }
                    for (StatEdge edge : seq.getPredecessorEdges(8)) {
                        if (!stat.containsStatementStrict(edge.getSource())) continue;
                        seq.removePredecessor(edge);
                        edge.getSource().changeEdgeNode(Statement.EdgeDirection.FORWARD, edge, stat);
                        stat.addPredecessor(edge);
                    }
                    seq.setAllParent();
                    Statement statement = (Statement)extract.get(1);
                    stat.addSuccessor(new StatEdge(1, (Statement)stat, statement));
                    Statement ifstat = ((IfStatement)firstBody).getIfstat();
                    first.replaceWith(ifstat);
                    ((IfStatement)firstBody).getIfEdge().getDestination().removeSuccessor(((IfStatement)firstBody).getIfEdge());
                    stat.setFirst(ifstat);
                    stat.setAllParent();
                    stat.setLooptype(DoStatement.Type.WHILE);
                    stat.setConditionExprent(((IfStatement)firstBody).getHeadexprent().getCondition());
                    stat.getFirst().setAllParent();
                    return true;
                }
            }
        }
        return false;
    }

    private static int extractableFromLoop(SequenceStatement seq, DoStatement loop) {
        ArrayList<Statement> noContinue = new ArrayList<Statement>();
        for (int i = 0; i < seq.getStats().size(); ++i) {
            Statement last;
            StatEdge edge2;
            Statement stat = (Statement)seq.getStats().get(i);
            HashSet<StatEdge> edges = new HashSet<StatEdge>();
            TryWithResourcesProcessor.findEdgesLeaving(stat, stat, edges);
            boolean continueFound = false;
            for (StatEdge edge2 : edges) {
                if (edge2.getDestination() != loop || edge2.getType() != 8) continue;
                continueFound = true;
                break;
            }
            if (continueFound || i <= 0 || (last = (Statement)seq.getStats().get(i - 1)).getAllSuccessorEdges().size() != 1 || (edge2 = last.getAllSuccessorEdges().get(0)).getType() != 1 || edge2.getDestination() != stat) continue;
            noContinue.add(stat);
        }
        if (noContinue.isEmpty()) {
            return -1;
        }
        return seq.getStats().indexOf(noContinue.get(0));
    }
}

