/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.DecHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

public final class SequenceHelper {
    public static void condenseSequences(Statement root) {
        ValidationHelper.validateStatement(root.getTopParent());
        SequenceHelper.condenseSequencesRec(root);
        ValidationHelper.validateStatement(root.getTopParent());
    }

    private static void condenseSequencesRec(Statement stat) {
        if (stat instanceof SequenceStatement) {
            ArrayList lst = new ArrayList(((Statement)stat).getStats());
            boolean unfolded = false;
            for (int i = 0; i < lst.size(); ++i) {
                Statement st = (Statement)lst.get(i);
                if (!(st instanceof SequenceStatement)) continue;
                SequenceHelper.removeEmptyStatements((SequenceStatement)st);
                if (i != lst.size() - 1 && !SequenceHelper.isSequenceDisbandable(st, (Statement)lst.get(i + 1))) continue;
                Statement first = st.getFirst();
                for (StatEdge edge : st.getAllPredecessorEdges()) {
                    st.removePredecessor(edge);
                    edge.getSource().changeEdgeNode(Statement.EdgeDirection.FORWARD, edge, first);
                    first.addPredecessor(edge);
                }
                Statement last = st.getStats().getLast();
                if (last.getAllSuccessorEdges().isEmpty() && i < lst.size() - 1) {
                    last.addSuccessor(new StatEdge(1, last, (Statement)lst.get(i + 1)));
                } else {
                    for (StatEdge edge : last.getAllSuccessorEdges()) {
                        if (i == lst.size() - 1) {
                            if (edge.closure != st) continue;
                            ((Statement)stat).addLabeledEdge(edge);
                            continue;
                        }
                        edge.getSource().changeEdgeType(Statement.EdgeDirection.FORWARD, edge, 1);
                        if (edge.closure == null) {
                            throw new IllegalStateException("Closure is null for edge " + edge + " in statement " + last);
                        }
                        edge.closure.getLabelEdges().remove(edge);
                        edge.closure = null;
                    }
                }
                for (StatEdge edge : st.getAllSuccessorEdges()) {
                    st.removeSuccessor(edge);
                }
                for (StatEdge edge : new HashSet<StatEdge>(st.getLabelEdges())) {
                    if (edge.getSource() == last) continue;
                    if (last instanceof BasicBlockStatement) {
                        ((Statement)stat).addLabeledEdge(edge);
                        continue;
                    }
                    last.addLabeledEdge(edge);
                }
                lst.remove(i);
                lst.addAll(i, st.getStats());
                --i;
                SequenceHelper.clearClosure(st, st);
                unfolded = true;
            }
            if (unfolded) {
                SequenceStatement sequence = new SequenceStatement(lst);
                sequence.setAllParent();
                ((Statement)stat).getParent().replaceStatement((Statement)stat, sequence);
                stat = sequence;
                ValidationHelper.validateStatement(((Statement)stat).getTopParent());
            }
        }
        if (stat instanceof SequenceStatement) {
            SequenceHelper.removeEmptyStatements((SequenceStatement)stat);
            if (((Statement)stat).getStats().size() == 1) {
                boolean ok;
                Statement st = ((Statement)stat).getFirst();
                boolean bl = ok = !st.hasAnySuccessor();
                if (!ok) {
                    StatEdge edge = st.getFirstSuccessor();
                    boolean bl2 = ok = !((Statement)stat).hasAnySuccessor();
                    if (!ok) {
                        StatEdge statedge = ((Statement)stat).getFirstSuccessor();
                        boolean bl3 = ok = edge.getDestination() == statedge.getDestination();
                        if (ok) {
                            st.removeSuccessor(edge);
                        }
                    }
                }
                if (ok) {
                    ((Statement)stat).getParent().replaceStatement((Statement)stat, st);
                    stat = st;
                }
            }
        }
        block5: while (true) {
            for (Statement st : ((Statement)stat).getStats()) {
                if (!st.getStats().isEmpty() && st.getExprents() == null || st instanceof BasicBlockStatement) continue;
                SequenceHelper.destroyAndFlattenStatement(st);
                continue block5;
            }
            break;
        }
        for (int i = 0; i < ((Statement)stat).getStats().size(); ++i) {
            SequenceHelper.condenseSequencesRec((Statement)((Statement)stat).getStats().get(i));
        }
    }

    public static void clearClosure(Statement stat, Statement clear) {
        for (StatEdge edge : stat.getAllSuccessorEdges()) {
            if (edge.closure != clear) continue;
            edge.closure.getLabelEdges().remove(edge);
            edge.closure = null;
        }
        for (Statement st : stat.getStats()) {
            SequenceHelper.clearClosure(st, clear);
        }
    }

    private static boolean isSequenceDisbandable(Statement block, Statement next) {
        Statement last = block.getStats().getLast();
        if (last.hasAnySuccessor() && last.getFirstSuccessor().getDestination() != next) {
            return false;
        }
        for (StatEdge edge : next.getPredecessorEdges(4)) {
            if (last == edge.getSource() || last.containsStatementStrict(edge.getSource())) continue;
            return false;
        }
        return true;
    }

    private static void removeEmptyStatements(SequenceStatement sequence) {
        boolean found;
        if (sequence.getStats().size() <= 1) {
            return;
        }
        SequenceHelper.mergeFlatStatements(sequence);
        ValidationHelper.validateStatement(sequence.getTopParent());
        block0: do {
            found = false;
            for (Statement st : sequence.getStats()) {
                if (st.getExprents() == null || !st.getExprents().isEmpty()) continue;
                if (!st.hasAnySuccessor()) {
                    List<StatEdge> lstBreaks = st.getPredecessorEdges(4);
                    if (lstBreaks.isEmpty()) {
                        for (StatEdge edge : st.getAllPredecessorEdges()) {
                            edge.getSource().removeSuccessor(edge);
                        }
                        found = true;
                    }
                } else {
                    StatEdge sucedge = st.getFirstSuccessor();
                    if (sucedge.getType() != 32) {
                        st.removeSuccessor(sucedge);
                        for (StatEdge edge : st.getAllPredecessorEdges()) {
                            if (sucedge.getType() != 1) {
                                edge.getSource().changeEdgeType(Statement.EdgeDirection.FORWARD, edge, sucedge.getType());
                            }
                            st.removePredecessor(edge);
                            edge.getSource().changeEdgeNode(Statement.EdgeDirection.FORWARD, edge, sucedge.getDestination());
                            sucedge.getDestination().addPredecessor(edge);
                            if (sucedge.closure == null) continue;
                            sucedge.closure.addLabeledEdge(edge);
                        }
                        for (StatEdge edge : st.getLabelEdges()) {
                            if (edge.closure != st) continue;
                            edge.closure = null;
                        }
                        found = true;
                    }
                }
                if (!found) continue;
                sequence.getStats().removeWithKey(st.id);
                continue block0;
            }
        } while (found);
        sequence.setFirst((Statement)sequence.getStats().get(0));
    }

    private static void mergeFlatStatements(SequenceStatement sequence) {
        boolean found;
        do {
            Statement current = null;
            found = false;
            for (int i = sequence.getStats().size() - 1; i >= 0; --i) {
                Statement next = current;
                current = (Statement)sequence.getStats().get(i);
                if (next == null || current.getExprents() == null || current.getExprents().isEmpty()) continue;
                if (next.getExprents() != null) {
                    next.getExprents().addAll(0, current.getExprents());
                    current.getExprents().clear();
                    found = true;
                    continue;
                }
                Statement first = SequenceHelper.getFirstExprentlist(next);
                if (first == null) continue;
                first.getExprents().addAll(0, current.getExprents());
                current.getExprents().clear();
                found = true;
            }
        } while (found);
    }

    private static Statement getFirstExprentlist(Statement stat) {
        if (stat.getExprents() != null) {
            return stat;
        }
        switch (stat.type) {
            case IF: 
            case SEQUENCE: 
            case SWITCH: 
            case SYNCHRONIZED: {
                return SequenceHelper.getFirstExprentlist(stat.getFirst());
            }
        }
        return null;
    }

    public static BasicBlockStatement destroyAndFlattenStatement(Statement stat) {
        SequenceHelper.destroyStatementContent(stat, false);
        BasicBlockStatement bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
        if (stat.getExprents() == null) {
            bstat.setExprents(new ArrayList<Exprent>());
        } else {
            bstat.setExprents(DecHelper.copyExprentList(stat.getExprents()));
        }
        stat.getParent().replaceStatement(stat, bstat);
        return bstat;
    }

    public static void destroyStatementContent(Statement stat, boolean self) {
        for (Statement st : stat.getStats()) {
            SequenceHelper.destroyStatementContent(st, true);
        }
        stat.getStats().clear();
        if (self) {
            for (StatEdge edge : stat.getAllSuccessorEdges()) {
                stat.removeSuccessor(edge);
            }
            for (StatEdge edge : stat.getAllPredecessorEdges()) {
                edge.getSource().removeSuccessor(edge);
            }
        }
    }

    public static Statement firstNonSeq(Statement stat) {
        Statement first = stat.getFirst();
        if (first == null) {
            return stat;
        }
        while (first instanceof SequenceStatement) {
            first = first.getFirst();
        }
        return first;
    }
}

