/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.SwitchHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.SwitchHeadExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.Pair;

public final class SwitchPatternMatchProcessor {
    public static boolean processPatternMatching(Statement root) {
        boolean ret = SwitchPatternMatchProcessor.processPatternMatchingRec(root, root);
        if (ret) {
            SequenceHelper.condenseSequences(root);
        }
        return ret;
    }

    private static boolean processPatternMatchingRec(Statement stat, Statement root) {
        ValidationHelper.validateStatement((RootStatement)root);
        boolean ret = false;
        for (Statement st : new ArrayList(stat.getStats())) {
            ret |= SwitchPatternMatchProcessor.processPatternMatchingRec(st, root);
            ValidationHelper.validateStatement((RootStatement)root);
        }
        if (stat instanceof SwitchStatement) {
            ret |= SwitchPatternMatchProcessor.processStatement((SwitchStatement)stat, root);
            ValidationHelper.validateStatement((RootStatement)root);
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean processStatement(SwitchStatement stat, Statement root) {
        int i;
        if (stat.isPhantom()) {
            return false;
        }
        SwitchHeadExprent head = (SwitchHeadExprent)stat.getHeadexprent();
        boolean switchPatternMatch = SwitchPatternMatchProcessor.isSwitchPatternMatch(head);
        if (!switchPatternMatch) {
            return false;
        }
        InvocationExprent value = (InvocationExprent)head.getValue();
        List<Exprent> origParams = value.getLstParameters();
        Exprent realSelector = origParams.get(0);
        boolean guarded = true;
        boolean isEnumSwitch = value.getName().equals("enumSwitch");
        ArrayList references = new ArrayList();
        if (origParams.get(1) instanceof VarExprent) {
            VarExprent var = (VarExprent)origParams.get(1);
            SwitchHelper.findExprents(root, Exprent.class, x$0 -> var.isVarReferenced((Exprent)x$0, new VarExprent[0]), false, (st, expr) -> references.add(Pair.of(st, expr)));
            if (references.size() == 1) {
                Pair ref = (Pair)references.get(0);
                if (ref.b instanceof AssignmentExprent) {
                    ((Statement)ref.a).getExprents().remove(ref.b);
                    guarded = false;
                }
            }
        }
        HashMap<List<Exprent>, Exprent> guards = new HashMap<List<Exprent>, Exprent>(0);
        if (guarded) {
            guards = new HashMap(references.size());
            boolean canEliminate = true;
            Pair initialUse = (Pair)references.get(0);
            if (initialUse.b instanceof AssignmentExprent && ((AssignmentExprent)initialUse.b).getRight() instanceof ConstExprent) {
                Iterator constExprent = (ConstExprent)((AssignmentExprent)initialUse.b).getRight();
                if (((ConstExprent)((Object)constExprent)).getConstType().typeFamily != 2 || ((ConstExprent)((Object)constExprent)).getIntValue() != 0) {
                    return false;
                }
            } else {
                return false;
            }
            references.remove(0);
            for (Pair reference : references) {
                canEliminate &= SwitchPatternMatchProcessor.eliminateGuardRef(stat, guards, reference, true);
            }
            if (!canEliminate) {
                return false;
            }
            ((Statement)initialUse.a).getExprents().remove(initialUse.b);
            for (Pair reference : references) {
                SwitchPatternMatchProcessor.eliminateGuardRef(stat, guards, reference, false);
            }
        }
        for (i = 0; i < stat.getCaseStatements().size(); ++i) {
            AssignmentExprent assign;
            Exprent expr2;
            BasicBlockStatement basicBlockStatement;
            int n;
            Statement caseStat = stat.getCaseStatements().get(i);
            List<Exprent> allCases = stat.getCaseValues().get(i);
            Exprent caseExpr = allCases.get(0);
            if (caseExpr == null) continue;
            if (guards.containsKey(allCases)) {
                while (stat.getCaseGuards().size() <= i) {
                    stat.getCaseGuards().add(null);
                }
                stat.getCaseGuards().set(i, (Exprent)guards.get(allCases));
            }
            if (caseExpr instanceof ConstExprent && (n = ((ConstExprent)caseExpr).getIntValue()) == -1) {
                allCases.remove(caseExpr);
                ConstExprent nullConst = new ConstExprent(VarType.VARTYPE_NULL, null, null);
                if (allCases.contains(null)) {
                    allCases.add(allCases.indexOf(null), nullConst);
                } else {
                    allCases.add(nullConst);
                }
            }
            if (caseStat instanceof SequenceStatement) {
                Statement statement = caseStat;
                caseStat = (Statement)caseStat.getStats().get(0);
                if (statement.getStats().size() == 1) {
                    statement.replaceWith(caseStat);
                }
            }
            if ((basicBlockStatement = caseStat.getBasichead()).getExprents().size() < 1 || !((expr2 = basicBlockStatement.getExprents().get(0)) instanceof AssignmentExprent) || !((assign = (AssignmentExprent)expr2).getLeft() instanceof VarExprent)) continue;
            VarExprent var = (VarExprent)assign.getLeft();
            if (!(assign.getRight() instanceof FunctionExprent) || ((FunctionExprent)assign.getRight()).getFuncType() != FunctionExprent.FunctionType.CAST) continue;
            FunctionExprent cast = (FunctionExprent)assign.getRight();
            ArrayList<Exprent> operands = new ArrayList<Exprent>();
            operands.add(cast.getLstOperands().get(0));
            operands.add(cast.getLstOperands().get(1));
            operands.add(var);
            FunctionExprent func = new FunctionExprent(FunctionExprent.FunctionType.INSTANCEOF, operands, null);
            basicBlockStatement.getExprents().remove(0);
            allCases.set(0, func);
        }
        for (i = 0; i < value.getBootstrapArguments().size(); ++i) {
            void var15_29;
            PooledConstant bsa = value.getBootstrapArguments().get(i);
            int replaceIndex = i;
            for (List list : stat.getCaseValues()) {
                ConstExprent constExpr;
                if (!(list.get(0) instanceof ConstExprent) || !((constExpr = (ConstExprent)list.get(0)).getValue() instanceof Integer) || (Integer)constExpr.getValue() != i) continue;
                replaceIndex = stat.getCaseValues().indexOf(list);
            }
            if (!(bsa instanceof PrimitiveConstant)) continue;
            PrimitiveConstant p = (PrimitiveConstant)bsa;
            Object var15_24 = null;
            switch (p.type) {
                case 3: {
                    ConstExprent constExprent = new ConstExprent((Integer)p.value, false, null);
                    break;
                }
                case 8: {
                    if (isEnumSwitch) {
                        String typeName = realSelector.getExprType().value;
                        FieldExprent fieldExprent = new FieldExprent(p.value.toString(), typeName, true, null, FieldDescriptor.parseDescriptor("L" + typeName + ";"), null, false, false);
                        break;
                    }
                    ConstExprent constExprent = new ConstExprent(VarType.VARTYPE_STRING, p.value, null);
                    break;
                }
                case 7: {
                    if (!stat.getCaseValues().get(replaceIndex).stream().allMatch(x -> x instanceof ConstExprent)) break;
                    VarType castType = new VarType(8, 0, (String)p.value);
                    ArrayList<Exprent> operands = new ArrayList<Exprent>();
                    operands.add(realSelector);
                    operands.add(new ConstExprent(castType, null, null));
                    operands.add(new VarExprent(DecompilerContext.getCounterContainer().getCounterAndIncrement(2), castType, DecompilerContext.getVarProcessor()));
                    FunctionExprent functionExprent = new FunctionExprent(FunctionExprent.FunctionType.INSTANCEOF, operands, null);
                }
            }
            if (var15_29 == null) continue;
            int ix = i;
            void nvx = var15_29;
            stat.getCaseValues().get(replaceIndex).replaceAll(arg_0 -> SwitchPatternMatchProcessor.lambda$processStatement$3(ix, (Exprent)nvx, arg_0));
        }
        head.setValue(realSelector);
        if (guarded && stat.getParent() instanceof DoStatement) {
            stat.getParent().replaceWith(stat);
            for (StatEdge edge : stat.getPredecessorEdges(8)) {
                edge.changeType(4);
            }
        }
        return true;
    }

    private static boolean eliminateGuardRef(SwitchStatement stat, Map<List<Exprent>, Exprent> guards, Pair<Statement, Exprent> reference, boolean simulate) {
        block13: {
            Statement parent;
            block14: {
                if (!(reference.b instanceof AssignmentExprent)) break block13;
                Statement assignStat = (Statement)reference.a;
                if (assignStat.getAllPredecessorEdges().size() > 1) {
                    return false;
                }
                parent = assignStat.getParent();
                boolean invert = true;
                if (parent instanceof SequenceStatement && parent.getStats().size() == 2 && parent.getStats().get(1) == assignStat) {
                    parent = (Statement)parent.getStats().get(0);
                    invert = false;
                }
                if (!(assignStat instanceof BasicBlockStatement) || assignStat.getExprents().size() != 1 || !(parent instanceof IfStatement) || ((IfStatement)parent).iftype != 0 || ((IfStatement)parent).getIfstat() == null || !(parent.getParent() instanceof SequenceStatement) || parent.getParent().getParent() != stat) break block14;
                StatEdge continueEdge = assignStat.getSuccessorEdges(8).get(0);
                Statement next = continueEdge.getDestination();
                if (next != stat.getParent()) break block13;
                IfStatement guardIf = (IfStatement)parent;
                Exprent guardExprent = guardIf.getHeadexprent().getCondition();
                List<Statement> caseStatements = stat.getCaseStatements();
                for (int i = 0; i < caseStatements.size(); ++i) {
                    Statement nextStat;
                    if (!caseStatements.get(i).containsStatement((Statement)reference.a)) continue;
                    if (simulate) {
                        return true;
                    }
                    List<Exprent> guardExprs = ((Statement)guardIf.getStats().get(0)).getExprents();
                    List carryExprs = guardExprs.size() > 0 ? Collections.singletonList(guardExprs.get(0)) : Collections.emptyList();
                    continueEdge.remove();
                    guardIf.getParent().getStats().remove(0);
                    if (invert) {
                        guardExprent = new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, guardExprent, guardExprent.bytecode);
                        nextStat = (Statement)guardIf.getParent().getStats().get(0);
                    } else {
                        nextStat = guardIf.getIfstat();
                        guardIf.getParent().getStats().remove(0);
                        guardIf.getParent().getStats().add(nextStat);
                    }
                    guards.put(stat.getCaseValues().get(i), guardExprent);
                    guardIf.getParent().setFirst(nextStat);
                    for (StatEdge edge : nextStat.getAllPredecessorEdges()) {
                        edge.remove();
                    }
                    nextStat.getBasichead().getExprents().addAll(0, carryExprs);
                    return true;
                }
                break block13;
            }
            if (parent == stat) {
                List<Statement> caseStatements = stat.getCaseStatements();
                for (int i = 0; i < caseStatements.size(); ++i) {
                    if (!caseStatements.get(i).containsStatement((Statement)reference.a)) continue;
                    if (simulate) {
                        return true;
                    }
                    guards.put(stat.getCaseValues().get(i), new ConstExprent(0, true, null));
                    BasicBlockStatement replaced = ((Statement)reference.a).replaceWithEmpty();
                    replaced.getFirstSuccessor().remove();
                    HashSet<StatEdge> labelEdges = stat.getParent().getLabelEdges();
                    boolean multipleSuccessors = false;
                    Statement target = null;
                    for (StatEdge edge : labelEdges) {
                        if (edge.getType() != 4) continue;
                        if (target == null) {
                            target = edge.getDestination();
                            continue;
                        }
                        if (edge.getDestination() == target) continue;
                        multipleSuccessors = true;
                        break;
                    }
                    if (target != null && !multipleSuccessors) {
                        replaced.addSuccessor(new StatEdge(4, replaced, target, stat.getParent()));
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isSwitchPatternMatch(SwitchHeadExprent head) {
        Exprent value = head.getValue();
        if (value instanceof InvocationExprent) {
            InvocationExprent invoc = (InvocationExprent)value;
            return invoc.getInvocationType() == InvocationExprent.InvocationType.DYNAMIC && (invoc.getName().equals("typeSwitch") || invoc.getName().equals("enumSwitch"));
        }
        return false;
    }

    public static boolean hasPatternMatch(RootStatement root) {
        return root.mt.getBytecodeVersion().hasSwitchPatternMatch() && DecompilerContext.getOption("dpr");
    }
}

