/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.decompose;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class DominatorEngine {
    private final Statement statement;
    private final VBStyleCollection<Integer, Integer> colOrderedIDoms = new VBStyleCollection();

    public DominatorEngine(Statement statement) {
        this.statement = statement;
    }

    public void initialize() {
        this.calcIDoms();
    }

    private void orderStatements() {
        for (Statement stat : this.statement.getReversePostOrderList()) {
            this.colOrderedIDoms.addWithKey(null, stat.id);
        }
    }

    private static Integer getCommonIDom(Integer key1, Integer key2, VBStyleCollection<Integer, Integer> orderedIDoms) {
        if (key1 == null) {
            return key2;
        }
        if (key2 == null) {
            return key1;
        }
        int index1 = orderedIDoms.getIndexByKey(key1);
        int index2 = orderedIDoms.getIndexByKey(key2);
        while (index1 != index2) {
            if (index1 > index2) {
                key1 = orderedIDoms.getWithKey(key1);
                index1 = orderedIDoms.getIndexByKey(key1);
                continue;
            }
            key2 = orderedIDoms.getWithKey(key2);
            index2 = orderedIDoms.getIndexByKey(key2);
        }
        return key1;
    }

    private void calcIDoms() {
        boolean changed;
        this.orderStatements();
        this.colOrderedIDoms.putWithKey(this.statement.getFirst().id, this.statement.getFirst().id);
        List<Integer> lstIds = this.colOrderedIDoms.getLstKeys().subList(1, this.colOrderedIDoms.getLstKeys().size());
        do {
            changed = false;
            for (int id : lstIds) {
                Statement stat = this.statement.getStats().getWithKey(id);
                Integer idom = null;
                for (StatEdge edge : stat.getAllPredecessorEdges()) {
                    if (this.colOrderedIDoms.getWithKey(edge.getSource().id) == null) continue;
                    idom = DominatorEngine.getCommonIDom(idom, edge.getSource().id, this.colOrderedIDoms);
                }
                Integer oldidom = this.colOrderedIDoms.putWithKey(idom, id);
                if (idom.equals(oldidom)) continue;
                changed = true;
            }
        } while (changed);
    }

    public VBStyleCollection<Integer, Integer> getOrderedIDoms() {
        return this.colOrderedIDoms;
    }

    public boolean isDominator(Integer node, Integer dom) {
        while (!node.equals(dom)) {
            Integer idom = this.colOrderedIDoms.getWithKey(node);
            if (idom.equals(node)) {
                return false;
            }
            node = idom;
        }
        return true;
    }

    public Set<Integer> allDomsFor(Integer start) {
        HashSet<Integer> ret = new HashSet<Integer>();
        LinkedList<Integer> stack = new LinkedList<Integer>();
        stack.add(start);
        while (!stack.isEmpty()) {
            Integer id = (Integer)stack.removeFirst();
            if (ret.contains(id)) continue;
            ret.add(id);
            for (Integer key : this.colOrderedIDoms.getLstKeys()) {
                Integer ndid = this.colOrderedIDoms.getWithKey(key);
                if (!ndid.equals(id)) continue;
                stack.add(key);
            }
        }
        return ret;
    }
}

