/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.decompose;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.DominatorEngine;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.util.FastFixedSetFactory;

public final class SupportComponent {
    public final List<Statement> stats;
    public final Map<Integer, FastFixedSetFactory.FastFixedSet<Integer>> selfSupportPoints;
    public final Statement supportedPoint;

    public SupportComponent(List<Statement> stats, Map<Integer, FastFixedSetFactory.FastFixedSet<Integer>> selfSupportPoints, Statement supportedPoint) {
        this.stats = stats;
        this.selfSupportPoints = selfSupportPoints;
        this.supportedPoint = supportedPoint;
    }

    public static SupportComponent identify(List<Statement> component, Map<Integer, FastFixedSetFactory.FastFixedSet<Integer>> mapSupportPoints, DominatorEngine dom) {
        HashMap<Integer, FastFixedSetFactory.FastFixedSet<Integer>> selfSupportPoints = new HashMap<Integer, FastFixedSetFactory.FastFixedSet<Integer>>();
        HashSet<Statement> supportedAll = new HashSet<Statement>();
        for (Statement statement : component) {
            FastFixedSetFactory.FastFixedSet<Integer> supReach = mapSupportPoints.get(statement.id);
            if (supReach == null) continue;
            for (StatEdge edge : statement.getSuccessorEdgeView(1)) {
                Statement dest = edge.getDestination();
                if (!component.contains(dest)) {
                    return null;
                }
                if (!dom.isDominator(statement.id, dest.id)) continue;
                supportedAll.add(dest);
            }
            selfSupportPoints.put(statement.id, supReach);
        }
        if (supportedAll.size() != 1) {
            return null;
        }
        if (selfSupportPoints.isEmpty()) {
            return null;
        }
        ArrayList<Statement> outgoing = new ArrayList<Statement>();
        for (Statement st : component) {
            for (StatEdge edge : st.getPredecessorEdges(1)) {
                if (component.contains(edge.getSource())) continue;
                outgoing.add(st);
            }
        }
        if (outgoing.size() != 1) {
            return null;
        }
        Statement statement = (Statement)outgoing.get(0);
        for (Statement st : component) {
            if (dom.isDominator(st.id, statement.id)) continue;
            return null;
        }
        return new SupportComponent(component, selfSupportPoints, statement);
    }

    public String toString() {
        return "SupportComponent[" + this.stats + ", selfSupportPoints=" + this.selfSupportPoints + ", header=" + this.supportedPoint + "]";
    }
}

