/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class AnnotationExprent
extends Exprent {
    private final String className;
    private final List<String> parNames;
    private final List<? extends Exprent> parValues;

    public AnnotationExprent(String className, List<String> parNames, List<? extends Exprent> parValues) {
        super(Exprent.Type.ANNOTATION);
        this.className = className;
        this.parNames = parNames;
        this.parValues = parValues;
    }

    @Override
    protected List<Exprent> getAllExprents(List<Exprent> list) {
        list.addAll(this.parValues);
        return list;
    }

    @Override
    public Exprent copy() {
        ArrayList<Exprent> exps = new ArrayList<Exprent>();
        for (Exprent exprent : this.parValues) {
            exps.add(exprent.copy());
        }
        return new AnnotationExprent(this.className, this.parNames, exps);
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer buffer = new TextBuffer();
        buffer.appendIndent(indent);
        buffer.append('@');
        buffer.append(DecompilerContext.getImportCollector().getShortName(ExprProcessor.buildJavaClassName(this.className)));
        Type type = this.getAnnotationType();
        if (type != Type.MARKER) {
            buffer.append('(');
            boolean oneLiner = type == Type.SINGLE_ELEMENT || indent < 0;
            for (int i = 0; i < this.parNames.size(); ++i) {
                if (!oneLiner) {
                    buffer.appendLineSeparator().appendIndent(indent + 1);
                }
                if (type != Type.SINGLE_ELEMENT) {
                    buffer.append(this.parNames.get(i));
                    buffer.append(" = ");
                }
                buffer.append(this.parValues.get(i).toJava(0));
                if (i >= this.parNames.size() - 1) continue;
                buffer.append(',');
            }
            if (!oneLiner) {
                buffer.appendLineSeparator().appendIndent(indent);
            }
            buffer.append(')');
        }
        return buffer;
    }

    public String getClassName() {
        return this.className;
    }

    public Type getAnnotationType() {
        if (this.parNames.isEmpty()) {
            return Type.MARKER;
        }
        if (this.parNames.size() == 1 && "value".equals(this.parNames.get(0))) {
            return Type.SINGLE_ELEMENT;
        }
        return Type.NORMAL;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnnotationExprent)) {
            return false;
        }
        AnnotationExprent ann = (AnnotationExprent)o;
        return this.className.equals(ann.className) && InterpreterUtil.equalLists(this.parNames, ann.parNames) && InterpreterUtil.equalLists(this.parValues, ann.parValues);
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        AnnotationExprent.measureBytecode(values, this.parValues);
        this.measureBytecode(values);
    }

    public static enum Type {
        NORMAL,
        MARKER,
        SINGLE_ELEMENT;

    }
}

