/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericClassDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class AssignmentExprent
extends Exprent {
    private Exprent left;
    private Exprent right;
    private FunctionExprent.FunctionType condType = null;

    public AssignmentExprent(Exprent left, Exprent right, BitSet bytecodeOffsets) {
        super(Exprent.Type.ASSIGNMENT);
        this.left = left;
        this.right = right;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    public AssignmentExprent(Exprent left, Exprent right, FunctionExprent.FunctionType condType, BitSet bytecodeOffsets) {
        this(left, right, bytecodeOffsets);
        this.condType = condType;
    }

    @Override
    public VarType getExprType() {
        return this.left.getExprType();
    }

    @Override
    public VarType getInferredExprType(VarType upperBounds) {
        return this.left.getInferredExprType(upperBounds);
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        VarType typeLeft = this.left.getExprType();
        VarType typeRight = this.right.getExprType();
        if (typeLeft.typeFamily > typeRight.typeFamily) {
            result.addMinTypeExprent(this.right, VarType.getMinTypeInFamily(typeLeft.typeFamily));
        } else if (typeLeft.typeFamily < typeRight.typeFamily) {
            result.addMinTypeExprent(this.left, typeRight);
        } else {
            result.addMinTypeExprent(this.left, VarType.getCommonSupertype(typeLeft, typeRight));
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> lst) {
        lst.add(this.left);
        lst.add(this.right);
        return lst;
    }

    @Override
    public Exprent copy() {
        return new AssignmentExprent(this.left.copy(), this.right.copy(), this.condType, this.bytecode);
    }

    @Override
    public int getPrecedence() {
        return 13;
    }

    @Override
    public TextBuffer toJava(int indent) {
        VarExprent varLeft;
        VarType leftType = this.left.getInferredExprType(null);
        VarType rightType = this.right.getInferredExprType(leftType);
        boolean fieldInClassInit = false;
        boolean hiddenField = false;
        if (this.left instanceof FieldExprent) {
            StructField fd;
            FieldExprent field = (FieldExprent)this.left;
            ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
            if (node != null && (fd = node.classStruct.getField(field.getName(), field.getDescriptor().descriptorString)) != null) {
                if (field.isStatic() && fd.hasModifier(16)) {
                    fieldInClassInit = true;
                }
                if (node.getWrapper() != null && node.getWrapper().getHiddenMembers().contains(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()))) {
                    hiddenField = true;
                }
            }
        }
        if (hiddenField) {
            return new TextBuffer();
        }
        TextBuffer buffer = new TextBuffer();
        if (fieldInClassInit) {
            buffer.append(((FieldExprent)this.left).getName());
        } else {
            buffer.append(this.left.toJava(indent));
        }
        if (this.right instanceof ConstExprent) {
            ((ConstExprent)this.right).adjustConstType(leftType);
        }
        this.optimizeCastForAssign();
        TextBuffer res = this.right.toJava(indent);
        if (this.condType == null) {
            this.wrapInCast(leftType, rightType, res, this.right.getPrecedence());
        }
        if (this.condType == null) {
            buffer.append(" = ");
        } else {
            buffer.append(" ").append(this.condType.operator).append("= ");
        }
        buffer.append(res);
        buffer.addStartBytecodeMapping(this.bytecode);
        if (this.left instanceof VarExprent && DecompilerContext.getOption("dec") && (varLeft = (VarExprent)this.left).isDefinition() && varLeft.getProcessor() != null && varLeft.getProcessor().getSyntheticSemaphores().contains(varLeft.getIndex())) {
            buffer.append(" /* QF: Semaphore variable */");
        }
        return buffer;
    }

    private void optimizeCastForAssign() {
        VarType leftType;
        if (!(this.right instanceof FunctionExprent)) {
            return;
        }
        FunctionExprent func = (FunctionExprent)this.right;
        if (func.getFuncType() != FunctionExprent.FunctionType.CAST) {
            return;
        }
        Exprent cast = func.getLstOperands().get(1);
        if (!func.doesCast() && this.left instanceof VarExprent && DecompilerContext.getStructContext().instanceOf(this.right.getExprType().value, cast.getExprType().value)) {
            Exprent castVal = func.getLstOperands().get(0);
            if (this.left.getExprType().arrayDim > castVal.getExprType().arrayDim) {
                func.setNeedsCast(true);
                return;
            }
        }
        if (!((leftType = this.left.getInferredExprType(null)) instanceof GenericType)) {
            return;
        }
        MethodWrapper method = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
        if (method == null) {
            return;
        }
        StructMethod mt = method.methodStruct;
        GenericMethodDescriptor descriptor = mt.getSignature();
        if (descriptor == null || descriptor.typeParameters.isEmpty()) {
            return;
        }
        List<String> params = descriptor.typeParameters;
        int index = params.indexOf(leftType.value);
        if (index == -1) {
            return;
        }
        List<List<VarType>> bounds = descriptor.typeParameterBounds;
        List<VarType> types = bounds.get(index);
        GenericClassDescriptor classDescriptor = method.classStruct.getSignature();
        if (classDescriptor != null) {
            for (VarType type : new ArrayList<VarType>(types)) {
                int idex = classDescriptor.fparameters.indexOf(type.value);
                if (idex == -1) continue;
                types.addAll((Collection<VarType>)classDescriptor.fbounds.get(idex));
            }
        }
        VarType rightType = cast.getInferredExprType(leftType);
        boolean didReset = false;
        for (VarType type : types) {
            if (!rightType.value.equals(type.value)) continue;
            ((ConstExprent)cast).setConstType(leftType);
            didReset = true;
        }
        if (didReset) {
            func.getInferredExprType(null);
        }
    }

    private void wrapInCast(VarType left, VarType right, TextBuffer buf, int precedence) {
        FunctionExprent func;
        boolean needsCast;
        boolean bl = needsCast = !left.isSuperset(right) && (right.equals(VarType.VARTYPE_OBJECT) || left.type != 8);
        if (left.isGeneric() || right.isGeneric()) {
            List<VarType> types;
            Map<VarType, List<VarType>> names = this.getNamedGenerics();
            int arrayDim = 0;
            if (left.arrayDim == right.arrayDim && left.arrayDim > 0) {
                arrayDim = left.arrayDim;
                left = left.resizeArrayDim(0);
                right = right.resizeArrayDim(0);
            }
            if ((types = names.get(right)) == null) {
                types = names.get(left);
            }
            if (types != null) {
                boolean anyMatch = false;
                for (VarType type : types) {
                    if (type.equals(VarType.VARTYPE_OBJECT) && right.equals(VarType.VARTYPE_OBJECT)) continue;
                    anyMatch |= right.value == null || DecompilerContext.getStructContext().instanceOf(right.value, type.value);
                }
                if (anyMatch) {
                    needsCast = false;
                }
            }
            if (arrayDim != 0) {
                left = left.resizeArrayDim(arrayDim);
            }
        }
        if (this.right instanceof FunctionExprent && (func = (FunctionExprent)this.right).getFuncType() == FunctionExprent.FunctionType.CAST && func.doesCast() && func.getLstOperands().get(1).getExprType().equals(left)) {
            needsCast = false;
        }
        if (!needsCast && ExprProcessor.doesContravarianceNeedCast(left, right)) {
            needsCast = true;
        }
        if (!needsCast) {
            return;
        }
        if (precedence >= FunctionExprent.FunctionType.CAST.precedence) {
            buf.enclose("(", ")");
        }
        buf.prepend("(" + ExprProcessor.getCastTypeName(left) + ")");
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.left) {
            this.left = newExpr;
        }
        if (oldExpr == this.right) {
            this.right = newExpr;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssignmentExprent)) {
            return false;
        }
        AssignmentExprent as = (AssignmentExprent)o;
        return InterpreterUtil.equalObjects(this.left, as.getLeft()) && InterpreterUtil.equalObjects(this.right, as.getRight()) && this.condType == as.getCondType();
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        AssignmentExprent.measureBytecode(values, this.left);
        AssignmentExprent.measureBytecode(values, this.right);
        this.measureBytecode(values);
    }

    public Exprent getLeft() {
        return this.left;
    }

    public Exprent getRight() {
        return this.right;
    }

    public void setRight(Exprent right) {
        this.right = right;
    }

    public FunctionExprent.FunctionType getCondType() {
        return this.condType;
    }

    public void setCondType(FunctionExprent.FunctionType condType) {
        this.condType = condType;
    }
}

