/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.TextBuffer;
import org.jetbrains.java.decompiler.util.TextUtil;

public class ConstExprent
extends Exprent {
    private static final Map<Integer, String> CHAR_ESCAPES;
    private static final Map<Double, Function<BitSet, TextBuffer>> UNINLINED_DOUBLES;
    private static final Map<Float, Function<BitSet, TextBuffer>> UNINLINED_FLOATS;
    private static final Set<Object> NO_PAREN_VALUES;
    private VarType constType;
    private final Object value;
    private final boolean boolPermitted;
    private boolean wasCondy = false;

    public ConstExprent(int val, boolean boolPermitted, BitSet bytecodeOffsets) {
        this(ConstExprent.guessType(val, boolPermitted), (Object)val, boolPermitted, bytecodeOffsets);
    }

    public ConstExprent(VarType constType, Object value, BitSet bytecodeOffsets) {
        this(constType, value, false, bytecodeOffsets);
    }

    public ConstExprent(VarType constType, Object value, BitSet bytecodeOffsets, boolean wasCondy) {
        this(constType, value, false, bytecodeOffsets);
        this.wasCondy = wasCondy;
    }

    private ConstExprent(VarType constType, Object value, boolean boolPermitted, BitSet bytecodeOffsets) {
        super(Exprent.Type.CONST);
        this.constType = constType;
        this.value = value;
        this.boolPermitted = boolPermitted;
        this.addBytecodeOffsets(bytecodeOffsets);
        if (constType.equals(VarType.VARTYPE_CLASS) && value != null) {
            String stringVal;
            List<VarType> args = Collections.singletonList(new VarType(stringVal, !(stringVal = value.toString()).startsWith("[")));
            this.constType = new GenericType(constType.type, constType.arrayDim, constType.value, null, args, 4);
        }
    }

    private static VarType guessType(int val, boolean boolPermitted) {
        if (boolPermitted) {
            VarType constType = VarType.VARTYPE_BOOLEAN;
            if (val != 0 && val != 1) {
                constType = constType.copy(true);
            }
            return constType;
        }
        if (0 <= val && val <= 127) {
            return VarType.VARTYPE_BYTECHAR;
        }
        if (-128 <= val && val <= 127) {
            return VarType.VARTYPE_BYTE;
        }
        if (0 <= val && val <= Short.MAX_VALUE) {
            return VarType.VARTYPE_SHORTCHAR;
        }
        if (Short.MIN_VALUE <= val && val <= Short.MAX_VALUE) {
            return VarType.VARTYPE_SHORT;
        }
        if (0 <= val && val <= 65535) {
            return VarType.VARTYPE_CHAR;
        }
        return VarType.VARTYPE_INT;
    }

    private static double gcd(double a, double b) {
        return b == 0.0 ? a : ConstExprent.gcd(b, a % b);
    }

    @Override
    public Exprent copy() {
        return new ConstExprent(this.constType, this.value, this.bytecode, this.wasCondy);
    }

    @Override
    public VarType getExprType() {
        return this.constType;
    }

    @Override
    public int getExprentUse() {
        return 3;
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> list) {
        return list;
    }

    @Override
    public TextBuffer toJava(int indent) {
        boolean literal = DecompilerContext.getOption("lit");
        boolean ascii = DecompilerContext.getOption("asc");
        TextBuffer buf = new TextBuffer();
        buf.addBytecodeMapping(this.bytecode);
        if (this.wasCondy) {
            buf.append("/* $QF: constant dynamic */ ");
        }
        if (this.constType.type != 13 && this.value == null) {
            return buf.append(ExprProcessor.getCastTypeName(this.constType));
        }
        VarType unboxed = VarType.UNBOXING_TYPES.getOrDefault(this.constType, this.constType);
        switch (unboxed.type) {
            case 7: {
                return buf.append(Boolean.toString((Integer)this.value != 0));
            }
            case 1: {
                Integer val = (Integer)this.value;
                String ret = CHAR_ESCAPES.get(val);
                if (ret == null) {
                    char c = (char)val.intValue();
                    ret = ConstExprent.isPrintableAscii(c) || !ascii && TextUtil.isPrintableUnicode(c) ? String.valueOf(c) : TextUtil.charToUnicodeLiteral(c);
                }
                return buf.append(ret).enclose("'", "'");
            }
            case 0: 
            case 4: 
            case 6: 
            case 15: 
            case 16: {
                int intVal = (Integer)this.value;
                if (!literal) {
                    if (intVal == Integer.MAX_VALUE) {
                        return buf.append(new FieldExprent("MAX_VALUE", "java/lang/Integer", true, null, FieldDescriptor.INTEGER_DESCRIPTOR, this.bytecode).toJava(0));
                    }
                    if (intVal == Integer.MIN_VALUE) {
                        return buf.append(new FieldExprent("MIN_VALUE", "java/lang/Integer", true, null, FieldDescriptor.INTEGER_DESCRIPTOR, this.bytecode).toJava(0));
                    }
                }
                return buf.append(this.value.toString());
            }
            case 5: {
                long longVal = (Long)this.value;
                if (!literal) {
                    if (longVal == Long.MAX_VALUE) {
                        return buf.append(new FieldExprent("MAX_VALUE", "java/lang/Long", true, null, FieldDescriptor.LONG_DESCRIPTOR, this.bytecode).toJava(0));
                    }
                    if (longVal == Long.MIN_VALUE) {
                        return buf.append(new FieldExprent("MIN_VALUE", "java/lang/Long", true, null, FieldDescriptor.LONG_DESCRIPTOR, this.bytecode).toJava(0));
                    }
                }
                return buf.append(this.value.toString()).append('L');
            }
            case 3: {
                float floatVal = ((Float)this.value).floatValue();
                if (!literal) {
                    if (Float.isNaN(floatVal)) {
                        return buf.append(new FieldExprent("NaN", "java/lang/Float", true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0));
                    }
                    if (UNINLINED_FLOATS.containsKey(Float.valueOf(floatVal))) {
                        return buf.append(UNINLINED_FLOATS.get(Float.valueOf(floatVal)).apply(this.bytecode));
                    }
                } else {
                    if (Float.isNaN(floatVal)) {
                        return buf.append("0.0F / 0.0F");
                    }
                    if (floatVal == Float.POSITIVE_INFINITY) {
                        return buf.append("1.0F / 0.0F");
                    }
                    if (floatVal == Float.NEGATIVE_INFINITY) {
                        return buf.append("-1.0F / 0.0F");
                    }
                }
                return buf.append(ConstExprent.trimZeros(Float.toString(floatVal))).append('F');
            }
            case 2: {
                double doubleVal = (Double)this.value;
                if (!literal) {
                    if (Double.isNaN(doubleVal)) {
                        return buf.append(new FieldExprent("NaN", "java/lang/Double", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0));
                    }
                    if (UNINLINED_DOUBLES.containsKey(doubleVal)) {
                        return buf.append(UNINLINED_DOUBLES.get(doubleVal).apply(this.bytecode));
                    }
                    float floatRepresentation = (float)doubleVal;
                    if ((double)floatRepresentation == doubleVal && Float.toString(floatRepresentation).length() < Double.toString(doubleVal).length()) {
                        if (UNINLINED_FLOATS.containsKey(Float.valueOf(floatRepresentation))) {
                            return buf.append(UNINLINED_FLOATS.get(Float.valueOf(floatRepresentation)).apply(this.bytecode));
                        }
                        return buf.append(Float.toString(floatRepresentation)).append("F");
                    }
                } else {
                    if (Double.isNaN(doubleVal)) {
                        return buf.append("0.0 / 0.0");
                    }
                    if (doubleVal == Double.POSITIVE_INFINITY) {
                        return buf.append("1.0 / 0.0");
                    }
                    if (doubleVal == Double.NEGATIVE_INFINITY) {
                        return buf.append("-1.0 / 0.0");
                    }
                }
                return buf.append(ConstExprent.trimZeros(this.value.toString()));
            }
            case 13: {
                return buf.append("null");
            }
            case 8: {
                String stringVal;
                if (this.constType.equals(VarType.VARTYPE_STRING)) {
                    return buf.append(ConstExprent.convertStringToJava(this.value.toString(), ascii)).enclose("\"", "\"");
                }
                if (!this.constType.equals(VarType.VARTYPE_CLASS)) break;
                VarType type = new VarType(stringVal, !(stringVal = this.value.toString()).startsWith("["));
                return buf.append(ExprProcessor.getCastTypeName(type)).append(".class");
            }
        }
        buf.convertToStringAndAllowDataDiscard();
        throw new RuntimeException("invalid constant type: " + this.constType);
    }

    @Override
    public int getPrecedence() {
        if (this.value == null || DecompilerContext.getOption("lit")) {
            return super.getPrecedence();
        }
        VarType unboxed = VarType.UNBOXING_TYPES.getOrDefault(this.constType, this.constType);
        switch (unboxed.type) {
            case 3: {
                float floatVal = ((Float)this.value).floatValue();
                if (!UNINLINED_FLOATS.containsKey(Float.valueOf(floatVal)) || NO_PAREN_VALUES.contains(Float.valueOf(floatVal))) break;
                return 4;
            }
            case 2: {
                double doubleVal = (Double)this.value;
                if (!UNINLINED_DOUBLES.containsKey(doubleVal) || NO_PAREN_VALUES.contains(doubleVal)) break;
                return 4;
            }
        }
        return super.getPrecedence();
    }

    private static TextBuffer getPiDouble(BitSet bytecode) {
        return ConstExprent.getDouble(bytecode, "PI", "java/lang/Math");
    }

    private static TextBuffer getDouble(BitSet bytecode, String name, String className) {
        return new FieldExprent(name, className, true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, bytecode).toJava(0);
    }

    private static TextBuffer getFloat(BitSet bytecode, String name, String className) {
        return new FieldExprent(name, className, true, null, FieldDescriptor.FLOAT_DESCRIPTOR, bytecode).toJava(0);
    }

    private static String trimZeros(String value) {
        int i;
        for (i = value.length() - 1; i >= 0 && value.charAt(i) == '0'; --i) {
        }
        if (value.charAt(i) == '.') {
            ++i;
        }
        return value.substring(0, i + 1);
    }

    public boolean isNull() {
        return 13 == this.constType.type;
    }

    public static String convertStringToJava(String value, boolean ascii) {
        char[] arr = value.toCharArray();
        StringBuilder buffer = new StringBuilder(arr.length);
        block9: for (char c : arr) {
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    buffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block9;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block9;
                }
                default: {
                    if (ConstExprent.isPrintableAscii(c) || !ascii && TextUtil.isPrintableUnicode(c)) {
                        buffer.append(c);
                        continue block9;
                    }
                    buffer.append(TextUtil.charToUnicodeLiteral(c));
                }
            }
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstExprent)) {
            return false;
        }
        ConstExprent cn = (ConstExprent)o;
        return InterpreterUtil.equalObjects(this.constType, cn.getConstType()) && InterpreterUtil.equalObjects(this.value, cn.getValue());
    }

    public int hashCode() {
        int result = this.constType != null ? this.constType.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public boolean hasBooleanValue() {
        switch (this.constType.type) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                int value = (Integer)this.value;
                return value == 0 || DecompilerContext.getOption("bto") && value == 1;
            }
        }
        return false;
    }

    public boolean hasValueOne() {
        switch (this.constType.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                return ((Number)this.value).intValue() == 1;
            }
        }
        return false;
    }

    public static ConstExprent getZeroConstant(int type) {
        switch (type) {
            case 4: {
                return new ConstExprent(VarType.VARTYPE_INT, 0, null);
            }
            case 5: {
                return new ConstExprent(VarType.VARTYPE_LONG, 0L, null);
            }
            case 2: {
                return new ConstExprent(VarType.VARTYPE_DOUBLE, 0.0, null);
            }
            case 3: {
                return new ConstExprent(VarType.VARTYPE_FLOAT, Float.valueOf(0.0f), null);
            }
        }
        throw new RuntimeException("Invalid argument: " + type);
    }

    public VarType getConstType() {
        return this.constType;
    }

    public void setConstType(VarType constType) {
        this.constType = constType;
    }

    public void adjustConstType(VarType expectedType) {
        if ((expectedType.equals(VarType.VARTYPE_CHAR) || expectedType.equals(VarType.VARTYPE_CHARACTER)) && (this.constType.equals(VarType.VARTYPE_BYTECHAR) || this.constType.equals(VarType.VARTYPE_SHORTCHAR))) {
            int intValue = this.getIntValue();
            if (ConstExprent.isPrintableAscii(intValue) || CHAR_ESCAPES.containsKey(intValue)) {
                this.setConstType(VarType.VARTYPE_CHAR);
            }
        } else if ((expectedType.equals(VarType.VARTYPE_INT) || expectedType.equals(VarType.VARTYPE_INTEGER)) && this.constType.typeFamily == 2) {
            this.setConstType(VarType.VARTYPE_INT);
        }
    }

    private static boolean isPrintableAscii(int c) {
        return c >= 32 && c < 127;
    }

    public Object getValue() {
        return this.value;
    }

    public int getIntValue() {
        return (Integer)this.value;
    }

    public boolean isBoolPermitted() {
        return this.boolPermitted;
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        this.measureBytecode(values);
    }

    public ConstExprent setWasCondy(boolean wasCondy) {
        this.wasCondy = wasCondy;
        return this;
    }

    @Override
    public String toString() {
        return "const(" + this.toJava(0).convertToStringAndAllowDataDiscard() + ")";
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        for (Map.Entry<IMatchable.MatchProperties, MatchNode.RuleValue> rule : matchNode.getRules().entrySet()) {
            MatchNode.RuleValue value = rule.getValue();
            IMatchable.MatchProperties key = rule.getKey();
            if (!(key == IMatchable.MatchProperties.EXPRENT_CONSTTYPE ? !value.value.equals(this.constType) : key == IMatchable.MatchProperties.EXPRENT_CONSTVALUE && value.isVariable() && !engine.checkAndSetVariableValue(value.value.toString(), this.value))) continue;
            return false;
        }
        return true;
    }

    static {
        int finalI;
        int i;
        CHAR_ESCAPES = new HashMap<Integer, String>();
        UNINLINED_DOUBLES = new HashMap<Double, Function<BitSet, TextBuffer>>();
        UNINLINED_FLOATS = new HashMap<Float, Function<BitSet, TextBuffer>>();
        NO_PAREN_VALUES = new HashSet<Object>();
        CHAR_ESCAPES.put(8, "\\b");
        CHAR_ESCAPES.put(9, "\\t");
        CHAR_ESCAPES.put(10, "\\n");
        CHAR_ESCAPES.put(12, "\\f");
        CHAR_ESCAPES.put(13, "\\r");
        CHAR_ESCAPES.put(39, "\\'");
        CHAR_ESCAPES.put(92, "\\\\");
        UNINLINED_DOUBLES.put(Math.E, bytecode -> ConstExprent.getDouble(bytecode, "E", "java/lang/Math"));
        UNINLINED_DOUBLES.put(-2.718281828459045, bytecode -> ConstExprent.getDouble(bytecode, "E", "java/lang/Math").prepend("-"));
        UNINLINED_DOUBLES.put(Math.PI, ConstExprent::getPiDouble);
        UNINLINED_DOUBLES.put(-Math.PI, bytecode -> ConstExprent.getPiDouble(bytecode).prepend("-"));
        NO_PAREN_VALUES.addAll(UNINLINED_DOUBLES.keySet());
        UNINLINED_DOUBLES.keySet().forEach(d -> NO_PAREN_VALUES.add(Float.valueOf(d.floatValue())));
        for (i = 2; i <= 20; ++i) {
            finalI = i;
            UNINLINED_DOUBLES.put(Math.PI / (double)i, bytecode -> ConstExprent.getPiDouble(bytecode).append(" / " + finalI));
            UNINLINED_DOUBLES.put(-Math.PI / (double)i, bytecode -> ConstExprent.getPiDouble(bytecode).append(" / " + finalI).prepend("-"));
        }
        for (i = 2; i <= 20; ++i) {
            finalI = i;
            UNINLINED_DOUBLES.put(Math.PI * (double)i, bytecode -> ConstExprent.getPiDouble(bytecode).append(" * " + finalI));
            UNINLINED_DOUBLES.put(-Math.PI * (double)i, bytecode -> ConstExprent.getPiDouble(bytecode).append(" * " + finalI).prepend("-"));
        }
        for (double numerator = 2.0; numerator < 13.0; numerator += 1.0) {
            for (double denominator = 2.0; denominator < 13.0; denominator += 1.0) {
                double gcd = ConstExprent.gcd(numerator, denominator);
                if (gcd != 1.0) continue;
                double finalNumerator = numerator;
                double finalDenominator = denominator;
                UNINLINED_DOUBLES.put(Math.PI * (numerator / denominator), bytecode -> ConstExprent.getPiDouble(bytecode).append(" * " + finalNumerator + " / " + finalDenominator));
                UNINLINED_DOUBLES.put(-Math.PI * (numerator / denominator), bytecode -> ConstExprent.getPiDouble(bytecode).append(" * " + finalNumerator + " / " + finalDenominator).prepend("-"));
                if ((float)Math.PI * (float)numerator / (float)denominator == (float)(Math.PI * numerator / denominator)) continue;
                UNINLINED_FLOATS.put(Float.valueOf((float)Math.PI * ((float)numerator / (float)denominator)), bytecode -> ConstExprent.getPiDouble(bytecode).append(" * " + finalNumerator + "F / " + finalDenominator + "F").prepend("(float) "));
                UNINLINED_FLOATS.put(Float.valueOf((float)(-Math.PI) * ((float)numerator / (float)denominator)), bytecode -> ConstExprent.getPiDouble(bytecode).append(" * " + finalNumerator + "F / " + finalDenominator + "F").prepend("(float) -"));
            }
        }
        UNINLINED_DOUBLES.put(57.29577951308232, bytecode -> ConstExprent.getPiDouble(bytecode).prepend("180.0 / "));
        UNINLINED_DOUBLES.put(-57.29577951308232, bytecode -> ConstExprent.getPiDouble(bytecode).prepend("-180.0 / "));
        UNINLINED_FLOATS.put(Float.valueOf(57.29578f), bytecode -> ConstExprent.getPiDouble(bytecode).prepend("180.0F / "));
        UNINLINED_FLOATS.put(Float.valueOf(-57.29578f), bytecode -> ConstExprent.getPiDouble(bytecode).prepend("-180.0F / "));
        UNINLINED_FLOATS.put(Float.valueOf(57.295776f), bytecode -> ConstExprent.getPiDouble(bytecode).prepend("180.0F / (float)"));
        UNINLINED_FLOATS.put(Float.valueOf(-57.295776f), bytecode -> ConstExprent.getPiDouble(bytecode).prepend("-180.0F / (float)"));
        UNINLINED_DOUBLES.put(Math.PI / 180, bytecode -> ConstExprent.getPiDouble(bytecode).append(" / 180.0"));
        UNINLINED_DOUBLES.put(-Math.PI / 180, bytecode -> ConstExprent.getPiDouble(bytecode).append(" / 180.0").prepend("-"));
        UNINLINED_FLOATS.put(Float.valueOf((float)Math.PI / 180), bytecode -> ConstExprent.getPiDouble(bytecode).append(" / 180.0").prepend("(float) "));
        UNINLINED_FLOATS.put(Float.valueOf((float)(-Math.PI) / 180), bytecode -> ConstExprent.getPiDouble(bytecode).append(" / 180.0").prepend("-").prepend("(float) "));
        UNINLINED_DOUBLES.forEach((key, valueFunction) -> UNINLINED_FLOATS.put(Float.valueOf(key.floatValue()), bytecode -> {
            TextBuffer doubleValue = (TextBuffer)valueFunction.apply(bytecode);
            if (doubleValue.count(" ", 0) > 0) {
                NO_PAREN_VALUES.add(Float.valueOf(key.floatValue()));
                doubleValue.prepend("(").append(")");
            }
            return doubleValue.prepend("(float) ");
        }));
        UNINLINED_DOUBLES.put(Double.POSITIVE_INFINITY, bytecode -> ConstExprent.getDouble(bytecode, "POSITIVE_INFINITY", "java/lang/Double"));
        UNINLINED_DOUBLES.put(Double.NEGATIVE_INFINITY, bytecode -> ConstExprent.getDouble(bytecode, "NEGATIVE_INFINITY", "java/lang/Double"));
        UNINLINED_DOUBLES.put((Double)Double.MAX_VALUE, bytecode -> ConstExprent.getDouble(bytecode, "MAX_VALUE", "java/lang/Double"));
        UNINLINED_DOUBLES.put((Double)Double.MIN_NORMAL, bytecode -> ConstExprent.getDouble(bytecode, "MIN_NORMAL", "java/lang/Double"));
        UNINLINED_DOUBLES.put((Double)Double.MIN_VALUE, bytecode -> ConstExprent.getDouble(bytecode, "MIN_VALUE", "java/lang/Double"));
        UNINLINED_DOUBLES.put(-1.7976931348623157E308, bytecode -> ConstExprent.getDouble(bytecode, "MAX_VALUE", "java/lang/Double").prepend("-"));
        UNINLINED_DOUBLES.put(-2.2250738585072014E-308, bytecode -> ConstExprent.getDouble(bytecode, "MIN_NORMAL", "java/lang/Double").prepend("-"));
        UNINLINED_DOUBLES.put(-4.9E-324, bytecode -> ConstExprent.getDouble(bytecode, "MIN_VALUE", "java/lang/Double").prepend("-"));
        UNINLINED_FLOATS.put(Float.valueOf(Float.POSITIVE_INFINITY), bytecode -> ConstExprent.getFloat(bytecode, "POSITIVE_INFINITY", "java/lang/Float"));
        UNINLINED_FLOATS.put(Float.valueOf(Float.NEGATIVE_INFINITY), bytecode -> ConstExprent.getFloat(bytecode, "NEGATIVE_INFINITY", "java/lang/Float"));
        UNINLINED_FLOATS.put(Float.valueOf(Float.MAX_VALUE), bytecode -> ConstExprent.getFloat(bytecode, "MAX_VALUE", "java/lang/Float"));
        UNINLINED_FLOATS.put(Float.valueOf(Float.MIN_NORMAL), bytecode -> ConstExprent.getFloat(bytecode, "MIN_NORMAL", "java/lang/Float"));
        UNINLINED_FLOATS.put(Float.valueOf(Float.MIN_VALUE), bytecode -> ConstExprent.getFloat(bytecode, "MIN_VALUE", "java/lang/Float"));
        UNINLINED_FLOATS.put(Float.valueOf(-3.4028235E38f), bytecode -> ConstExprent.getFloat(bytecode, "MAX_VALUE", "java/lang/Float").prepend("-"));
        UNINLINED_FLOATS.put(Float.valueOf(-1.1754944E-38f), bytecode -> ConstExprent.getFloat(bytecode, "MIN_NORMAL", "java/lang/Float").prepend("-"));
        UNINLINED_FLOATS.put(Float.valueOf(-1.4E-45f), bytecode -> ConstExprent.getFloat(bytecode, "MIN_VALUE", "java/lang/Float").prepend("-"));
    }
}

