/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.BitSet;
import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.ListStack;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class IfExprent
extends Exprent {
    private Exprent condition;

    public IfExprent(Type ifType, ListStack<Exprent> stack, BitSet bytecodeOffsets) {
        this(null, bytecodeOffsets);
        if (ifType.ordinal() <= Type.LE.ordinal()) {
            stack.push(new ConstExprent(0, true, null));
        } else if (ifType.ordinal() <= Type.NONNULL.ordinal()) {
            stack.push(new ConstExprent(VarType.VARTYPE_NULL, null, null));
        }
        this.condition = ifType.functionType == null ? stack.pop() : new FunctionExprent(ifType.functionType, stack, bytecodeOffsets);
    }

    private IfExprent(Exprent condition, BitSet bytecodeOffsets) {
        super(Exprent.Type.IF);
        this.condition = condition;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    @Override
    public Exprent copy() {
        return new IfExprent(this.condition.copy(), this.bytecode);
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> lst) {
        lst.add(this.condition);
        return lst;
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer buf = this.condition.toJava(indent);
        buf.pushNewlineGroup(indent, 1);
        buf.appendPossibleNewline();
        buf.enclose("if (", ")");
        buf.appendPossibleNewline("", true);
        buf.popNewlineGroup();
        buf.addStartBytecodeMapping(this.bytecode);
        return buf;
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.condition) {
            this.condition = newExpr;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IfExprent)) {
            return false;
        }
        IfExprent ie = (IfExprent)o;
        return InterpreterUtil.equalObjects(this.condition, ie.getCondition());
    }

    public IfExprent negateIf() {
        this.condition = new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, this.condition, this.condition.bytecode);
        return this;
    }

    public Exprent getCondition() {
        return this.condition;
    }

    public void setCondition(Exprent condition) {
        this.condition = condition;
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        IfExprent.measureBytecode(values, this.condition);
        this.measureBytecode(values);
    }

    public static enum Type {
        EQ(FunctionExprent.FunctionType.EQ),
        NE(FunctionExprent.FunctionType.NE),
        LT(FunctionExprent.FunctionType.LT),
        GE(FunctionExprent.FunctionType.GE),
        GT(FunctionExprent.FunctionType.GT),
        LE(FunctionExprent.FunctionType.LE),
        NULL(FunctionExprent.FunctionType.EQ),
        NONNULL(FunctionExprent.FunctionType.NE),
        ICMPEQ(FunctionExprent.FunctionType.EQ),
        ICMPNE(FunctionExprent.FunctionType.NE),
        ICMPLT(FunctionExprent.FunctionType.LT),
        ICMPGE(FunctionExprent.FunctionType.GE),
        ICMPGT(FunctionExprent.FunctionType.GT),
        ICMPLE(FunctionExprent.FunctionType.LE),
        ACMPEQ(FunctionExprent.FunctionType.EQ),
        ACMPNE(FunctionExprent.FunctionType.NE),
        VALUE(null);

        private static final Type[] VALUES;
        final FunctionExprent.FunctionType functionType;

        private Type(FunctionExprent.FunctionType functionType) {
            this.functionType = functionType;
        }

        public Type getNegative() {
            if (this == VALUE) {
                throw new IllegalArgumentException();
            }
            return VALUES[this.ordinal() ^ 1];
        }

        static {
            VALUES = Type.values();
        }
    }
}

