/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.BitSet;
import java.util.List;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class MonitorExprent
extends Exprent {
    private boolean remove = false;
    private final Type monType;
    private Exprent value;

    public MonitorExprent(Type monType, Exprent value, BitSet bytecodeOffsets) {
        super(Exprent.Type.MONITOR);
        this.monType = monType;
        this.value = value;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    @Override
    public Exprent copy() {
        return new MonitorExprent(this.monType, this.value.copy(), this.bytecode);
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> lst) {
        lst.add(this.value);
        return lst;
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer buf = new TextBuffer();
        buf.addBytecodeMapping(this.bytecode);
        if (this.monType == Type.ENTER) {
            if (this.value instanceof ConstExprent && this.value.getExprType() == VarType.VARTYPE_NULL) {
                DecompilerContext.getLogger().writeMessage("Created invalid synchronize on null!", IFernflowerLogger.Severity.WARN);
            }
            return buf.append(this.value.toJava(indent)).enclose("synchronized(", ")");
        }
        return buf.append("// $QF: monitorexit");
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.value) {
            this.value = newExpr;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitorExprent)) {
            return false;
        }
        MonitorExprent me = (MonitorExprent)o;
        return this.monType == me.getMonType() && InterpreterUtil.equalObjects(this.value, me.getValue());
    }

    public Type getMonType() {
        return this.monType;
    }

    public Exprent getValue() {
        return this.value;
    }

    public boolean isRemovable() {
        return this.remove;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        MonitorExprent.measureBytecode(values, this.value);
        this.measureBytecode(values);
    }

    public static enum Type {
        ENTER,
        EXIT;

    }
}

