/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.YieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class SwitchExprent
extends Exprent {
    private final SwitchStatement backing;
    private final VarType type;
    private final boolean fallthrough;
    private final boolean standalone;

    public SwitchExprent(SwitchStatement backing, VarType type, boolean fallthrough, boolean standalone) {
        super(Exprent.Type.SWITCH);
        this.backing = backing;
        this.type = type;
        this.fallthrough = fallthrough;
        this.standalone = standalone;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TextBuffer toJava(int indent) {
        if (!this.backing.isPhantom()) {
            throw new IllegalStateException("Switch expression backing statement isn't phantom!");
        }
        TextBuffer buf = new TextBuffer();
        VarType switchType = this.backing.getHeadexprent().getExprType();
        boolean isExhaustive = this.isExhaustive();
        buf.append(this.backing.getHeadexprent().toJava(indent)).append(" {").appendLineSeparator();
        for (int i = 0; i < this.backing.getCaseStatements().size(); ++i) {
            Statement stat = this.backing.getCaseStatements().get(i);
            List<StatEdge> edges = this.backing.getCaseEdges().get(i);
            List<Exprent> values = this.backing.getCaseValues().get(i);
            Exprent guard = this.backing.getCaseGuards().size() > i ? this.backing.getCaseGuards().get(i) : null;
            boolean hasDefault = false;
            for (StatEdge edge : edges) {
                if (edge != this.backing.getDefaultEdge()) continue;
                if (isExhaustive && SwitchExprent.isSyntheticThrowEdge(edge)) break;
                hasDefault = true;
                break;
            }
            boolean hasEdge = false;
            for (int j = 0; j < edges.size(); ++j) {
                Exprent value;
                Exprent exprent = value = edges.get(j) == this.backing.getDefaultEdge() && values.size() <= j ? new ConstExprent(VarType.VARTYPE_NULL, null, null) : values.get(j);
                if (value == null || hasDefault && value.getExprType() != VarType.VARTYPE_NULL) continue;
                if (!hasEdge) {
                    buf.appendIndent(indent + 1).append("case ");
                } else {
                    buf.append(", ");
                }
                if (value instanceof ConstExprent && !this.standalone && !Objects.equals(value.getExprType(), VarType.VARTYPE_NULL)) {
                    value = value.copy();
                    ((ConstExprent)value).setConstType(switchType);
                }
                if (value instanceof FieldExprent && ((FieldExprent)value).isStatic()) {
                    buf.append(((FieldExprent)value).getName());
                } else if (value instanceof FunctionExprent && ((FunctionExprent)value).getFuncType() == FunctionExprent.FunctionType.INSTANCEOF) {
                    List<Exprent> operands = ((FunctionExprent)value).getLstOperands();
                    buf.append(operands.get(1).toJava(indent));
                    buf.append(" ");
                    ((VarExprent)operands.get(2)).setDefinition(false);
                    buf.append(operands.get(2).toJava(indent));
                } else {
                    buf.append(value.toJava(indent));
                }
                hasEdge = true;
            }
            if (guard != null) {
                buf.append(" when ").append(guard.toJava());
            }
            if (hasDefault) {
                if (!hasEdge) {
                    buf.appendIndent(indent + 1).append("default");
                } else {
                    buf.append(", default");
                }
                hasEdge = true;
            }
            if (!hasEdge) continue;
            buf.append(" -> ");
            boolean simple = stat instanceof BasicBlockStatement;
            if (stat.getExprents() != null && stat.getExprents().size() != 1) {
                simple = false;
            }
            if (simple) {
                Exprent exprent = stat.getExprents().get(0);
                if (exprent instanceof YieldExprent) {
                    Exprent content = ((YieldExprent)exprent).getContent();
                    if (content instanceof ConstExprent && !Objects.equals(content.getExprType(), VarType.VARTYPE_NULL)) {
                        ((ConstExprent)content).setConstType(this.type);
                    }
                    buf.append(content.toJava(indent).append(";"));
                } else if (exprent instanceof ExitExprent) {
                    ExitExprent exit = (ExitExprent)exprent;
                    if (exit.getExitType() != ExitExprent.Type.THROW) throw new IllegalStateException("Can't have return in switch expression");
                    buf.append(exit.toJava(indent).append(";"));
                } else {
                    buf.append(exprent.toJava(indent).append(";"));
                }
            } else {
                buf.append("{");
                buf.appendLineSeparator();
                TextBuffer statBuf = stat.toJava(indent + 2);
                buf.append(statBuf);
                buf.appendIndent(indent + 1).append("}");
            }
            buf.appendLineSeparator();
        }
        buf.appendIndent(indent).append("}");
        return buf;
    }

    private boolean isExhaustive() {
        HashSet<FieldExprent> enumValuesSeen = new HashSet<FieldExprent>();
        for (List<Exprent> caseValue : this.backing.getCaseValues()) {
            for (Exprent exprent : caseValue) {
                if (!(exprent instanceof FieldExprent) || !((FieldExprent)exprent).isStatic()) continue;
                enumValuesSeen.add((FieldExprent)exprent);
            }
        }
        StructClass enumTargetClass = DecompilerContext.getStructContext().getClass(this.backing.getHeadexprent().getExprType().value);
        return enumTargetClass != null && enumTargetClass.hasModifier(16384) && enumTargetClass.getFields().stream().filter(x -> x.hasModifier(16384)).map(StructField::getName).allMatch(fieldName -> enumValuesSeen.stream().anyMatch(found -> found.getName().equals(fieldName)));
    }

    private static boolean isSyntheticThrowEdge(StatEdge edge) {
        Statement target = edge.getDestination();
        List<Exprent> targetExprs = target.getExprents();
        if (targetExprs != null && targetExprs.size() == 1) {
            Exprent targetExpr = targetExprs.get(0);
            return targetExpr instanceof ExitExprent && ((ExitExprent)targetExpr).getExitType() == ExitExprent.Type.THROW && ((ExitExprent)targetExpr).getValue().getExprType().value.equals("java/lang/IncompatibleClassChangeError");
        }
        return false;
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    @Override
    public VarType getExprType() {
        return this.type;
    }

    @Override
    public Exprent copy() {
        return new SwitchExprent(this.backing, this.type, this.fallthrough, this.standalone);
    }

    @Override
    protected List<Exprent> getAllExprents(List<Exprent> list) {
        return list;
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        this.measureBytecode(values);
    }
}

